/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.palantir.javaformat.bootstrap.NativeImageFormatterService;
import com.palantir.javaformat.gradle.FormatDiff;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import com.palantir.javaformat.gradle.NativeImageFormatProviderPlugin;
import com.palantir.javaformat.gradle.NativeImageSupport;
import com.palantir.javaformat.gradle.PalantirJavaFormatIdeaPlugin;
import com.palantir.javaformat.gradle.PalantirJavaFormatProviderPlugin;
import com.palantir.javaformat.gradle.PalantirJavaFormatSpotlessPlugin;
import com.palantir.javaformat.java.FormatterService;
import java.io.File;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class PalantirJavaFormatPlugin
implements Plugin<Project> {
    @Nested
    protected abstract NativeImageSupport getNativeImageSupport();

    public void apply(Project project) {
        project.getRootProject().getPlugins().apply(PalantirJavaFormatProviderPlugin.class);
        project.getRootProject().getPlugins().apply(NativeImageFormatProviderPlugin.class);
        project.getRootProject().getPlugins().apply(PalantirJavaFormatIdeaPlugin.class);
        project.getPlugins().apply(PalantirJavaFormatSpotlessPlugin.class);
        project.getPlugins().withId("java", p -> project.getTasks().register("formatDiff", FormatDiffTask.class, task -> {
            if (this.getNativeImageSupport().isNativeImageConfigured()) {
                task.getNativeImage().fileProvider(PalantirJavaFormatPlugin.getNativeImplConfiguration(project));
            }
        }));
    }

    private static Provider<File> getNativeImplConfiguration(Project project) {
        return project.getRootProject().getConfigurations().named("palantirJavaFormatNative").map(FileCollection::getSingleFile);
    }

    public static abstract class FormatDiffTask
    extends DefaultTask {
        private static Logger log = Logging.getLogger(FormatDiffTask.class);

        @Optional
        @InputFile
        abstract RegularFileProperty getNativeImage();

        public FormatDiffTask() {
            this.setDescription("Format only chunks of files that appear in git diff");
            this.setGroup("Formatting");
        }

        @TaskAction
        public final void formatDiff() throws IOException, InterruptedException {
            if (this.getNativeImage().isPresent()) {
                log.info("Using the native-image formatter");
                FormatDiff.formatDiff(this.getProject().getProjectDir().toPath(), (FormatterService)new NativeImageFormatterService(((RegularFile)this.getNativeImage().get()).getAsFile().toPath()));
            } else {
                log.info("Using the Java-based formatter");
                JavaFormatExtension extension = (JavaFormatExtension)this.getProject().getRootProject().getExtensions().getByType(JavaFormatExtension.class);
                FormatterService formatterService = extension.serviceLoad();
                FormatDiff.formatDiff(this.getProject().getProjectDir().toPath(), formatterService);
            }
        }
    }
}

