/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.spotless.FormatterStep;
import com.palantir.javaformat.gradle.NativeImageSupport;
import com.palantir.javaformat.gradle.spotless.NativePalantirJavaFormatStep;
import com.palantir.javaformat.gradle.spotless.PalantirJavaFormatStep;
import com.palantir.javaformat.java.FormatterService;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Nested;

public abstract class SpotlessInterop
implements Action<JavaExtension> {
    private static final Logger logger = Logging.getLogger(SpotlessInterop.class);
    private final Supplier<FormatterService> formatterService;

    @Nested
    protected abstract NativeImageSupport getNativeImageSupport();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    public SpotlessInterop(Supplier<FormatterService> formatterService) {
        this.formatterService = formatterService;
    }

    public void execute(JavaExtension java) {
        java.addStep(this.spotlessJavaFormatStep());
    }

    private FormatterStep spotlessJavaFormatStep() {
        if (this.getNativeImageSupport().isNativeImageConfigured() && JavaVersion.current().compareTo((Enum)JavaVersion.VERSION_21) < 0) {
            logger.info("Using the native-image formatter");
            return NativePalantirJavaFormatStep.create(this.getConfigurations().getByName("palantirJavaFormatNative"));
        }
        logger.info("Using the Java-based formatter {}", (Object)JavaVersion.current());
        return PalantirJavaFormatStep.create(this.getConfigurations().getByName("palantirJavaFormat"), this.formatterService);
    }
}

