/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static void updateIdeaXmlFile(File configurationFile, Consumer<Node> configure) {
        Node rootNode;
        if (configurationFile.isFile()) {
            try {
                rootNode = new XmlParser().parse(configurationFile);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Couldn't parse existing configuration file: " + String.valueOf(configurationFile), e);
            }
        } else {
            rootNode = new Node(null, (Object)"project", (Map)ImmutableMap.of((Object)"version", (Object)"4"));
        }
        configure.accept(rootNode);
        try (BufferedWriter writer = Files.newWriter((File)configurationFile, (Charset)Charset.defaultCharset());
             PrintWriter printWriter = new PrintWriter(writer);){
            XmlNodePrinter nodePrinter = new XmlNodePrinter(printWriter);
            nodePrinter.setPreserveWhitespace(true);
            nodePrinter.print(rootNode);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write back to configuration file: " + String.valueOf(configurationFile), e);
        }
    }

    private XmlUtils() {
    }
}

