/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public final class NativePalantirJavaFormatStep {
    private static final Logger logger = Logging.getLogger(NativePalantirJavaFormatStep.class);
    private static final String NAME = "palantir-java-format";

    private NativePalantirJavaFormatStep() {
    }

    public static FormatterStep create(Configuration configuration) {
        return FormatterStep.createLazy((String)NAME, () -> new State(() -> ((Configuration)configuration).getSingleFile()), State::createFormat);
    }

    static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private FileSignature execSignature;
        private final transient Supplier<File> execSupplier;

        State(Supplier<File> supplier) {
            this.execSupplier = supplier;
        }

        String format(ProcessRunner runner, String input) throws IOException, InterruptedException {
            File execFile = this.execSupplier.get();
            logger.info("Using native-image at {}", (Object)execFile);
            this.execSignature = FileSignature.signAsSet((File[])new File[]{execFile});
            List<String> argumentsWithPathToExe = List.of(this.execSignature.getOnlyFile().getAbsolutePath(), "--palantir", "-");
            return runner.exec(input.getBytes(StandardCharsets.UTF_8), argumentsWithPathToExe).assertExitZero(StandardCharsets.UTF_8);
        }

        FormatterFunc.Closeable createFormat() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of((AutoCloseable)runner, this::format);
        }
    }
}

