/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.palantir.javaformat.java.FormatterService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import org.gradle.api.artifacts.Configuration;

public final class PalantirJavaFormatStep {
    private static final String IMPL_CLASS = "com.palantir.javaformat.java.Formatter";
    private static final String NAME = "palantir-java-format";

    private PalantirJavaFormatStep() {
    }

    public static FormatterStep create(Configuration palantirJavaFormat, Supplier<FormatterService> memoizedService) {
        PalantirJavaFormatStep.ensureImplementationNotDirectlyLoadable();
        return FormatterStep.createLazy((String)NAME, () -> new State(() -> ((Configuration)palantirJavaFormat).getFiles(), memoizedService), State::createFormat);
    }

    private static void ensureImplementationNotDirectlyLoadable() {
        try {
            PalantirJavaFormatStep.class.getClassLoader().loadClass(IMPL_CLASS);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        throw new RuntimeException("Expected not be be able to load com.palantir.javaformat.java.Formatter via main class loader but was able to. Please ensure that `buildscript.configurations.classpath` doesn't depend on `com.palantir.javaformat:palantir-java-format`.");
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String stepName = "palantir-java-format";
        private FileSignature jarsSignature;
        private final transient Supplier<Iterable<File>> jarsSupplier;
        private final transient Supplier<FormatterService> memoizedFormatter;

        State(Supplier<Iterable<File>> jarsSupplier, Supplier<FormatterService> memoizedFormatter) {
            this.jarsSupplier = jarsSupplier;
            this.memoizedFormatter = memoizedFormatter;
        }

        FormatterFunc createFormat() {
            return input -> {
                try {
                    Iterable<File> jars = this.jarsSupplier.get();
                    this.jarsSignature = FileSignature.signAsSet(jars);
                    return this.memoizedFormatter.get().formatSourceReflowStringsAndFixImports(input);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }
    }
}

