/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.palantir.javaformat.gradle.ConfigureJavaFormatterXml;
import com.palantir.javaformat.gradle.PalantirJavaFormatProviderPlugin;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.xml.sax.SAXException;

public final class PalantirJavaFormatIdeaPlugin
implements Plugin<Project> {
    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-idea to the root project");
        rootProject.getPlugins().apply(PalantirJavaFormatProviderPlugin.class);
        rootProject.getPluginManager().withPlugin("idea", ideaPlugin -> {
            Configuration implConfiguration = rootProject.getConfigurations().getByName("palantirJavaFormat");
            PalantirJavaFormatIdeaPlugin.configureLegacyIdea(rootProject, implConfiguration);
            PalantirJavaFormatIdeaPlugin.configureIntelliJImport(rootProject, implConfiguration);
        });
    }

    private static void configureLegacyIdea(Project project, Configuration implConfiguration) {
        IdeaModel ideaModel = (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
        ideaModel.getProject().getIpr().withXml(xmlProvider -> {
            List<URI> uris = implConfiguration.getFiles().stream().map(File::toURI).collect(Collectors.toList());
            ConfigureJavaFormatterXml.configureJavaFormat(xmlProvider.asNode(), uris);
            ConfigureJavaFormatterXml.configureExternalDependencies(xmlProvider.asNode());
        });
    }

    private static void configureIntelliJImport(Project project, Configuration implConfiguration) {
        if (!Boolean.getBoolean("idea.active")) {
            return;
        }
        project.getGradle().projectsEvaluated(gradle -> {
            List uris = implConfiguration.getFiles().stream().map(File::toURI).collect(Collectors.toList());
            PalantirJavaFormatIdeaPlugin.createOrUpdateIdeaXmlFile(project.file((Object)".idea/palantir-java-format.xml"), node -> ConfigureJavaFormatterXml.configureJavaFormat(node, uris));
            PalantirJavaFormatIdeaPlugin.createOrUpdateIdeaXmlFile(project.file((Object)".idea/externalDependencies.xml"), node -> ConfigureJavaFormatterXml.configureExternalDependencies(node));
        });
    }

    private static void createOrUpdateIdeaXmlFile(File configurationFile, Consumer<Node> configure) {
        Node rootNode;
        if (configurationFile.isFile()) {
            try {
                rootNode = new XmlParser().parse(configurationFile);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Couldn't parse existing configuration file: " + configurationFile, e);
            }
        } else {
            rootNode = new Node(null, (Object)"project", (Map)ImmutableMap.of((Object)"version", (Object)"4"));
        }
        configure.accept(rootNode);
        try (BufferedWriter writer = Files.newWriter((File)configurationFile, (Charset)Charset.defaultCharset());
             PrintWriter printWriter = new PrintWriter(writer);){
            XmlNodePrinter nodePrinter = new XmlNodePrinter(printWriter);
            nodePrinter.setPreserveWhitespace(true);
            nodePrinter.print(rootNode);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write back to configuration file: " + configurationFile, e);
        }
    }
}

