/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.bootstrap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.base.Joiner;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.palantir.javaformat.bootstrap.FormatterCommandRunner;
import com.palantir.javaformat.bootstrap.ImmutableFormatterCliArgs;
import com.palantir.javaformat.java.FormatterService;
import com.palantir.javaformat.java.Replacement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public final class BootstrappingFormatterService
implements FormatterService {
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new GuavaModule())).build();
    private static final String FORMATTER_MAIN_CLASS = "com.palantir.javaformat.java.Main";
    private final Path jdkPath;
    private final Integer jdkMajorVersion;
    private final List<Path> implementationClassPath;

    public BootstrappingFormatterService(Path jdkPath, Integer jdkMajorVersion, List<Path> implementationClassPath) {
        this.jdkPath = jdkPath;
        this.jdkMajorVersion = jdkMajorVersion;
        this.implementationClassPath = implementationClassPath;
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> ranges) {
        try {
            return this.getFormatReplacementsInternal(input, ranges);
        }
        catch (IOException e) {
            throw new RuntimeException("Error running formatter command", e);
        }
    }

    public String formatSourceReflowStringsAndFixImports(String input) {
        try {
            return this.formatSourceReflowStringsAndFixImportsInternal(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Error running formatter command", e);
        }
    }

    private ImmutableList<Replacement> getFormatReplacementsInternal(String input, Collection<Range<Integer>> ranges) throws IOException {
        ImmutableFormatterCliArgs command = FormatterCliArgs.builder().jdkPath(this.jdkPath).withJvmArgsForVersion(this.jdkMajorVersion).implementationClasspath(this.implementationClassPath).outputReplacements(true).characterRanges(ranges.stream().map(BootstrappingFormatterService::toStringRange).collect(Collectors.toList())).build();
        Optional<String> output = FormatterCommandRunner.runWithStdin(command.toArgs(), input);
        if (output.isEmpty() || output.get().isEmpty()) {
            return ImmutableList.of();
        }
        return (ImmutableList)MAPPER.readValue(output.get(), (TypeReference)new TypeReference<ImmutableList<Replacement>>(){});
    }

    private String formatSourceReflowStringsAndFixImportsInternal(String input) throws IOException {
        ImmutableFormatterCliArgs command = FormatterCliArgs.builder().jdkPath(this.jdkPath).withJvmArgsForVersion(this.jdkMajorVersion).implementationClasspath(this.implementationClassPath).outputReplacements(false).build();
        return FormatterCommandRunner.runWithStdin(command.toArgs(), input).orElse(input);
    }

    private static String toStringRange(Range<Integer> range) {
        int higher;
        int lower = range.lowerBoundType() == BoundType.CLOSED ? (Integer)range.lowerEndpoint() : (Integer)range.lowerEndpoint() + 1;
        int n = higher = range.upperBoundType() == BoundType.CLOSED ? (Integer)range.upperEndpoint() : (Integer)range.upperEndpoint() - 1;
        if (lower == higher) {
            return String.valueOf(lower);
        }
        return String.format("%s:%s", lower, higher);
    }

    @Value.Immutable
    static interface FormatterCliArgs {
        public Path jdkPath();

        public List<Path> implementationClasspath();

        public List<String> characterRanges();

        public List<String> jvmArgs();

        public boolean outputReplacements();

        default public List<String> toArgs() {
            ImmutableList.Builder args = ImmutableList.builder().add((Object)this.jdkPath().toAbsolutePath().toString()).addAll(this.jvmArgs()).add((Object[])new String[]{"-cp", this.implementationClasspath().stream().map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining(System.getProperty("path.separator")))}).add((Object)BootstrappingFormatterService.FORMATTER_MAIN_CLASS);
            if (!this.characterRanges().isEmpty()) {
                args.add((Object[])new String[]{"--character-ranges", Joiner.on((char)',').join(this.characterRanges())});
            }
            if (this.outputReplacements()) {
                args.add((Object)"--output-replacements");
            }
            return args.add((Object)"--palantir").add((Object)"-").build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        extends ImmutableFormatterCliArgs.Builder {
            Builder withJvmArgsForVersion(Integer majorJvmVersion) {
                if (majorJvmVersion >= 16) {
                    this.addJvmArgs("--add-exports", "jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "--add-exports", "jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED");
                }
                return this;
            }
        }
    }
}

