/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.bootstrap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.bootstrap.BootstrappingFormatterService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BootstrappingFormatterService.FormatterCliArgs", generator="Immutables")
@Immutable
final class ImmutableFormatterCliArgs
implements BootstrappingFormatterService.FormatterCliArgs {
    private final Path jdkPath;
    private final ImmutableList<Path> implementationClasspath;
    private final ImmutableList<String> characterRanges;
    private final ImmutableList<String> jvmArgs;
    private final boolean outputReplacements;

    private ImmutableFormatterCliArgs(Path jdkPath, ImmutableList<Path> implementationClasspath, ImmutableList<String> characterRanges, ImmutableList<String> jvmArgs, boolean outputReplacements) {
        this.jdkPath = jdkPath;
        this.implementationClasspath = implementationClasspath;
        this.characterRanges = characterRanges;
        this.jvmArgs = jvmArgs;
        this.outputReplacements = outputReplacements;
    }

    @Override
    public Path jdkPath() {
        return this.jdkPath;
    }

    public ImmutableList<Path> implementationClasspath() {
        return this.implementationClasspath;
    }

    public ImmutableList<String> characterRanges() {
        return this.characterRanges;
    }

    public ImmutableList<String> jvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public boolean outputReplacements() {
        return this.outputReplacements;
    }

    public final ImmutableFormatterCliArgs withJdkPath(Path value) {
        if (this.jdkPath == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "jdkPath");
        return new ImmutableFormatterCliArgs(newValue, this.implementationClasspath, this.characterRanges, this.jvmArgs, this.outputReplacements);
    }

    public final ImmutableFormatterCliArgs withImplementationClasspath(Path ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFormatterCliArgs(this.jdkPath, (ImmutableList<Path>)newValue, this.characterRanges, this.jvmArgs, this.outputReplacements);
    }

    public final ImmutableFormatterCliArgs withImplementationClasspath(Iterable<? extends Path> elements) {
        if (this.implementationClasspath == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFormatterCliArgs(this.jdkPath, (ImmutableList<Path>)newValue, this.characterRanges, this.jvmArgs, this.outputReplacements);
    }

    public final ImmutableFormatterCliArgs withCharacterRanges(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFormatterCliArgs(this.jdkPath, this.implementationClasspath, (ImmutableList<String>)newValue, this.jvmArgs, this.outputReplacements);
    }

    public final ImmutableFormatterCliArgs withCharacterRanges(Iterable<String> elements) {
        if (this.characterRanges == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFormatterCliArgs(this.jdkPath, this.implementationClasspath, (ImmutableList<String>)newValue, this.jvmArgs, this.outputReplacements);
    }

    public final ImmutableFormatterCliArgs withJvmArgs(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableFormatterCliArgs(this.jdkPath, this.implementationClasspath, this.characterRanges, (ImmutableList<String>)newValue, this.outputReplacements);
    }

    public final ImmutableFormatterCliArgs withJvmArgs(Iterable<String> elements) {
        if (this.jvmArgs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableFormatterCliArgs(this.jdkPath, this.implementationClasspath, this.characterRanges, (ImmutableList<String>)newValue, this.outputReplacements);
    }

    public final ImmutableFormatterCliArgs withOutputReplacements(boolean value) {
        if (this.outputReplacements == value) {
            return this;
        }
        return new ImmutableFormatterCliArgs(this.jdkPath, this.implementationClasspath, this.characterRanges, this.jvmArgs, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormatterCliArgs && this.equalTo((ImmutableFormatterCliArgs)another);
    }

    private boolean equalTo(ImmutableFormatterCliArgs another) {
        return this.jdkPath.equals(another.jdkPath) && this.implementationClasspath.equals(another.implementationClasspath) && this.characterRanges.equals(another.characterRanges) && this.jvmArgs.equals(another.jvmArgs) && this.outputReplacements == another.outputReplacements;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.jdkPath.hashCode();
        h += (h << 5) + this.implementationClasspath.hashCode();
        h += (h << 5) + this.characterRanges.hashCode();
        h += (h << 5) + this.jvmArgs.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.outputReplacements);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FormatterCliArgs").omitNullValues().add("jdkPath", (Object)this.jdkPath).add("implementationClasspath", this.implementationClasspath).add("characterRanges", this.characterRanges).add("jvmArgs", this.jvmArgs).add("outputReplacements", this.outputReplacements).toString();
    }

    public static ImmutableFormatterCliArgs copyOf(BootstrappingFormatterService.FormatterCliArgs instance) {
        if (instance instanceof ImmutableFormatterCliArgs) {
            return (ImmutableFormatterCliArgs)instance;
        }
        return new BootstrappingFormatterService.FormatterCliArgs.Builder().from(instance).build();
    }

    @Generated(from="BootstrappingFormatterService.FormatterCliArgs", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_JDK_PATH = 1L;
        private static final long INIT_BIT_OUTPUT_REPLACEMENTS = 2L;
        private long initBits = 3L;
        @Nullable
        private Path jdkPath;
        private ImmutableList.Builder<Path> implementationClasspath = ImmutableList.builder();
        private ImmutableList.Builder<String> characterRanges = ImmutableList.builder();
        private ImmutableList.Builder<String> jvmArgs = ImmutableList.builder();
        private boolean outputReplacements;

        public Builder() {
            if (!(this instanceof BootstrappingFormatterService.FormatterCliArgs.Builder)) {
                throw new UnsupportedOperationException("Use: new BootstrappingFormatterService.FormatterCliArgs.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder from(BootstrappingFormatterService.FormatterCliArgs instance) {
            Objects.requireNonNull(instance, "instance");
            this.jdkPath(instance.jdkPath());
            this.addAllImplementationClasspath(instance.implementationClasspath());
            this.addAllCharacterRanges(instance.characterRanges());
            this.addAllJvmArgs(instance.jvmArgs());
            this.outputReplacements(instance.outputReplacements());
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder jdkPath(Path jdkPath) {
            this.jdkPath = Objects.requireNonNull(jdkPath, "jdkPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addImplementationClasspath(Path element) {
            this.implementationClasspath.add((Object)element);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addImplementationClasspath(Path ... elements) {
            this.implementationClasspath.add((Object[])elements);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder implementationClasspath(Iterable<? extends Path> elements) {
            this.implementationClasspath = ImmutableList.builder();
            return this.addAllImplementationClasspath(elements);
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addAllImplementationClasspath(Iterable<? extends Path> elements) {
            this.implementationClasspath.addAll(elements);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addCharacterRanges(String element) {
            this.characterRanges.add((Object)element);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addCharacterRanges(String ... elements) {
            this.characterRanges.add((Object[])elements);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder characterRanges(Iterable<String> elements) {
            this.characterRanges = ImmutableList.builder();
            return this.addAllCharacterRanges(elements);
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addAllCharacterRanges(Iterable<String> elements) {
            this.characterRanges.addAll(elements);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addJvmArgs(String element) {
            this.jvmArgs.add((Object)element);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addJvmArgs(String ... elements) {
            this.jvmArgs.add((Object[])elements);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder jvmArgs(Iterable<String> elements) {
            this.jvmArgs = ImmutableList.builder();
            return this.addAllJvmArgs(elements);
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder addAllJvmArgs(Iterable<String> elements) {
            this.jvmArgs.addAll(elements);
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final BootstrappingFormatterService.FormatterCliArgs.Builder outputReplacements(boolean outputReplacements) {
            this.outputReplacements = outputReplacements;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (BootstrappingFormatterService.FormatterCliArgs.Builder)this;
        }

        public ImmutableFormatterCliArgs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormatterCliArgs(this.jdkPath, (ImmutableList<Path>)this.implementationClasspath.build(), (ImmutableList<String>)this.characterRanges.build(), (ImmutableList<String>)this.jvmArgs.build(), this.outputReplacements);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("jdkPath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("outputReplacements");
            }
            return "Cannot build FormatterCliArgs, some of required attributes are not set " + attributes;
        }
    }
}

