/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.palantir.javaformat.BreakBehaviour;
import com.palantir.javaformat.CloseOp;
import com.palantir.javaformat.FormattingError;
import com.palantir.javaformat.ImmutableOpsOutput;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.Input;
import com.palantir.javaformat.LastLevelBreakability;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.OpenOp;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.BreakTag;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.FillMode;
import com.palantir.javaformat.doc.NonBreakingSpace;
import com.palantir.javaformat.doc.State;
import com.palantir.javaformat.doc.Token;
import com.palantir.javaformat.java.FormatterDiagnostic;
import com.palantir.javaformat.java.InputMetadata;
import com.palantir.javaformat.java.InputMetadataBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

public final class OpsBuilder {
    private final Input input;
    private final List<Op> ops = new ArrayList<Op>();
    private final InputMetadataBuilder inputMetadataBuilder = new InputMetadataBuilder();
    private static final Indent.Const ZERO = Indent.Const.ZERO;
    private int tokenI = 0;
    private int inputPosition = Integer.MIN_VALUE;
    int depth = 0;
    private int lastPartialFormatBoundary = -1;
    private static final NonBreakingSpace SPACE = NonBreakingSpace.make();

    public int actualSize(int position, int length) {
        Input.Token startToken = (Input.Token)this.input.getPositionTokenMap().get((Comparable)Integer.valueOf(position));
        int start = startToken.getTok().getPosition();
        for (Input.Tok tok : startToken.getToksBefore()) {
            if (!tok.isComment()) continue;
            start = Math.min(start, tok.getPosition());
        }
        Input.Token endToken = (Input.Token)this.input.getPositionTokenMap().get((Comparable)Integer.valueOf(position + length - 1));
        int end = endToken.getTok().getPosition() + endToken.getTok().length();
        for (Input.Tok tok : endToken.getToksAfter()) {
            if (!tok.isComment()) continue;
            end = Math.max(end, tok.getPosition() + tok.length());
        }
        return end - start;
    }

    public Integer actualStartColumn(int position) {
        Input.Token startToken = (Input.Token)this.input.getPositionTokenMap().get((Comparable)Integer.valueOf(position));
        int start = startToken.getTok().getPosition();
        int line0 = this.input.getLineNumber(start);
        for (Input.Tok tok : startToken.getToksBefore()) {
            if (line0 != this.input.getLineNumber(tok.getPosition())) {
                return start;
            }
            if (!tok.isComment()) continue;
            start = Math.min(start, tok.getPosition());
        }
        return start;
    }

    private void add(Op op) {
        if (op instanceof OpenOp) {
            ++this.depth;
        } else if (op instanceof CloseOp) {
            --this.depth;
            if (this.depth < 0) {
                throw new IllegalStateException();
            }
        }
        this.ops.add(op);
    }

    public void addAll(List<Op> ops) {
        for (Op op : ops) {
            this.add(op);
        }
    }

    public OpsBuilder(Input input) {
        this.input = input;
    }

    public Input getInput() {
        return this.input;
    }

    public int depth() {
        return this.depth;
    }

    public void checkClosed(int previous) {
        if (this.depth != previous) {
            throw new FormattingError(this.diagnostic(String.format("saw %d unclosed ops", this.depth)));
        }
    }

    public FormatterDiagnostic diagnostic(String message) {
        return this.input.createDiagnostic(this.inputPosition, message);
    }

    public void sync(int inputPosition) {
        if (inputPosition > this.inputPosition) {
            ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
            int tokensN = tokens.size();
            this.inputPosition = inputPosition;
            if (this.tokenI < tokensN && inputPosition > ((Input.Token)tokens.get(this.tokenI)).getTok().getPosition()) {
                Input.Token token = (Input.Token)tokens.get(this.tokenI++);
                throw new FormattingError(this.diagnostic(String.format("did not generate token \"%s\"", token.getTok().getText())));
            }
        }
    }

    public void drain() {
        int inputPosition = this.input.getText().length() + 1;
        if (inputPosition > this.inputPosition) {
            ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
            int tokensN = tokens.size();
            while (this.tokenI < tokensN && inputPosition > ((Input.Token)tokens.get(this.tokenI)).getTok().getPosition()) {
                Input.Token token = (Input.Token)tokens.get(this.tokenI++);
                this.add(Token.make(token, Token.RealOrImaginary.IMAGINARY, ZERO, Optional.empty()));
            }
        }
        this.inputPosition = inputPosition;
        this.checkClosed(0);
    }

    public void open(Indent plusIndent) {
        this.add(OpenOp.make(plusIndent));
    }

    public void open(String debugName, Indent plusIndent) {
        this.add(OpenOp.builder().plusIndent(plusIndent).debugName(debugName).build());
    }

    public void open(Indent plusIndent, BreakBehaviour breakBehaviour, LastLevelBreakability breakabilityIfLastLevel) {
        this.add(OpenOp.builder().plusIndent(plusIndent).breakBehaviour(breakBehaviour).breakabilityIfLastLevel(breakabilityIfLastLevel).build());
    }

    public void open(OpenOp openOp) {
        this.add(openOp);
    }

    public void close() {
        this.add(CloseOp.make());
    }

    public Optional<String> peekToken() {
        return this.peekToken(0);
    }

    public boolean mostRecentTokenFollowedByNewline() {
        Preconditions.checkState((this.tokenI > 0 ? 1 : 0) != 0, (Object)"No token was emitted yet");
        return ((Input.Token)this.input.getTokens().get(this.tokenI - 1)).getToksAfter().stream().anyMatch(Input.Tok::isNewline);
    }

    public Optional<String> peekToken(int skip) {
        int idx = this.tokenI + skip;
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        return idx < tokens.size() ? Optional.of(((Input.Token)tokens.get(idx)).getTok().getOriginalText()) : Optional.empty();
    }

    public void guessToken(String token) {
        this.token(token, Token.RealOrImaginary.IMAGINARY, ZERO, Optional.empty());
    }

    public void token(String token, Token.RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        if (token.equals(this.peekToken().orElse(null))) {
            this.add(Token.make((Input.Token)tokens.get(this.tokenI++), Token.RealOrImaginary.REAL, plusIndentCommentsBefore, breakAndIndentTrailingComment));
        } else if (realOrImaginary == Token.RealOrImaginary.REAL) {
            throw new FormattingError(this.diagnostic(String.format("expected token: '%s'; generated %s instead", this.peekToken().orElse(null), token)));
        }
    }

    public void op(String op) {
        int opN = op.length();
        for (int i = 0; i < opN; ++i) {
            this.token(op.substring(i, i + 1), Token.RealOrImaginary.REAL, ZERO, Optional.empty());
        }
    }

    public void space() {
        this.add(NonBreakingSpace.make());
    }

    public void breakOp() {
        this.breakOp(FillMode.UNIFIED, "", ZERO);
    }

    public void breakOp(Indent plusIndent) {
        this.breakOp(FillMode.UNIFIED, "", plusIndent);
    }

    public void breakToFill() {
        this.breakOp(FillMode.INDEPENDENT, "", ZERO);
    }

    public void forcedBreak() {
        this.breakOp(FillMode.FORCED, "", ZERO);
    }

    public void forcedBreak(Indent plusIndent) {
        this.breakOp(FillMode.FORCED, "", plusIndent);
    }

    public void breakOp(String flat) {
        this.breakOp(FillMode.UNIFIED, flat, ZERO);
    }

    public void breakToFill(String flat) {
        this.breakOp(FillMode.INDEPENDENT, flat, ZERO);
    }

    public void breakOp(FillMode fillMode, String flat, Indent plusIndent) {
        this.breakOp(fillMode, flat, plusIndent, Optional.empty());
    }

    public void breakOp(FillMode fillMode, String flat, Indent plusIndent, Optional<BreakTag> optionalTag) {
        this.add(Break.make(fillMode, flat, plusIndent, optionalTag));
    }

    public void breakOp(Break breakOp) {
        this.add(breakOp);
    }

    public void markForPartialFormat() {
        if (this.lastPartialFormatBoundary == -1) {
            this.lastPartialFormatBoundary = this.tokenI;
            return;
        }
        if (this.tokenI == this.lastPartialFormatBoundary) {
            return;
        }
        Input.Token start = (Input.Token)this.input.getTokens().get(this.lastPartialFormatBoundary);
        Input.Token end = (Input.Token)this.input.getTokens().get(this.tokenI - 1);
        this.inputMetadataBuilder.markForPartialFormat(start, end);
        this.lastPartialFormatBoundary = this.tokenI;
    }

    public void blankLineWanted(BlankLineWanted wanted) {
        this.inputMetadataBuilder.blankLine(OpsBuilder.getI((Input.Token)this.input.getTokens().get(this.tokenI)), wanted);
    }

    private static int getI(Input.Token token) {
        for (Input.Tok tok : token.getToksBefore()) {
            if (tok.getIndex() < 0) continue;
            return tok.getIndex();
        }
        return token.getTok().getIndex();
    }

    public OpsOutput build() {
        this.markForPartialFormat();
        ArrayListMultimap tokOps = ArrayListMultimap.create();
        int opsN = this.ops.size();
        for (int i = 0; i < opsN; ++i) {
            int newlines;
            int j;
            Op op = this.ops.get(i);
            if (!(op instanceof Token)) continue;
            Token tokenOp = (Token)op;
            Input.Token token = tokenOp.getToken();
            for (j = i; 0 < j && this.ops.get(j - 1) instanceof OpenOp; --j) {
            }
            int k = i;
            while (k + 1 < opsN && this.ops.get(k + 1) instanceof CloseOp) {
                ++k;
            }
            if (tokenOp.realOrImaginary() == Token.RealOrImaginary.REAL) {
                newlines = 0;
                boolean space = false;
                boolean lastWasComment = false;
                boolean allowBlankAfterLastComment = false;
                for (Input.Tok tokBefore : token.getToksBefore()) {
                    if (tokBefore.isNewline()) {
                        ++newlines;
                        continue;
                    }
                    if (!tokBefore.isComment()) continue;
                    tokOps.put((Object)j, (Object)Break.make(tokBefore.isSlashSlashComment() ? FillMode.FORCED : FillMode.UNIFIED, "", tokenOp.getPlusIndentCommentsBefore()));
                    tokOps.putAll((Object)j, OpsBuilder.makeComment(tokBefore));
                    space = tokBefore.isSlashStarComment();
                    newlines = 0;
                    lastWasComment = true;
                    if (tokBefore.isJavadocComment()) {
                        tokOps.put((Object)j, (Object)Break.makeForced());
                    }
                    allowBlankAfterLastComment = tokBefore.isSlashSlashComment() || tokBefore.isSlashStarComment() && !tokBefore.isJavadocComment();
                }
                if (allowBlankAfterLastComment && newlines > 1) {
                    this.inputMetadataBuilder.blankLine(token.getTok().getIndex(), BlankLineWanted.YES);
                }
                if (lastWasComment && newlines > 0) {
                    tokOps.put((Object)j, (Object)Break.makeForced());
                } else if (space) {
                    tokOps.put((Object)j, (Object)SPACE);
                }
                boolean nonNlsCommentsAfterPlus = token.getToksAfter().stream().anyMatch(OpsBuilder::isNonNlsComment) && token.getTok().getText().equals("+") && k > 0 && this.ops.get(k - 1) instanceof Break;
                int tokAfterPos = nonNlsCommentsAfterPlus ? k - 1 : k + 1;
                for (Input.Tok tokAfter : token.getToksAfter()) {
                    boolean breakAfter;
                    if (!tokAfter.isComment()) continue;
                    boolean bl = breakAfter = tokAfter.isJavadocComment() || tokAfter.isSlashStarComment() && tokenOp.breakAndIndentTrailingComment().isPresent();
                    if (breakAfter) {
                        tokOps.put((Object)tokAfterPos, (Object)Break.make(FillMode.FORCED, "", tokenOp.breakAndIndentTrailingComment().orElse(Indent.Const.ZERO)));
                    } else {
                        tokOps.put((Object)tokAfterPos, (Object)SPACE);
                    }
                    tokOps.putAll((Object)tokAfterPos, OpsBuilder.makeComment(tokAfter));
                    if (!breakAfter) continue;
                    tokOps.put((Object)tokAfterPos, (Object)Break.make(FillMode.FORCED, "", ZERO));
                }
                continue;
            }
            newlines = 0;
            boolean lastWasComment = false;
            for (Input.Tok tokBefore : token.getToksBefore()) {
                if (tokBefore.isNewline()) {
                    ++newlines;
                } else if (tokBefore.isComment()) {
                    newlines = 0;
                    lastWasComment = tokBefore.isComment();
                }
                if (lastWasComment && newlines > 0) {
                    tokOps.put((Object)j, (Object)Break.makeForced());
                }
                tokOps.put((Object)j, (Object)Comment.make(tokBefore));
            }
            for (Input.Tok tokAfter : token.getToksAfter()) {
                tokOps.put((Object)(k + 1), (Object)Comment.make(tokAfter));
            }
        }
        ImmutableList.Builder newOps = ImmutableList.builder();
        boolean afterForcedBreak = false;
        for (int i = 0; i < opsN; ++i) {
            for (Op op : tokOps.get((Object)i)) {
                if (afterForcedBreak && op instanceof NonBreakingSpace) continue;
                newOps.add((Object)op);
                afterForcedBreak = OpsBuilder.isForcedBreak(op);
            }
            Op op = this.ops.get(i);
            if (afterForcedBreak && (op instanceof NonBreakingSpace || op instanceof Break && ((Break)op).evalPlusIndent(State.startingState()) == 0 && " ".equals(((Doc)((Object)op)).getFlat()))) continue;
            newOps.add((Object)op);
            if (op instanceof OpenOp) continue;
            afterForcedBreak = OpsBuilder.isForcedBreak(op);
        }
        for (Op op : tokOps.get((Object)opsN)) {
            if (afterForcedBreak && op instanceof NonBreakingSpace) continue;
            newOps.add((Object)op);
            afterForcedBreak = OpsBuilder.isForcedBreak(op);
        }
        return ImmutableOpsOutput.builder().ops((Iterable<? extends Op>)newOps.build()).inputMetadata(this.inputMetadataBuilder.build()).build();
    }

    private static boolean isNonNlsComment(Input.Tok tokAfter) {
        return tokAfter.isSlashSlashComment() && tokAfter.getText().contains("$NON-NLS");
    }

    private static boolean isForcedBreak(Op op) {
        return op instanceof Break && ((Break)op).isForced();
    }

    private static List<Op> makeComment(Input.Tok comment) {
        return comment.isSlashStarComment() ? ImmutableList.of((Object)Comment.make(comment)) : ImmutableList.of((Object)Comment.make(comment), (Object)Break.makeForced());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("input", (Object)this.input).add("ops", this.ops).add("tokenI", this.tokenI).add("inputPosition", this.inputPosition).toString();
    }

    @Value.Immutable
    @Value.Style(overshadowImplementation=true)
    public static interface OpsOutput {
        public ImmutableList<Op> ops();

        public InputMetadata inputMetadata();
    }

    public static abstract class BlankLineWanted {
        public static final BlankLineWanted YES = new SimpleBlankLine(Optional.of(true));
        public static final BlankLineWanted NO = new SimpleBlankLine(Optional.of(false));
        public static final BlankLineWanted PRESERVE = new SimpleBlankLine(Optional.empty());

        public abstract Optional<Boolean> wanted(State var1);

        public abstract BlankLineWanted merge(BlankLineWanted var1);

        public static BlankLineWanted conditional(BreakTag breakTag) {
            return new ConditionalBlankLine((Iterable<BreakTag>)ImmutableList.of((Object)breakTag));
        }

        private static final class ConditionalBlankLine
        extends BlankLineWanted {
            private final ImmutableList<BreakTag> tags;

            ConditionalBlankLine(Iterable<BreakTag> tags) {
                this.tags = ImmutableList.copyOf(tags);
            }

            @Override
            public Optional<Boolean> wanted(State state) {
                for (BreakTag tag : this.tags) {
                    if (!state.wasBreakTaken(tag)) continue;
                    return Optional.of(true);
                }
                return Optional.empty();
            }

            @Override
            public BlankLineWanted merge(BlankLineWanted other) {
                if (!(other instanceof ConditionalBlankLine)) {
                    return other;
                }
                return new ConditionalBlankLine(Iterables.concat(this.tags, ((ConditionalBlankLine)other).tags));
            }
        }

        private static final class SimpleBlankLine
        extends BlankLineWanted {
            private final Optional<Boolean> wanted;

            SimpleBlankLine(Optional<Boolean> wanted) {
                this.wanted = wanted;
            }

            @Override
            public Optional<Boolean> wanted(State _state) {
                return this.wanted;
            }

            @Override
            public BlankLineWanted merge(BlankLineWanted other) {
                return this;
            }
        }
    }
}

