/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.Strings;
import com.palantir.javaformat.BreakBehaviours;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.LastLevelBreakability;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.DocVisitor;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.NonBreakingSpace;
import com.palantir.javaformat.doc.State;
import com.palantir.javaformat.doc.Token;

public final class LevelDelimitedFlatValueDocVisitor
implements DocVisitor<String> {
    private final State state;
    int indent = 0;

    public LevelDelimitedFlatValueDocVisitor(State state) {
        this.state = state;
    }

    @Override
    public String visitSpace(NonBreakingSpace doc) {
        return doc.getFlat();
    }

    @Override
    public String visitComment(Comment doc) {
        return doc.getFlat();
    }

    @Override
    public String visitToken(Token doc) {
        return doc.getFlat();
    }

    @Override
    public String visitBreak(Break doc) {
        StringBuilder sb = new StringBuilder().append("\u23ce").append((String)(doc.getFlat().isEmpty() ? "" : "(" + doc.getFlat() + ")"));
        if (!doc.plusIndent().equals(Indent.Const.ZERO)) {
            sb.append(" +" + doc.evalPlusIndent(this.state));
        }
        return sb.toString();
    }

    @Override
    public String visitLevel(Level level) {
        if (level.getFlat().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\u2770");
        level.getDebugName().ifPresent(name -> builder.append(" \"" + name + "\""));
        if (!level.getPlusIndent().equals(Indent.Const.ZERO)) {
            builder.append(" +" + level.getPlusIndent().eval(this.state));
        }
        BreakBehaviours.caseOf(level.getBreakBehaviour()).breakThisLevel_(null).otherwise(() -> {
            builder.append(" ");
            builder.append(level.getBreakBehaviour());
            return null;
        });
        if (level.getBreakabilityIfLastLevel() != LastLevelBreakability.ABORT) {
            builder.append(" ifLastLevel=");
            builder.append((Object)level.getBreakabilityIfLastLevel());
        }
        this.indent += 2;
        boolean breakNext = true;
        for (Doc doc : level.getDocs()) {
            if (breakNext) {
                builder.append("\n");
                this.generateIndent(builder);
            }
            breakNext = doc instanceof Level || doc instanceof Break;
            builder.append((String)this.visit(doc));
        }
        this.indent -= 2;
        builder.append("\n");
        this.generateIndent(builder);
        builder.append("\u2771");
        return builder.toString();
    }

    private void generateIndent(StringBuilder builder) {
        builder.append(Strings.repeat((String)" ", (int)this.indent));
    }
}

