/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.palantir.javaformat.Utils;
import com.palantir.javaformat.java.CommandLineOptions;
import com.palantir.javaformat.java.Formatter;
import com.palantir.javaformat.java.FormatterException;
import com.palantir.javaformat.java.ImportOrderer;
import com.palantir.javaformat.java.JavaFormatterOptions;
import com.palantir.javaformat.java.RemoveUnusedImports;
import com.palantir.javaformat.java.StringWrapper;
import java.util.concurrent.Callable;

class FormatFileCallable
implements Callable<String> {
    private final String input;
    private final CommandLineOptions parameters;
    private final JavaFormatterOptions options;

    public FormatFileCallable(CommandLineOptions parameters, String input, JavaFormatterOptions options) {
        this.input = input;
        this.parameters = parameters;
        this.options = options;
    }

    @Override
    public String call() throws FormatterException {
        if (this.parameters.fixImportsOnly()) {
            return this.fixImports(this.input);
        }
        Formatter formatter = Formatter.createFormatter(this.options);
        String formatted = formatter.formatSource(this.input, this.characterRanges(this.input).asRanges());
        formatted = this.fixImports(formatted);
        if (this.parameters.reflowLongStrings()) {
            formatted = StringWrapper.wrap(this.options.maxLineLength(), formatted, formatter);
        }
        return formatted;
    }

    private String fixImports(String input) throws FormatterException {
        if (this.parameters.removeUnusedImports()) {
            input = RemoveUnusedImports.removeUnusedImports(input);
        }
        if (this.parameters.sortImports()) {
            input = ImportOrderer.reorderImports(input, this.options.style());
        }
        return input;
    }

    private RangeSet<Integer> characterRanges(String input) {
        TreeRangeSet characterRanges = TreeRangeSet.create();
        if (this.parameters.lines().isEmpty() && this.parameters.offsets().isEmpty()) {
            characterRanges.add(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(input.length())));
            return characterRanges;
        }
        characterRanges.addAll(Utils.lineRangesToCharRanges(input, this.parameters.lines()));
        for (int i = 0; i < this.parameters.offsets().size(); ++i) {
            Integer length = (Integer)this.parameters.lengths().get(i);
            if (length == 0) {
                length = 1;
            }
            characterRanges.add(Range.closedOpen((Comparable)((Integer)this.parameters.offsets().get(i)), (Comparable)Integer.valueOf((Integer)this.parameters.offsets().get(i) + length)));
        }
        return characterRanges;
    }
}

