/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java.java14;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.OpsBuilder;
import com.palantir.javaformat.java.JavaInputAstVisitor;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.YieldTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Name;

public class Java14InputAstVisitor
extends JavaInputAstVisitor {
    private static final Method COMPILATION_UNIT_TREE_GET_MODULE = Java14InputAstVisitor.maybeGetMethod(CompilationUnitTree.class, "getModule");
    private static final Method CLASS_TREE_GET_PERMITS_CLAUSE = Java14InputAstVisitor.maybeGetMethod(ClassTree.class, "getPermitsClause");
    private static final Method BINDING_PATTERN_TREE_GET_VARIABLE = Java14InputAstVisitor.maybeGetMethod(BindingPatternTree.class, "getVariable");
    private static final Method BINDING_PATTERN_TREE_GET_TYPE = Java14InputAstVisitor.maybeGetMethod(BindingPatternTree.class, "getType");
    private static final Method BINDING_PATTERN_TREE_GET_BINDING = Java14InputAstVisitor.maybeGetMethod(BindingPatternTree.class, "getBinding");
    private static final Method CASE_TREE_GET_LABELS = Java14InputAstVisitor.maybeGetMethod(CaseTree.class, "getLabels");

    public Java14InputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        super(builder, indentMultiplier);
    }

    @Override
    protected void handleModule(boolean first, CompilationUnitTree node) {
        if (COMPILATION_UNIT_TREE_GET_MODULE == null) {
            return;
        }
        ModuleTree module = (ModuleTree)Java14InputAstVisitor.invoke(COMPILATION_UNIT_TREE_GET_MODULE, node);
        if (module != null) {
            if (!first) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.markForPartialFormat();
            this.visitModule(module, null);
            this.builder.forcedBreak();
        }
    }

    @Override
    protected List<? extends Tree> getPermitsClause(ClassTree node) {
        if (CLASS_TREE_GET_PERMITS_CLAUSE != null) {
            return (List)Java14InputAstVisitor.invoke(CLASS_TREE_GET_PERMITS_CLAUSE, node);
        }
        return super.getPermitsClause(node);
    }

    @Override
    public Void visitBindingPattern(BindingPatternTree node, Void unused) {
        this.sync(node);
        if (BINDING_PATTERN_TREE_GET_VARIABLE != null) {
            VariableTree variableTree = (VariableTree)Java14InputAstVisitor.invoke(BINDING_PATTERN_TREE_GET_VARIABLE, node);
            this.visitBindingPattern(variableTree.getModifiers(), variableTree.getType(), variableTree.getName());
        } else if (BINDING_PATTERN_TREE_GET_TYPE != null && BINDING_PATTERN_TREE_GET_BINDING != null) {
            Tree type = (Tree)Java14InputAstVisitor.invoke(BINDING_PATTERN_TREE_GET_TYPE, node);
            Name name = (Name)Java14InputAstVisitor.invoke(BINDING_PATTERN_TREE_GET_BINDING, node);
            this.visitBindingPattern(null, type, name);
        } else {
            throw new LinkageError("BindingPatternTree must have either getVariable() or both getType() and getBinding(), but does not");
        }
        return null;
    }

    private void visitBindingPattern(ModifiersTree modifiers, Tree type, Name name) {
        if (modifiers != null) {
            this.builder.addAll(this.visitModifiers(modifiers, JavaInputAstVisitor.Direction.HORIZONTAL, Optional.empty()));
        }
        this.scan(type, null);
        this.builder.breakOp(" ");
        this.visit(name);
    }

    @Override
    public Void visitYield(YieldTree node, Void aVoid) {
        this.sync(node);
        this.token("yield");
        this.builder.space();
        this.scan((Tree)node.getValue(), null);
        this.token(";");
        return null;
    }

    @Override
    public Void visitSwitchExpression(SwitchExpressionTree node, Void unused) {
        this.sync(node);
        this.visitSwitch(node.getExpression(), node.getCases());
        return null;
    }

    @Override
    public Void visitClass(ClassTree tree, Void unused) {
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: {
                this.visitAnnotationType(tree);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                this.visitClassDeclaration(tree);
                break;
            }
            case ENUM: {
                this.visitEnumDeclaration(tree);
                break;
            }
            case RECORD: {
                this.visitRecordDeclaration(tree);
                break;
            }
            default: {
                throw new AssertionError((Object)tree.getKind());
            }
        }
        return null;
    }

    public void visitRecordDeclaration(ClassTree node) {
        this.sync(node);
        List<Op> breaks = this.visitModifiers(node.getModifiers(), JavaInputAstVisitor.Direction.VERTICAL, Optional.empty());
        Verify.verify((node.getExtendsClause() == null ? 1 : 0) != 0);
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        this.builder.addAll(breaks);
        this.token("record");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperInterfaceTypes ? this.plusFour : ZERO);
        }
        ImmutableList<JCTree.JCVariableDecl> parameters = Java14InputAstVisitor.recordVariables(node);
        this.token("(");
        if (!parameters.isEmpty()) {
            this.builder.breakToFill("");
        }
        this.visitFormals(Optional.empty(), (List<? extends VariableTree>)parameters);
        this.token(")");
        if (hasSuperInterfaceTypes) {
            this.builder.breakToFill(" ");
            this.builder.open(node.getImplementsClause().size() > 1 ? this.plusFour : ZERO);
            this.token("implements");
            this.builder.space();
            boolean first = true;
            for (Tree tree : node.getImplementsClause()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                first = false;
            }
            this.builder.close();
        }
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            List members = (List)node.getMembers().stream().filter(t -> (TreeInfo.flags((JCTree)t) & 0x1000000L) == 0L).collect(ImmutableList.toImmutableList());
            this.addBodyDeclarations(members, JavaInputAstVisitor.BracesOrNot.YES, JavaInputAstVisitor.FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    private static ImmutableList<JCTree.JCVariableDecl> recordVariables(ClassTree node) {
        return (ImmutableList)node.getMembers().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).filter(m -> (m.mods.flags & 0x2000000000000000L) == 0x2000000000000000L).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getExpression(), null);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        if (node.getPattern() != null) {
            this.scan((Tree)node.getPattern(), null);
        } else {
            this.scan(node.getType(), null);
        }
        this.builder.close();
        this.builder.close();
        return null;
    }

    @Override
    public Void visitCase(CaseTree node, Void unused) {
        boolean isDefault;
        List labels;
        this.sync(node);
        this.markForPartialFormat();
        this.builder.forcedBreak();
        if (CASE_TREE_GET_LABELS != null) {
            labels = (List)Java14InputAstVisitor.invoke(CASE_TREE_GET_LABELS, node);
            isDefault = labels.size() == 1 && ((Tree)Iterables.getOnlyElement((Iterable)labels)).getKind().name().equals("DEFAULT_CASE_LABEL");
        } else {
            labels = node.getExpressions();
            isDefault = labels.isEmpty();
        }
        if (isDefault) {
            this.token("default", this.plusTwo);
        } else {
            this.token("case", this.plusTwo);
            this.builder.space();
            this.builder.open(labels.size() > 1 ? this.plusFour : ZERO);
            boolean first = true;
            for (Tree expression : labels) {
                if (!first) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(expression, null);
                first = false;
            }
            this.builder.close();
        }
        switch (node.getCaseKind()) {
            case STATEMENT: {
                this.token(":");
                boolean isBlock = node.getStatements().size() == 1 && node.getStatements().get(0).getKind() == Tree.Kind.BLOCK;
                this.builder.open(isBlock ? ZERO : this.plusTwo);
                if (isBlock) {
                    this.builder.space();
                }
                this.visitStatements(node.getStatements(), isBlock);
                this.builder.close();
                break;
            }
            case RULE: {
                this.builder.space();
                this.token("-");
                this.token(">");
                this.builder.space();
                if (node.getBody().getKind() == Tree.Kind.BLOCK) {
                    this.visitBlock((BlockTree)node.getBody(), JavaInputAstVisitor.CollapseEmptyOrNot.YES, JavaInputAstVisitor.AllowLeadingBlankLine.NO, JavaInputAstVisitor.AllowTrailingBlankLine.NO);
                } else {
                    this.scan(node.getBody(), null);
                }
                this.builder.guessToken(";");
                break;
            }
            default: {
                throw new AssertionError((Object)node.getCaseKind());
            }
        }
        return null;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
        this.sync(node);
        boolean statementBody = node.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT || node.getBody().getKind() == Tree.Kind.SWITCH_EXPRESSION;
        this.visitLambdaExpression(node, statementBody);
        return null;
    }

    private static Method maybeGetMethod(Class<?> c, String name) {
        try {
            return c.getMethod(name, new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static Object invoke(Method m, Object target) {
        try {
            return m.invoke(target, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }
}

