/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.palantir.javaformat.Newlines;
import com.palantir.javaformat.java.Formatter;
import com.palantir.javaformat.java.FormatterException;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringWrapper {
    public static final CharMatcher STRING_CONCAT_DELIMITER = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"\"+"));

    static String wrap(int columnLimit, String input, Formatter formatter) throws FormatterException {
        String actual;
        String expected;
        String result;
        String secondPass;
        if (!StringWrapper.longLines(columnLimit, input)) {
            return input;
        }
        TreeRangeMap<Integer, String> replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        String firstPass = formatter.formatSource(input, replacements.asMapOfRanges().keySet());
        if (!firstPass.equals(input)) {
            input = firstPass;
            replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        }
        if (!(secondPass = formatter.formatSource(result = StringWrapper.applyReplacements(input, replacements), (Collection<Range<Integer>>)StringWrapper.rangesAfterAppliedReplacements(replacements))).equals(result)) {
            replacements = StringWrapper.getReflowReplacements(columnLimit, secondPass);
            result = StringWrapper.applyReplacements(secondPass, replacements);
        }
        if (!(expected = StringWrapper.parse(input, true).toString()).equals(actual = StringWrapper.parse(result, true).toString())) {
            throw new FormatterException(String.format("Something has gone terribly wrong. Please file a bug: https://github.com/palantir/palantir-java-format/issues/new\n\n=== Actual: ===\n%s\n=== Expected: ===\n%s\n", actual, expected));
        }
        return result;
    }

    private static ImmutableSet<Range<Integer>> rangesAfterAppliedReplacements(TreeRangeMap<Integer, String> replacements) {
        ImmutableSet.Builder outputRanges = ImmutableSet.builder();
        int offset = 0;
        for (Map.Entry entry : replacements.asMapOfRanges().entrySet()) {
            Range range = (Range)entry.getKey();
            String replacement = (String)entry.getValue();
            int lower = offset + (Integer)range.lowerEndpoint();
            int upper = lower + replacement.length();
            outputRanges.add((Object)Range.closedOpen((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper)));
            int originalLength = (Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint();
            int newLength = upper - lower;
            offset += newLength - originalLength;
        }
        return outputRanges.build();
    }

    private static TreeRangeMap<Integer, String> getReflowReplacements(final int columnLimit, final String input) throws FormatterException {
        final JCTree.JCCompilationUnit unit = StringWrapper.parse(input, false);
        String separator = Newlines.guessLineSeparator(input);
        final ArrayList toFix = new ArrayList();
        final Position.LineMap lineMap = unit.getLineMap();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitLiteral(LiteralTree literalTree, Void aVoid) {
                int endPosition;
                if (literalTree.getKind() != Tree.Kind.STRING_LITERAL) {
                    return null;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (parent instanceof MemberSelectTree && ((MemberSelectTree)parent).getExpression().equals(literalTree)) {
                    return null;
                }
                int lineEnd = endPosition = StringWrapper.getEndPosition(unit, literalTree);
                while (Newlines.hasNewlineAt(input, lineEnd) == -1) {
                    ++lineEnd;
                }
                if (lineMap.getColumnNumber(lineEnd) - 1 <= columnLimit) {
                    return null;
                }
                toFix.add(this.getCurrentPath());
                return null;
            }
        }.scan(new TreePath(unit), (Void)null);
        TreeRangeMap replacements = TreeRangeMap.create();
        Iterator iterator = toFix.iterator();
        while (iterator.hasNext()) {
            int end;
            TreePath path;
            TreePath enclosing = path = (TreePath)iterator.next();
            while (enclosing.getParentPath().getLeaf().getKind() == Tree.Kind.PLUS) {
                enclosing = enclosing.getParentPath();
            }
            AtomicBoolean first = new AtomicBoolean(false);
            List<Tree> flat = StringWrapper.flatten(input, unit, path, enclosing, first);
            TreePath startingPath = enclosing;
            while (startingPath.getParentPath() != null && StringWrapper.onSameLineAsParent(lineMap, startingPath)) {
                startingPath = startingPath.getParentPath();
            }
            int startColumn = lineMap.getColumnNumber(StringWrapper.getStartPosition(flat.get(0))) - 1;
            int fistLineCol = lineMap.getColumnNumber(StringWrapper.getStartPosition(startingPath.getLeaf())) - 1;
            int lineEnd = end = StringWrapper.getEndPosition(unit, (Tree)Iterables.getLast(flat));
            while (Newlines.hasNewlineAt(input, lineEnd) == -1) {
                ++lineEnd;
            }
            int trailing = lineEnd - end;
            ImmutableList<String> components = StringWrapper.stringComponents(input, unit, flat);
            replacements.put(Range.closedOpen((Comparable)Integer.valueOf(StringWrapper.getStartPosition(flat.get(0))), (Comparable)Integer.valueOf(StringWrapper.getEndPosition(unit, (Tree)Iterables.getLast(flat)))), (Object)StringWrapper.reflow(separator, columnLimit, trailing, components, first.get(), startColumn, fistLineCol));
        }
        return replacements;
    }

    private static boolean onSameLineAsParent(Position.LineMap lineMap, TreePath path) {
        return lineMap.getLineNumber(StringWrapper.getStartPosition(path.getLeaf())) == lineMap.getLineNumber(StringWrapper.getStartPosition(path.getParentPath().getLeaf()));
    }

    private static ImmutableList<String> stringComponents(String input, JCTree.JCCompilationUnit unit, List<Tree> flat) {
        ImmutableList.Builder result = ImmutableList.builder();
        StringBuilder piece = new StringBuilder();
        for (Tree tree : flat) {
            String text = input.substring(StringWrapper.getStartPosition(tree) + 1, StringWrapper.getEndPosition(unit, tree) - 1);
            int start = 0;
            for (int idx = 0; idx < text.length(); ++idx) {
                if (!CharMatcher.whitespace().matches(text.charAt(idx)) && StringWrapper.hasEscapedWhitespaceAt(text, idx) == -1) {
                    int length;
                    if (StringWrapper.hasEscapedNewlineAt(text, idx) == -1) continue;
                    while ((length = StringWrapper.hasEscapedNewlineAt(text, idx)) != -1) {
                        idx += length;
                    }
                }
                piece.append(text, start, idx);
                result.add((Object)piece.toString());
                piece = new StringBuilder();
                start = idx;
            }
            if (piece.length() > 0) {
                result.add((Object)piece.toString());
                piece = new StringBuilder();
            }
            if (start >= text.length()) continue;
            piece.append(text, start, text.length());
        }
        if (piece.length() > 0) {
            result.add((Object)piece.toString());
        }
        return result.build();
    }

    static int hasEscapedWhitespaceAt(String input, int idx) {
        return Stream.of("\\t").mapToInt(x -> input.startsWith((String)x, idx) ? x.length() : -1).filter(x -> x != -1).findFirst().orElse(-1);
    }

    static int hasEscapedNewlineAt(String input, int idx) {
        return Stream.of("\\r\\n", "\\r", "\\n").mapToInt(x -> input.startsWith((String)x, idx) ? x.length() : -1).filter(x -> x != -1).findFirst().orElse(-1);
    }

    private static String reflow(String separator, int columnLimit, int trailing, ImmutableList<String> components, boolean first0, int textStartColumn, int firstLineStartColumn) {
        int width = columnLimit - textStartColumn - 2;
        ArrayDeque<String> input = new ArrayDeque<String>((Collection<String>)components);
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = first0;
        while (!input.isEmpty()) {
            int length = 0;
            ArrayList<String> line = new ArrayList<String>();
            if (input.stream().mapToInt(String::length).sum() <= width) {
                width -= trailing;
            }
            while (!(input.isEmpty() || length > 4 && length + ((String)input.peekFirst()).length() >= width)) {
                String text = (String)input.removeFirst();
                line.add(text);
                length += text.length();
                if (!text.endsWith("\\n") && !text.endsWith("\\r")) continue;
                break;
            }
            if (line.isEmpty()) {
                line.add((String)input.removeFirst());
            }
            lines.add(String.join((CharSequence)"", line));
            if (!first) continue;
            width -= 6;
            width += textStartColumn - firstLineStartColumn;
            first = false;
        }
        return lines.stream().collect(Collectors.joining("\"" + separator + " ".repeat(first0 ? firstLineStartColumn + 4 : textStartColumn - 2) + "+ \"", "\"", "\""));
    }

    private static List<Tree> flatten(String input, JCTree.JCCompilationUnit unit, TreePath path, TreePath parent, AtomicBoolean firstInChain) {
        int startIdx;
        ArrayList<Tree> flat = new ArrayList<Tree>();
        ArrayDeque<Tree> todo = new ArrayDeque<Tree>();
        todo.add(parent.getLeaf());
        while (!todo.isEmpty()) {
            Tree first = (Tree)todo.removeFirst();
            if (first.getKind() == Tree.Kind.PLUS) {
                BinaryTree bt = (BinaryTree)first;
                todo.addFirst(bt.getRightOperand());
                todo.addFirst(bt.getLeftOperand());
                continue;
            }
            flat.add(first);
        }
        int idx = flat.indexOf(path.getLeaf());
        Verify.verify((idx != -1 ? 1 : 0) != 0);
        int endIdx = idx + 1;
        for (startIdx = idx; startIdx > 0 && ((Tree)flat.get(startIdx - 1)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, (Tree)flat.get(startIdx - 1), (Tree)flat.get(startIdx)); --startIdx) {
        }
        while (endIdx < flat.size() && ((Tree)flat.get(endIdx)).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, (Tree)flat.get(endIdx - 1), (Tree)flat.get(endIdx))) {
            ++endIdx;
        }
        firstInChain.set(startIdx == 0);
        return ImmutableList.copyOf(flat.subList(startIdx, endIdx));
    }

    private static boolean noComments(String input, JCTree.JCCompilationUnit unit, Tree one, Tree two) {
        return STRING_CONCAT_DELIMITER.matchesAllOf(input.subSequence(StringWrapper.getEndPosition(unit, one), StringWrapper.getStartPosition(two)));
    }

    private static int getEndPosition(JCTree.JCCompilationUnit unit, Tree tree) {
        return ((JCTree)tree).getEndPosition(unit.endPositions);
    }

    private static int getStartPosition(Tree tree) {
        return ((JCTree)tree).getStartPosition();
    }

    private static boolean longLines(int columnLimit, String input) {
        Iterator<String> it = Newlines.lineIterator(input);
        while (it.hasNext()) {
            String line = it.next();
            if (line.length() <= columnLimit) continue;
            return true;
        }
        return false;
    }

    private static JCTree.JCCompilationUnit parse(String source, boolean allowStringFolding) throws FormatterException {
        Context context = new Context();
        Options.instance(context).put("allowStringFolding", Boolean.toString(allowStringFolding));
        return Formatter.parseJcCompilationUnit(context, source);
    }

    private static String applyReplacements(String javaInput, TreeRangeMap<Integer, String> replacementMap) {
        Map ranges = replacementMap.asDescendingMapOfRanges();
        if (ranges.isEmpty()) {
            return javaInput;
        }
        StringBuilder sb = new StringBuilder(javaInput);
        for (Map.Entry entry : ranges.entrySet()) {
            Range range = (Range)entry.getKey();
            sb.replace((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), (String)entry.getValue());
        }
        return sb.toString();
    }

    private StringWrapper() {
    }
}

