/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.palantir.javaformat.CloseOp;
import com.palantir.javaformat.Input;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.OpenOp;
import com.palantir.javaformat.OpsBuilder;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.HasUniqueId;
import com.palantir.javaformat.doc.JsonDocVisitor;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.NonBreakingSpace;
import com.palantir.javaformat.doc.State;
import com.palantir.javaformat.doc.Token;
import com.palantir.javaformat.java.JavaInput;
import com.palantir.javaformat.java.JavaOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public class DebugRenderer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static Path publicDir = Paths.get("../debugger/public", new String[0]);

    static Path getOutputFile() {
        return publicDir.resolve("output.js");
    }

    static void render(JavaInput javaInput, OpsBuilder.OpsOutput opsOutput, Level doc, State finalState, JavaOutput javaOutput, String formatterDecisionsJson) {
        String javascript = String.format("window.palantirJavaFormat = {\njavaInput: %s,\nops: %s,\ndoc: %s,\njavaOutput: %s,\nformatterDecisions: %s\n};\n", DebugRenderer.jsonEscapedString(javaInput.getText()), DebugRenderer.opsJson(opsOutput), new JsonDocVisitor(finalState).visit(doc), DebugRenderer.jsonEscapedString(DebugRenderer.outputAsString(javaOutput)), formatterDecisionsJson);
        try {
            Files.write(DebugRenderer.getOutputFile(), javascript.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String outputAsString(JavaOutput javaOutput) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < javaOutput.getLineCount(); ++i) {
            output.append(javaOutput.getLine(i));
            output.append("\n");
        }
        return output.toString();
    }

    private static String opsJson(OpsBuilder.OpsOutput opsOutput) {
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        ImmutableList<Op> ops = opsOutput.ops();
        for (Op op : ops) {
            ObjectNode json;
            if (op instanceof Token) {
                Token token = (Token)op;
                Input.Token inputToken = token.getToken();
                ObjectNode json2 = arrayNode.addObject();
                json2.put("type", "token");
                json2.put("beforeText", inputToken.getToksBefore().stream().map(Input.Tok::getText).collect(Collectors.joining()));
                json2.put("text", inputToken.getTok().getText());
                json2.put("afterText", inputToken.getToksAfter().stream().map(Input.Tok::getText).collect(Collectors.joining()));
                json2.put("hue", DebugRenderer.computeHue(token));
            }
            if (op instanceof Break) {
                Break breakOp = (Break)op;
                ObjectNode json3 = arrayNode.addObject();
                json3.put("type", "break");
                json3.put("fillMode", breakOp.fillMode().toString());
                json3.put("toString", op.toString());
                breakOp.optTag().ifPresent(tag -> json3.put("breakTag", tag.id()));
            }
            if (op instanceof NonBreakingSpace) {
                json = arrayNode.addObject();
                json.put("type", "nonBreakingSpace");
                json.put("toString", op.toString());
            }
            if (op instanceof Comment) {
                json = arrayNode.addObject();
                json.put("type", "comment");
                json.put("toString", op.toString());
            }
            if (op instanceof OpenOp) {
                json = arrayNode.addObject();
                json.put("type", "openOp");
                json.put("toString", op.toString());
            }
            if (!(op instanceof CloseOp)) continue;
            json = arrayNode.addObject();
            json.put("type", "closeOp");
            json.put("toString", op.toString());
        }
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private static String jsonEscapedString(String javaInput) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)javaInput);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private static long computeHue(HasUniqueId op) {
        return Hashing.adler32().hashInt(op.id()).padToLong() % 360L;
    }
}

