/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.palantir.javaformat.Newlines;
import com.palantir.javaformat.Utils;
import com.palantir.javaformat.java.Formatter;
import com.palantir.javaformat.java.FormatterException;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Position;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class StringWrapper {
    public static final String TEXT_BLOCK_DELIMITER = "\"\"\"";
    public static final CharMatcher STRING_CONCAT_DELIMITER = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"\"+"));

    static String wrap(int columnLimit, String input, Formatter formatter) throws FormatterException {
        String actual;
        String expected;
        String result;
        String secondPass;
        if (!StringWrapper.needWrapping(columnLimit, input)) {
            return input;
        }
        TreeRangeMap<Integer, String> replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        String firstPass = formatter.formatSource(input, replacements.asMapOfRanges().keySet());
        if (!firstPass.equals(input)) {
            input = firstPass;
            replacements = StringWrapper.getReflowReplacements(columnLimit, input);
        }
        if (!(secondPass = formatter.formatSource(result = StringWrapper.applyReplacements(input, replacements), (Collection<Range<Integer>>)StringWrapper.rangesAfterAppliedReplacements(replacements))).equals(result)) {
            replacements = StringWrapper.getReflowReplacements(columnLimit, secondPass);
            result = StringWrapper.applyReplacements(secondPass, replacements);
        }
        if (!(expected = StringWrapper.parse(input, true).toString()).equals(actual = StringWrapper.parse(result, true).toString())) {
            throw new FormatterException(String.format("Something has gone terribly wrong. Please file a bug: https://github.com/palantir/palantir-java-format/issues/new\n\n=== Actual: ===\n%s\n=== Expected: ===\n%s\n", actual, expected));
        }
        return result;
    }

    private static ImmutableSet<Range<Integer>> rangesAfterAppliedReplacements(TreeRangeMap<Integer, String> replacements) {
        ImmutableSet.Builder outputRanges = ImmutableSet.builder();
        int offset = 0;
        for (Map.Entry entry : replacements.asMapOfRanges().entrySet()) {
            Range range = (Range)entry.getKey();
            String replacement = (String)entry.getValue();
            int lower = offset + (Integer)range.lowerEndpoint();
            int upper = lower + replacement.length();
            outputRanges.add((Object)Range.closedOpen((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper)));
            int originalLength = (Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint();
            int newLength = upper - lower;
            offset += newLength - originalLength;
        }
        return outputRanges.build();
    }

    public static TreeRangeMap<Integer, String> getReflowReplacements(int columnLimit, String input) throws FormatterException {
        return new Reflower(columnLimit, input).getReflowReplacements();
    }

    private static ImmutableList<String> stringComponents(String input, JCTree.JCCompilationUnit unit, List<Tree> flat) {
        ImmutableList.Builder result = ImmutableList.builder();
        StringBuilder piece = new StringBuilder();
        for (Tree tree : flat) {
            String text = input.substring(StringWrapper.getStartPosition(tree) + 1, StringWrapper.getEndPosition(unit, tree) - 1);
            int start = 0;
            for (int idx = 0; idx < text.length(); ++idx) {
                if (!CharMatcher.whitespace().matches(text.charAt(idx)) && StringWrapper.hasEscapedWhitespaceAt(text, idx) == -1) {
                    int length;
                    if (StringWrapper.hasEscapedNewlineAt(text, idx) == -1) continue;
                    while ((length = StringWrapper.hasEscapedNewlineAt(text, idx)) != -1) {
                        idx += length;
                    }
                }
                piece.append(text, start, idx);
                result.add((Object)piece.toString());
                piece = new StringBuilder();
                start = idx;
            }
            if (piece.length() > 0) {
                result.add((Object)piece.toString());
                piece = new StringBuilder();
            }
            if (start >= text.length()) continue;
            piece.append(text, start, text.length());
        }
        if (piece.length() > 0) {
            result.add((Object)piece.toString());
        }
        return result.build();
    }

    static int hasEscapedWhitespaceAt(String input, int idx) {
        if (input.startsWith("\\t", idx)) {
            return 2;
        }
        return -1;
    }

    static int hasEscapedNewlineAt(String input, int idx) {
        int offset = 0;
        if (input.startsWith("\\r", idx)) {
            offset += 2;
        }
        if (input.startsWith("\\n", idx)) {
            offset += 2;
        }
        return offset > 0 ? offset : -1;
    }

    private static String reflow(String separator, int columnLimit, int trailing, ImmutableList<String> components, boolean first0, int textStartColumn, int firstLineStartColumn) {
        int width = columnLimit - textStartColumn - 2;
        ArrayDeque<String> input = new ArrayDeque<String>((Collection<String>)components);
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = first0;
        while (!input.isEmpty()) {
            int length = 0;
            ArrayList<String> line = new ArrayList<String>();
            if (input.stream().mapToInt(String::length).sum() <= width) {
                width -= trailing;
            }
            while (!(input.isEmpty() || length > 4 && length + ((String)input.peekFirst()).length() >= width)) {
                String text = (String)input.removeFirst();
                line.add(text);
                length += text.length();
                if (!text.endsWith("\\n") && !text.endsWith("\\r")) continue;
                break;
            }
            if (line.isEmpty()) {
                line.add((String)input.removeFirst());
            }
            lines.add(String.join((CharSequence)"", line));
            if (!first) continue;
            width -= 6;
            width += textStartColumn - firstLineStartColumn;
            first = false;
        }
        return lines.stream().collect(Collectors.joining("\"" + separator + " ".repeat(first0 ? firstLineStartColumn + 4 : textStartColumn - 2) + "+ \"", "\"", "\""));
    }

    private static List<Tree> flatten(String input, JCTree.JCCompilationUnit unit, TreePath path, TreePath parent, AtomicBoolean firstInChain) {
        int startIdx;
        List<Tree> flat = StringWrapper.flattenExpressionTree(parent.getLeaf());
        int idx = flat.indexOf(path.getLeaf());
        Verify.verify((idx != -1 ? 1 : 0) != 0);
        int endIdx = idx + 1;
        for (startIdx = idx; startIdx > 0 && flat.get(startIdx - 1).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, flat.get(startIdx - 1), flat.get(startIdx)); --startIdx) {
        }
        while (endIdx < flat.size() && flat.get(endIdx).getKind() == Tree.Kind.STRING_LITERAL && StringWrapper.noComments(input, unit, flat.get(endIdx - 1), flat.get(endIdx))) {
            ++endIdx;
        }
        firstInChain.set(startIdx == 0);
        return ImmutableList.copyOf(flat.subList(startIdx, endIdx));
    }

    private static List<Tree> flattenExpressionTree(Tree parent) {
        ArrayList<Tree> flat = new ArrayList<Tree>();
        ArrayDeque<Tree> todo = new ArrayDeque<Tree>();
        todo.add(parent);
        while (!todo.isEmpty()) {
            Tree first = (Tree)todo.removeFirst();
            if (first.getKind() == Tree.Kind.PLUS) {
                BinaryTree bt = (BinaryTree)first;
                todo.addFirst(bt.getRightOperand());
                todo.addFirst(bt.getLeftOperand());
                continue;
            }
            flat.add(first);
        }
        return flat;
    }

    private static boolean noComments(String input, JCTree.JCCompilationUnit unit, Tree one, Tree two) {
        return STRING_CONCAT_DELIMITER.matchesAllOf(input.subSequence(StringWrapper.getEndPosition(unit, one), StringWrapper.getStartPosition(two)));
    }

    private static int getEndPosition(JCTree.JCCompilationUnit unit, Tree tree) {
        return ((JCTree)tree).getEndPosition(unit.endPositions);
    }

    private static int getStartPosition(Tree tree) {
        return ((JCTree)tree).getStartPosition();
    }

    private static boolean needWrapping(int columnLimit, String input) {
        Iterator<String> it = Newlines.lineIterator(input);
        while (it.hasNext()) {
            String line = it.next();
            if (line.length() <= columnLimit && !line.contains(TEXT_BLOCK_DELIMITER)) continue;
            return true;
        }
        return false;
    }

    public static boolean linesNeedWrapping(int columnLimit, String input, RangeSet<Integer> initialRangesToChange) {
        TreeRangeSet linesToChange = TreeRangeSet.create();
        Iterator<String> it = Newlines.lineIterator(input);
        int i = 0;
        boolean insideTextBlock = false;
        while (it.hasNext()) {
            String line = it.next();
            if (line.length() > columnLimit) {
                linesToChange.add(Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 1)));
            }
            if (!insideTextBlock && line.contains(TEXT_BLOCK_DELIMITER)) {
                insideTextBlock = true;
                linesToChange.add(Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 1)));
            } else if (insideTextBlock && line.contains(TEXT_BLOCK_DELIMITER)) {
                insideTextBlock = false;
                linesToChange.add(Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 1)));
            } else if (insideTextBlock) {
                linesToChange.add(Range.closedOpen((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 1)));
            }
            ++i;
        }
        RangeSet<Integer> charRangeToCheck = Utils.lineRangesToCharRanges(input, (RangeSet<Integer>)linesToChange);
        return StringWrapper.hasOverlap(initialRangesToChange, charRangeToCheck);
    }

    static boolean hasOverlap(RangeSet<Integer> a, RangeSet<Integer> b) {
        for (Range range : a.asRanges()) {
            if (b.subRangeSet(range).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static JCTree.JCCompilationUnit parse(String source, boolean allowStringFolding) throws FormatterException {
        Context context = new Context();
        Options.instance(context).put("allowStringFolding", Boolean.toString(allowStringFolding));
        return Formatter.parseJcCompilationUnit(context, source);
    }

    private static String applyReplacements(String javaInput, TreeRangeMap<Integer, String> replacementMap) {
        Map ranges = replacementMap.asDescendingMapOfRanges();
        if (ranges.isEmpty()) {
            return javaInput;
        }
        StringBuilder sb = new StringBuilder(javaInput);
        for (Map.Entry entry : ranges.entrySet()) {
            Range range = (Range)entry.getKey();
            sb.replace((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint(), (String)entry.getValue());
        }
        return sb.toString();
    }

    private StringWrapper() {
    }

    private static class Reflower {
        private final String input;
        private final int columnLimit;
        private final String separator;
        private final JCTree.JCCompilationUnit unit;
        private final Position.LineMap lineMap;

        Reflower(int columnLimit, String input) throws FormatterException {
            this.columnLimit = columnLimit;
            this.input = input;
            this.separator = Newlines.guessLineSeparator(input);
            this.unit = StringWrapper.parse(input, false);
            this.lineMap = this.unit.getLineMap();
        }

        protected TreeRangeMap<Integer, String> getReflowReplacements() {
            ArrayList<TreePath> longStringLiterals = new ArrayList<TreePath>();
            ArrayList<TreePath> textBlocks = new ArrayList<TreePath>();
            new LongStringsAndTextBlockScanner(longStringLiterals, textBlocks).scan(new TreePath(this.unit), null);
            TreeRangeMap replacements = TreeRangeMap.create();
            this.indentTextBlocks((TreeRangeMap<Integer, String>)replacements, textBlocks);
            this.wrapLongStrings((TreeRangeMap<Integer, String>)replacements, longStringLiterals);
            return replacements;
        }

        private void indentTextBlocks(TreeRangeMap<Integer, String> replacements, List<TreePath> textBlocks) {
            Map<TreePath, String> textBlockToIndent = this.computeCustomTextBlocksIndent(textBlocks);
            for (TreePath treePath : textBlocks) {
                Tree tree = treePath.getLeaf();
                int startPosition = StringWrapper.getStartPosition(tree);
                int endPosition = StringWrapper.getEndPosition(this.unit, tree);
                String text = this.input.substring(startPosition, endPosition);
                int lineStartPosition = this.lineMap.getStartPosition(this.lineMap.getLineNumber(startPosition));
                int startColumn = CharMatcher.whitespace().negate().indexIn((CharSequence)this.input.substring(lineStartPosition, endPosition));
                ImmutableList initialLines = (ImmutableList)text.lines().collect(ImmutableList.toImmutableList());
                String stripped = initialLines.stream().skip(1L).collect(Collectors.joining(this.separator)).stripIndent();
                ImmutableList lines = (ImmutableList)stripped.lines().collect(ImmutableList.toImmutableList());
                String prefix = textBlockToIndent.getOrDefault(treePath, (lineStartPosition + startColumn + 4 > startPosition ? "" : " ".repeat(4)) + " ".repeat(startColumn));
                StringBuilder output = new StringBuilder((String)initialLines.get(0));
                for (int i = 0; i < lines.size(); ++i) {
                    String line = (String)lines.get(i);
                    output.append(this.separator);
                    if (!line.isEmpty()) {
                        output.append(prefix);
                    }
                    if (i == lines.size() - 1) {
                        String withoutDelimiter = line.substring(0, line.length() - StringWrapper.TEXT_BLOCK_DELIMITER.length()).stripTrailing();
                        if (!withoutDelimiter.isEmpty()) {
                            output.append(withoutDelimiter).append('\\').append(this.separator).append(prefix);
                        }
                        output.append(StringWrapper.TEXT_BLOCK_DELIMITER);
                        continue;
                    }
                    output.append(line);
                }
                replacements.put(Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)), (Object)output.toString());
            }
        }

        private Map<TreePath, String> computeCustomTextBlocksIndent(List<TreePath> textBlocks) {
            HashMap<Tree, String> parentToIndent = new HashMap<Tree, String>();
            HashMap<TreePath, Tree> textBlockToParent = new HashMap<TreePath, Tree>();
            for (TreePath textBlock : textBlocks) {
                TreePath parentPath = textBlock.getParentPath();
                Tree parent = parentPath.getLeaf();
                if (parent instanceof MethodInvocationTree) {
                    textBlockToParent.put(textBlock, parent);
                    ArrayList allArguments = new ArrayList(((JCTree.JCMethodInvocation)parent).getArguments());
                    parentToIndent.computeIfAbsent(parent, parentTree -> this.computePrefixIndentation(((JCTree.JCMethodInvocation)parentTree).getMethodSelect(), allArguments, false));
                    continue;
                }
                if (parent.getKind() != Tree.Kind.PLUS) continue;
                while (parentPath.getParentPath().getLeaf().getKind() == Tree.Kind.PLUS) {
                    parentPath = parentPath.getParentPath();
                }
                Tree concatenationRoot = parentPath.getLeaf();
                textBlockToParent.put(textBlock, concatenationRoot);
                parentToIndent.computeIfAbsent(concatenationRoot, concatenationRootTree -> this.computePrefixIndentation((Tree)concatenationRootTree, StringWrapper.flattenExpressionTree(concatenationRootTree), true));
            }
            return textBlockToParent.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)parentToIndent.get(e.getValue())));
        }

        private String computePrefixIndentation(Tree parentPath, List<Tree> childExpressions, boolean shouldUseStartLineParent) {
            int startParentPosition = StringWrapper.getStartPosition(parentPath);
            int startParentLine = this.lineMap.getLineNumber(startParentPosition);
            int endParentPosition = StringWrapper.getEndPosition(this.unit, parentPath);
            int endParentLine = this.lineMap.getLineNumber(endParentPosition);
            int lineParentStartPosition = this.lineMap.getStartPosition(shouldUseStartLineParent ? startParentLine : endParentLine);
            int startParentColumn = CharMatcher.whitespace().negate().indexIn((CharSequence)this.input.substring(lineParentStartPosition, endParentPosition));
            int extraIndent = 4;
            for (Tree expression : childExpressions) {
                int startColumn;
                int startingPos = StringWrapper.getStartPosition(expression);
                int startLine = this.lineMap.getLineNumber(startingPos);
                int lineStartPosition = this.lineMap.getStartPosition(startLine);
                int endPos = StringWrapper.getEndPosition(this.unit, expression);
                int endLine = this.lineMap.getLineNumber(endPos);
                int parentLine = shouldUseStartLineParent ? startParentLine : endParentLine;
                if (startLine == parentLine || this.input.startsWith(StringWrapper.TEXT_BLOCK_DELIMITER, lineStartPosition + (startColumn = CharMatcher.whitespace().negate().indexIn((CharSequence)this.input.substring(lineStartPosition, endPos)))) && startingPos != lineStartPosition + startColumn) continue;
                extraIndent = Math.max(extraIndent, startColumn - startParentColumn);
            }
            return " ".repeat(extraIndent + startParentColumn);
        }

        private void wrapLongStrings(TreeRangeMap<Integer, String> replacements, List<TreePath> longStringLiterals) {
            Iterator<TreePath> iterator = longStringLiterals.iterator();
            while (iterator.hasNext()) {
                int end;
                TreePath path;
                TreePath enclosing = path = iterator.next();
                while (enclosing.getParentPath().getLeaf().getKind() == Tree.Kind.PLUS) {
                    enclosing = enclosing.getParentPath();
                }
                AtomicBoolean first = new AtomicBoolean(false);
                List<Tree> flat = StringWrapper.flatten(this.input, this.unit, path, enclosing, first);
                TreePath startingPath = enclosing;
                while (startingPath.getParentPath() != null && Reflower.onSameLineAsParent(this.lineMap, startingPath)) {
                    startingPath = startingPath.getParentPath();
                }
                int startColumn = this.lineMap.getColumnNumber(StringWrapper.getStartPosition(flat.get(0))) - 1;
                int fistLineCol = this.lineMap.getColumnNumber(StringWrapper.getStartPosition(startingPath.getLeaf())) - 1;
                int lineEnd = end = StringWrapper.getEndPosition(this.unit, (Tree)Iterables.getLast(flat));
                while (Newlines.hasNewlineAt(this.input, lineEnd) == -1) {
                    ++lineEnd;
                }
                int trailing = lineEnd - end;
                ImmutableList<String> components = StringWrapper.stringComponents(this.input, this.unit, flat);
                replacements.put(Range.closedOpen((Comparable)Integer.valueOf(StringWrapper.getStartPosition(flat.get(0))), (Comparable)Integer.valueOf(StringWrapper.getEndPosition(this.unit, (Tree)Iterables.getLast(flat)))), (Object)StringWrapper.reflow(this.separator, this.columnLimit, trailing, components, first.get(), startColumn, fistLineCol));
            }
        }

        private static boolean onSameLineAsParent(Position.LineMap lineMap, TreePath path) {
            return lineMap.getLineNumber(StringWrapper.getStartPosition(path.getLeaf())) == lineMap.getLineNumber(StringWrapper.getStartPosition(path.getParentPath().getLeaf()));
        }

        private class LongStringsAndTextBlockScanner
        extends TreePathScanner<Void, Void> {
            private final List<TreePath> longStringLiterals;
            private final List<TreePath> textBlocks;

            LongStringsAndTextBlockScanner(List<TreePath> longStringLiterals, List<TreePath> textBlocks) {
                this.longStringLiterals = longStringLiterals;
                this.textBlocks = textBlocks;
            }

            @Override
            public Void visitLiteral(LiteralTree literalTree, Void aVoid) {
                int endPosition;
                if (literalTree.getKind() != Tree.Kind.STRING_LITERAL) {
                    return null;
                }
                int pos = StringWrapper.getStartPosition(literalTree);
                if (Reflower.this.input.substring(pos, Math.min(Reflower.this.input.length(), pos + StringWrapper.TEXT_BLOCK_DELIMITER.length())).equals(StringWrapper.TEXT_BLOCK_DELIMITER)) {
                    this.textBlocks.add(this.getCurrentPath());
                    return null;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (parent instanceof MemberSelectTree && ((MemberSelectTree)parent).getExpression().equals(literalTree)) {
                    return null;
                }
                int lineEnd = endPosition = StringWrapper.getEndPosition(Reflower.this.unit, literalTree);
                while (Newlines.hasNewlineAt(Reflower.this.input, lineEnd) == -1) {
                    ++lineEnd;
                }
                if (Reflower.this.lineMap.getColumnNumber(lineEnd) - 1 <= Reflower.this.columnLimit) {
                    return null;
                }
                this.longStringLiterals.add(this.getCurrentPath());
                return null;
            }
        }
    }
}

