/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.CommentsHelper;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.Input;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.Output;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.DocBuilder;
import com.palantir.javaformat.doc.Obs;
import com.palantir.javaformat.doc.State;
import java.util.Optional;

@Immutable
public final class Token
extends Doc
implements Op {
    private final Input.Token token;
    private final RealOrImaginary realOrImaginary;
    private final Indent plusIndentCommentsBefore;
    private final Optional<Indent> breakAndIndentTrailingComment;

    private Token(Input.Token token, RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
        this.token = token;
        this.realOrImaginary = realOrImaginary;
        this.plusIndentCommentsBefore = plusIndentCommentsBefore;
        this.breakAndIndentTrailingComment = breakAndIndentTrailingComment;
    }

    public Indent getPlusIndentCommentsBefore() {
        return this.plusIndentCommentsBefore;
    }

    public Optional<Indent> breakAndIndentTrailingComment() {
        return this.breakAndIndentTrailingComment;
    }

    public static Op make(Input.Token token, RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
        return new Token(token, realOrImaginary, plusIndentCommentsBefore, breakAndIndentTrailingComment);
    }

    public Input.Token getToken() {
        return this.token;
    }

    public RealOrImaginary realOrImaginary() {
        return this.realOrImaginary;
    }

    @Override
    public void add(DocBuilder builder) {
        builder.add(this);
    }

    @Override
    protected float computeWidth() {
        if (this.token.getTok().getOriginalText().startsWith("\"\"\"")) {
            return "\"\"\"".length();
        }
        return this.token.getTok().length();
    }

    @Override
    protected String computeFlat() {
        return this.token.getTok().getOriginalText();
    }

    @Override
    protected Range<Integer> computeRange() {
        return Range.singleton((Comparable)Integer.valueOf(this.token.getTok().getIndex())).canonical(INTEGERS);
    }

    @Override
    public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode observationNode) {
        String text = this.token.getTok().getOriginalText();
        if (text.startsWith("\"\"\"")) {
            return state.withColumn(state.column() + "\"\"\"".length());
        }
        return state.withColumn(state.column() + text.length());
    }

    @Override
    public void write(State state, Output output) {
        String text = this.token.getTok().getOriginalText();
        output.append(state, text, this.range());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).add("realOrImaginary", (Object)this.realOrImaginary).add("plusIndentCommentsBefore", (Object)this.plusIndentCommentsBefore).toString();
    }

    public static enum RealOrImaginary {
        REAL,
        IMAGINARY;

    }
}

