/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.BreakTag;
import com.palantir.javaformat.doc.FillMode;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Break", generator="Immutables")
@Immutable
public final class ImmutableBreak
extends Break {
    private final FillMode fillMode;
    private final String flat;
    private final Indent plusIndent;
    @Nullable
    private final BreakTag optTag;
    private final boolean hasColumnLimit;

    private ImmutableBreak(FillMode fillMode, String flat, Indent plusIndent, @Nullable BreakTag optTag, boolean hasColumnLimit) {
        this.fillMode = fillMode;
        this.flat = flat;
        this.plusIndent = plusIndent;
        this.optTag = optTag;
        this.hasColumnLimit = hasColumnLimit;
    }

    @Override
    public FillMode fillMode() {
        return this.fillMode;
    }

    @Override
    public String flat() {
        return this.flat;
    }

    @Override
    public Indent plusIndent() {
        return this.plusIndent;
    }

    @Override
    public Optional<BreakTag> optTag() {
        return Optional.ofNullable(this.optTag);
    }

    @Override
    public boolean hasColumnLimit() {
        return this.hasColumnLimit;
    }

    public final ImmutableBreak withFillMode(FillMode value) {
        FillMode newValue = Objects.requireNonNull(value, "fillMode");
        if (this.fillMode == newValue) {
            return this;
        }
        return new ImmutableBreak(newValue, this.flat, this.plusIndent, this.optTag, this.hasColumnLimit);
    }

    public final ImmutableBreak withFlat(String value) {
        String newValue = Objects.requireNonNull(value, "flat");
        if (this.flat.equals(newValue)) {
            return this;
        }
        return new ImmutableBreak(this.fillMode, newValue, this.plusIndent, this.optTag, this.hasColumnLimit);
    }

    public final ImmutableBreak withPlusIndent(Indent value) {
        if (this.plusIndent == value) {
            return this;
        }
        Indent newValue = Objects.requireNonNull(value, "plusIndent");
        return new ImmutableBreak(this.fillMode, this.flat, newValue, this.optTag, this.hasColumnLimit);
    }

    public final ImmutableBreak withOptTag(BreakTag value) {
        BreakTag newValue = Objects.requireNonNull(value, "optTag");
        if (this.optTag == newValue) {
            return this;
        }
        return new ImmutableBreak(this.fillMode, this.flat, this.plusIndent, newValue, this.hasColumnLimit);
    }

    public final ImmutableBreak withOptTag(Optional<? extends BreakTag> optional) {
        BreakTag value = optional.orElse(null);
        if (this.optTag == value) {
            return this;
        }
        return new ImmutableBreak(this.fillMode, this.flat, this.plusIndent, value, this.hasColumnLimit);
    }

    public final ImmutableBreak withHasColumnLimit(boolean value) {
        if (this.hasColumnLimit == value) {
            return this;
        }
        return new ImmutableBreak(this.fillMode, this.flat, this.plusIndent, this.optTag, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBreak && this.equalsByValue((ImmutableBreak)another);
    }

    private boolean equalsByValue(ImmutableBreak another) {
        return this.fillMode.equals((Object)another.fillMode) && this.flat.equals(another.flat) && this.plusIndent.equals(another.plusIndent) && Objects.equals(this.optTag, another.optTag) && this.hasColumnLimit == another.hasColumnLimit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fillMode.hashCode();
        h += (h << 5) + this.flat.hashCode();
        h += (h << 5) + this.plusIndent.hashCode();
        h += (h << 5) + Objects.hashCode(this.optTag);
        h += (h << 5) + Booleans.hashCode((boolean)this.hasColumnLimit);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Break").omitNullValues().add("fillMode", (Object)this.fillMode).add("flat", (Object)this.flat).add("plusIndent", (Object)this.plusIndent).add("optTag", (Object)this.optTag).add("hasColumnLimit", this.hasColumnLimit).toString();
    }

    public static ImmutableBreak copyOf(Break instance) {
        if (instance instanceof ImmutableBreak) {
            return (ImmutableBreak)instance;
        }
        return new Break.Builder().from(instance).build();
    }

    @Generated(from="Break", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_FILL_MODE = 1L;
        private static final long INIT_BIT_FLAT = 2L;
        private static final long INIT_BIT_PLUS_INDENT = 4L;
        private static final long INIT_BIT_HAS_COLUMN_LIMIT = 8L;
        private long initBits = 15L;
        @Nullable
        private FillMode fillMode;
        @Nullable
        private String flat;
        @Nullable
        private Indent plusIndent;
        @Nullable
        private BreakTag optTag;
        private boolean hasColumnLimit;

        public Builder() {
            if (!(this instanceof Break.Builder)) {
                throw new UnsupportedOperationException("Use: new Break.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final Break.Builder from(Break instance) {
            Objects.requireNonNull(instance, "instance");
            this.fillMode(instance.fillMode());
            this.flat(instance.flat());
            this.plusIndent(instance.plusIndent());
            Optional<BreakTag> optTagOptional = instance.optTag();
            if (optTagOptional.isPresent()) {
                this.optTag(optTagOptional);
            }
            this.hasColumnLimit(instance.hasColumnLimit());
            return (Break.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Break.Builder fillMode(FillMode fillMode) {
            this.fillMode = Objects.requireNonNull(fillMode, "fillMode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Break.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Break.Builder flat(String flat) {
            this.flat = Objects.requireNonNull(flat, "flat");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Break.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Break.Builder plusIndent(Indent plusIndent) {
            this.plusIndent = Objects.requireNonNull(plusIndent, "plusIndent");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (Break.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Break.Builder optTag(BreakTag optTag) {
            this.optTag = Objects.requireNonNull(optTag, "optTag");
            return (Break.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Break.Builder optTag(Optional<? extends BreakTag> optTag) {
            this.optTag = optTag.orElse(null);
            return (Break.Builder)this;
        }

        @CanIgnoreReturnValue
        public final Break.Builder hasColumnLimit(boolean hasColumnLimit) {
            this.hasColumnLimit = hasColumnLimit;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (Break.Builder)this;
        }

        public ImmutableBreak build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBreak(this.fillMode, this.flat, this.plusIndent, this.optTag, this.hasColumnLimit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fillMode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("flat");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("plusIndent");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("hasColumnLimit");
            }
            return "Cannot build Break, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

