/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.javaformat.doc.State;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="State.BreakState", generator="Immutables")
@Immutable
final class ImmutableBreakState
implements State.BreakState {
    private final boolean broken;
    private final int newIndent;

    private ImmutableBreakState(boolean broken, int newIndent) {
        this.broken = broken;
        this.newIndent = newIndent;
    }

    @Override
    @JsonProperty(value="broken", required=true)
    public boolean broken() {
        return this.broken;
    }

    @Override
    @JsonProperty(value="newIndent", required=true)
    public int newIndent() {
        return this.newIndent;
    }

    public final ImmutableBreakState withBroken(boolean value) {
        if (this.broken == value) {
            return this;
        }
        return new ImmutableBreakState(value, this.newIndent);
    }

    public final ImmutableBreakState withNewIndent(int value) {
        if (this.newIndent == value) {
            return this;
        }
        return new ImmutableBreakState(this.broken, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBreakState && this.equalsByValue((ImmutableBreakState)another);
    }

    private boolean equalsByValue(ImmutableBreakState another) {
        return this.broken == another.broken && this.newIndent == another.newIndent;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.broken);
        h += (h << 5) + this.newIndent;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BreakState").omitNullValues().add("broken", this.broken).add("newIndent", this.newIndent).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBreakState fromJson(Json json) {
        Builder builder = ImmutableBreakState.builder();
        if (json.brokenIsSet) {
            builder.broken(json._broken);
        }
        if (json.newIndentIsSet) {
            builder.newIndent(json._newIndent);
        }
        return (ImmutableBreakState)builder.build();
    }

    public static State.BreakState of(boolean broken, int newIndent) {
        return new ImmutableBreakState(broken, newIndent);
    }

    public static State.BreakState copyOf(State.BreakState instance) {
        if (instance instanceof ImmutableBreakState) {
            return (ImmutableBreakState)instance;
        }
        return ImmutableBreakState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="State.BreakState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BROKEN = 1L;
        private static final long INIT_BIT_NEW_INDENT = 2L;
        private long initBits = 3L;
        private boolean broken;
        private int newIndent;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(State.BreakState instance) {
            Objects.requireNonNull(instance, "instance");
            this.broken(instance.broken());
            this.newIndent(instance.newIndent());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder broken(boolean broken) {
            this.broken = broken;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder newIndent(int newIndent) {
            this.newIndent = newIndent;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public State.BreakState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBreakState(this.broken, this.newIndent);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("broken");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("newIndent");
            }
            return "Cannot build BreakState, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @Generated(from="State.BreakState", generator="Immutables")
    static final class Json
    implements State.BreakState {
        @JsonIgnore
        boolean _broken;
        @JsonIgnore
        boolean brokenIsSet;
        @JsonIgnore
        int _newIndent;
        @JsonIgnore
        boolean newIndentIsSet;

        Json() {
        }

        @JsonProperty(value="broken", required=true)
        public void setBroken(boolean broken) {
            this._broken = broken;
            this.brokenIsSet = true;
        }

        @JsonProperty(value="newIndent", required=true)
        public void setNewIndent(int newIndent) {
            this._newIndent = newIndent;
            this.newIndentIsSet = true;
        }

        @Override
        public boolean broken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int newIndent() {
            throw new UnsupportedOperationException();
        }
    }
}

