/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.array;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

public abstract class AbstractOffheapArray {
    protected static final Unsafe UNSAFE;
    private static final CleanerCreateMethod createMethod;
    private static final Method cleanMethod;
    private final Object cleaner;
    private final AtomicLong boxedAddress;
    protected long address;
    protected long capacity;

    public AbstractOffheapArray(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Cannot allocate with capacity=" + capacity);
        }
        this.address = UNSAFE.allocateMemory(capacity);
        this.boxedAddress = new AtomicLong(this.address);
        this.cleaner = AbstractOffheapArray.createCleaner(this, new Deallocator(this.boxedAddress));
        UNSAFE.setMemory(this.address, capacity, (byte)0);
        this.capacity = capacity;
    }

    protected void resize(long newCapacity) {
        long currAddress = this.address;
        if (newCapacity < 0L) {
            throw new IllegalArgumentException("Cannot reallocate with capacity=" + newCapacity);
        }
        if (currAddress == 0L || this.boxedAddress.get() != currAddress) {
            throw new IllegalStateException("Cannot reallocate after freeing");
        }
        long newAddress = UNSAFE.reallocateMemory(currAddress, newCapacity);
        if (!this.boxedAddress.compareAndSet(currAddress, newAddress)) {
            UNSAFE.freeMemory(newAddress);
            throw new IllegalStateException("Race condition while resizing");
        }
        this.address = this.boxedAddress.get();
        if (newCapacity > this.capacity) {
            UNSAFE.setMemory(this.address + this.capacity, newCapacity - this.capacity, (byte)0);
        }
        this.capacity = newCapacity;
    }

    public void clear() {
        if (this.capacity > 0L) {
            UNSAFE.setMemory(this.address, this.capacity, (byte)0);
        }
    }

    public void free() {
        this.address = 0L;
        this.capacity = 0L;
        this.clean();
    }

    public abstract long capacity();

    protected void check(long index) {
        if (index < 0L || index >= this.capacity()) {
            throw new IndexOutOfBoundsException("index=" + index + ", capacity=" + this.capacity());
        }
    }

    protected void check(long ourIndex, int arrayIndex, int arrayLength, int length) {
        if (ourIndex < 0L || length < 0 || ourIndex + (long)length > this.capacity() || arrayIndex < 0 || arrayIndex + length > arrayLength) {
            throw new IndexOutOfBoundsException("ourIndex=" + ourIndex + ", ourLength=" + this.capacity() + ", arrayIndex=" + arrayIndex + ", arrayLength=" + arrayLength + ", length=" + length);
        }
    }

    private static Field getPrivateDeclaredField(final Class<?> clazz, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    Field f = clazz.getDeclaredField(name);
                    f.setAccessible(true);
                    return f;
                }
                catch (SecurityException e) {
                    throw new IllegalStateException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private static Object createCleaner(Object obj, Runnable cleanUpRunnable) {
        if (createMethod == null) {
            throw new IllegalStateException("Was not able to find Cleaner#create method to use.");
        }
        try {
            return AbstractOffheapArray.createMethod.method.invoke(AbstractOffheapArray.createMethod.instance, obj, cleanUpRunnable);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Could not create a new cleaner.", e);
        }
    }

    private void clean() {
        if (cleanMethod == null) {
            throw new IllegalStateException("Was not able to find Cleaner#clean to use.");
        }
        try {
            cleanMethod.invoke(this.cleaner, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Could not invoke clean method.", e);
        }
    }

    private static CleanerCreateMethod initializeCreateMethod() {
        try {
            Class<?> cleaner = Class.forName("sun.misc.Cleaner");
            return new CleanerCreateMethod(cleaner.getMethod("create", Object.class, Runnable.class), null);
        }
        catch (ReflectiveOperationException cleaner) {
            try {
                Class<?> cleaner2 = Class.forName("java.lang.ref.Cleaner");
                Method create = cleaner2.getMethod("create", new Class[0]);
                Object cleanerInstance = create.invoke(null, new Object[0]);
                return new CleanerCreateMethod(cleaner2.getMethod("register", Object.class, Runnable.class), cleanerInstance);
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }
    }

    private static Method initializeCleanMethod() {
        try {
            Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
            return cleanerClass.getMethod("clean", new Class[0]);
        }
        catch (ReflectiveOperationException cleanerClass) {
            try {
                Class<?> cleanerClass2 = Class.forName("java.lang.ref.Cleaner$Cleanable");
                return cleanerClass2.getMethod("clean", new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                return null;
            }
        }
    }

    static {
        createMethod = AbstractOffheapArray.initializeCreateMethod();
        cleanMethod = AbstractOffheapArray.initializeCleanMethod();
        Field f = AbstractOffheapArray.getPrivateDeclaredField(Unsafe.class, "theUnsafe");
        try {
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class CleanerCreateMethod {
        final Method method;
        final Object instance;

        private CleanerCreateMethod(Method method, Object instance) {
            this.method = method;
            this.instance = instance;
        }
    }

    private static class Deallocator
    implements Runnable {
        private final AtomicLong boxedAddress;

        private Deallocator(AtomicLong boxedAddress) {
            if (boxedAddress.get() == 0L) {
                throw new IllegalArgumentException("Cannot allocate with address 0");
            }
            this.boxedAddress = boxedAddress;
        }

        @Override
        public void run() {
            UNSAFE.freeMemory(this.boxedAddress.getAndSet(0L));
        }
    }
}

