/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.array;

import gnu.trove.array.AbstractOffheapArray;
import java.util.Arrays;

public class TCharOffheapArray
extends AbstractOffheapArray {
    private static final int SHIFT = 31 - Integer.numberOfLeadingZeros(2);
    private static final long ARRAY_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
    private static final int ARRAY_SHIFT = 31 - Integer.numberOfLeadingZeros(UNSAFE.arrayIndexScale(char[].class));
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    public TCharOffheapArray(long capacity) {
        super(capacity << SHIFT);
    }

    @Override
    public void resize(long newCapacity) {
        super.resize(newCapacity << SHIFT);
    }

    public void put(long index, char value) {
        this.check(index);
        UNSAFE.putChar(this.address + (index << SHIFT), value);
    }

    public char get(long index) {
        this.check(index);
        return UNSAFE.getChar(this.address + (index << SHIFT));
    }

    public void toArray(long srcIndex, char[] dst, int dstIndex, int length) {
        this.check(srcIndex, dstIndex, dst.length, length);
        long srcAddress = this.address + (srcIndex << SHIFT);
        long dstOffset = ARRAY_OFFSET + ((long)dstIndex << ARRAY_SHIFT);
        long longLength = (long)length << SHIFT;
        while (longLength > 0L) {
            long size = (long)length > 0x100000L ? 0x100000L : longLength;
            UNSAFE.copyMemory(null, srcAddress, dst, dstOffset, size);
            longLength -= size;
            srcAddress += size;
            dstOffset += size;
        }
    }

    public void fromArray(char[] src, int srcIndex, long dstIndex, int length) {
        this.check(dstIndex, srcIndex, src.length, length);
        long dstAddress = this.address + (dstIndex << SHIFT);
        long srcOffset = ARRAY_OFFSET + ((long)srcIndex << ARRAY_SHIFT);
        long longLength = (long)length << SHIFT;
        while (longLength > 0L) {
            long size = (long)length > 0x100000L ? 0x100000L : longLength;
            UNSAFE.copyMemory(src, srcOffset, null, dstAddress, size);
            longLength -= size;
            dstAddress += size;
            srcOffset += size;
        }
    }

    @Override
    public long capacity() {
        return this.capacity >> SHIFT;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[");
        for (long i = 0L; i < this.capacity(); ++i) {
            if (i > 0L) {
                s.append(", ");
            }
            s.append(UNSAFE.getChar(this.address + (i << SHIFT)));
        }
        s.append("]");
        return s.toString();
    }

    private static void staticAssert(boolean condition) {
        if (!condition) {
            throw new Error("Failed initialization checks");
        }
    }

    static {
        TCharOffheapArray array = new TCharOffheapArray(10L);
        assert (array.capacity() == 10L);
        array.put(3L, '\uffd3');
        array.put(5L, 'y');
        TCharOffheapArray.staticAssert(array.get(1L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(2L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(3L) == '\uffffffd3');
        TCharOffheapArray.staticAssert(array.get(4L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(5L) == 'y');
        TCharOffheapArray.staticAssert(array.get(6L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(7L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(8L) == '\u0000');
        array.resize(5L);
        TCharOffheapArray.staticAssert(array.capacity() == 5L);
        TCharOffheapArray.staticAssert(array.get(1L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(2L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(3L) == '\uffffffd3');
        TCharOffheapArray.staticAssert(array.get(4L) == '\u0000');
        array.resize(20L);
        TCharOffheapArray.staticAssert(array.capacity() == 20L);
        TCharOffheapArray.staticAssert(array.get(1L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(2L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(3L) == '\uffffffd3');
        TCharOffheapArray.staticAssert(array.get(4L) == '\u0000');
        array.fromArray(new char[]{'\ufffd', '\u0000', '\u0004', '\u0005'}, 0, 7L, 4);
        TCharOffheapArray.staticAssert(array.get(6L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(7L) == '\ufffffffd');
        TCharOffheapArray.staticAssert(array.get(8L) == '\u0000');
        TCharOffheapArray.staticAssert(array.get(9L) == '\u0004');
        TCharOffheapArray.staticAssert(array.get(10L) == '\u0005');
        TCharOffheapArray.staticAssert(array.get(11L) == '\u0000');
        char[] dst = new char[5];
        array.toArray(3L, dst, 0, 5);
        TCharOffheapArray.staticAssert(Arrays.equals(dst, new char[]{'\uffd3', '\u0000', '\u0000', '\u0000', '\ufffd'}));
        array.clear();
        array.toArray(3L, dst, 0, 5);
        TCharOffheapArray.staticAssert(Arrays.equals(dst, new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}));
        array.free();
    }
}

