/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.array;

import gnu.trove.array.AbstractOffheapArray;
import java.util.Arrays;

public class TIntOffheapArray
extends AbstractOffheapArray {
    private static final int SHIFT = 31 - Integer.numberOfLeadingZeros(4);
    private static final long ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    private static final int ARRAY_SHIFT = 31 - Integer.numberOfLeadingZeros(UNSAFE.arrayIndexScale(int[].class));
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    public TIntOffheapArray(long capacity) {
        super(capacity << SHIFT);
    }

    @Override
    public void resize(long newCapacity) {
        super.resize(newCapacity << SHIFT);
    }

    public void put(long index, int value) {
        this.check(index);
        UNSAFE.putInt(this.address + (index << SHIFT), value);
    }

    public int get(long index) {
        this.check(index);
        return UNSAFE.getInt(this.address + (index << SHIFT));
    }

    public void toArray(long srcIndex, int[] dst, int dstIndex, int length) {
        this.check(srcIndex, dstIndex, dst.length, length);
        long srcAddress = this.address + (srcIndex << SHIFT);
        long dstOffset = ARRAY_OFFSET + ((long)dstIndex << ARRAY_SHIFT);
        long longLength = (long)length << SHIFT;
        while (longLength > 0L) {
            long size = (long)length > 0x100000L ? 0x100000L : longLength;
            UNSAFE.copyMemory(null, srcAddress, dst, dstOffset, size);
            longLength -= size;
            srcAddress += size;
            dstOffset += size;
        }
    }

    public void fromArray(int[] src, int srcIndex, long dstIndex, int length) {
        this.check(dstIndex, srcIndex, src.length, length);
        long dstAddress = this.address + (dstIndex << SHIFT);
        long srcOffset = ARRAY_OFFSET + ((long)srcIndex << ARRAY_SHIFT);
        long longLength = (long)length << SHIFT;
        while (longLength > 0L) {
            long size = (long)length > 0x100000L ? 0x100000L : longLength;
            UNSAFE.copyMemory(src, srcOffset, null, dstAddress, size);
            longLength -= size;
            dstAddress += size;
            srcOffset += size;
        }
    }

    @Override
    public long capacity() {
        return this.capacity >> SHIFT;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[");
        for (long i = 0L; i < this.capacity(); ++i) {
            if (i > 0L) {
                s.append(", ");
            }
            s.append(UNSAFE.getInt(this.address + (i << SHIFT)));
        }
        s.append("]");
        return s.toString();
    }

    private static void staticAssert(boolean condition) {
        if (!condition) {
            throw new Error("Failed initialization checks");
        }
    }

    static {
        TIntOffheapArray array = new TIntOffheapArray(10L);
        assert (array.capacity() == 10L);
        array.put(3L, -45);
        array.put(5L, 121);
        TIntOffheapArray.staticAssert(array.get(1L) == 0);
        TIntOffheapArray.staticAssert(array.get(2L) == 0);
        TIntOffheapArray.staticAssert(array.get(3L) == -45);
        TIntOffheapArray.staticAssert(array.get(4L) == 0);
        TIntOffheapArray.staticAssert(array.get(5L) == 121);
        TIntOffheapArray.staticAssert(array.get(6L) == 0);
        TIntOffheapArray.staticAssert(array.get(7L) == 0);
        TIntOffheapArray.staticAssert(array.get(8L) == 0);
        array.resize(5L);
        TIntOffheapArray.staticAssert(array.capacity() == 5L);
        TIntOffheapArray.staticAssert(array.get(1L) == 0);
        TIntOffheapArray.staticAssert(array.get(2L) == 0);
        TIntOffheapArray.staticAssert(array.get(3L) == -45);
        TIntOffheapArray.staticAssert(array.get(4L) == 0);
        array.resize(20L);
        TIntOffheapArray.staticAssert(array.capacity() == 20L);
        TIntOffheapArray.staticAssert(array.get(1L) == 0);
        TIntOffheapArray.staticAssert(array.get(2L) == 0);
        TIntOffheapArray.staticAssert(array.get(3L) == -45);
        TIntOffheapArray.staticAssert(array.get(4L) == 0);
        array.fromArray(new int[]{-3, 0, 4, 5}, 0, 7L, 4);
        TIntOffheapArray.staticAssert(array.get(6L) == 0);
        TIntOffheapArray.staticAssert(array.get(7L) == -3);
        TIntOffheapArray.staticAssert(array.get(8L) == 0);
        TIntOffheapArray.staticAssert(array.get(9L) == 4);
        TIntOffheapArray.staticAssert(array.get(10L) == 5);
        TIntOffheapArray.staticAssert(array.get(11L) == 0);
        int[] dst = new int[5];
        array.toArray(3L, dst, 0, 5);
        TIntOffheapArray.staticAssert(Arrays.equals(dst, new int[]{-45, 0, 0, 0, -3}));
        array.clear();
        array.toArray(3L, dst, 0, 5);
        TIntOffheapArray.staticAssert(Arrays.equals(dst, new int[]{0, 0, 0, 0, 0}));
        array.free();
    }
}

