/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.array;

import gnu.trove.array.AbstractOffheapArray;
import java.util.Arrays;

public class TLongOffheapArray
extends AbstractOffheapArray {
    private static final int SHIFT = 31 - Integer.numberOfLeadingZeros(8);
    private static final long ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    private static final int ARRAY_SHIFT = 31 - Integer.numberOfLeadingZeros(UNSAFE.arrayIndexScale(long[].class));
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    public TLongOffheapArray(long capacity) {
        super(capacity << SHIFT);
    }

    @Override
    public void resize(long newCapacity) {
        super.resize(newCapacity << SHIFT);
    }

    public void put(long index, long value) {
        this.check(index);
        UNSAFE.putLong(this.address + (index << SHIFT), value);
    }

    public long get(long index) {
        this.check(index);
        return UNSAFE.getLong(this.address + (index << SHIFT));
    }

    public void toArray(long srcIndex, long[] dst, int dstIndex, int length) {
        this.check(srcIndex, dstIndex, dst.length, length);
        long srcAddress = this.address + (srcIndex << SHIFT);
        long dstOffset = ARRAY_OFFSET + ((long)dstIndex << ARRAY_SHIFT);
        long longLength = (long)length << SHIFT;
        while (longLength > 0L) {
            long size = (long)length > 0x100000L ? 0x100000L : longLength;
            UNSAFE.copyMemory(null, srcAddress, dst, dstOffset, size);
            longLength -= size;
            srcAddress += size;
            dstOffset += size;
        }
    }

    public void fromArray(long[] src, int srcIndex, long dstIndex, int length) {
        this.check(dstIndex, srcIndex, src.length, length);
        long dstAddress = this.address + (dstIndex << SHIFT);
        long srcOffset = ARRAY_OFFSET + ((long)srcIndex << ARRAY_SHIFT);
        long longLength = (long)length << SHIFT;
        while (longLength > 0L) {
            long size = (long)length > 0x100000L ? 0x100000L : longLength;
            UNSAFE.copyMemory(src, srcOffset, null, dstAddress, size);
            longLength -= size;
            dstAddress += size;
            srcOffset += size;
        }
    }

    @Override
    public long capacity() {
        return this.capacity >> SHIFT;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[");
        for (long i = 0L; i < this.capacity(); ++i) {
            if (i > 0L) {
                s.append(", ");
            }
            s.append(UNSAFE.getLong(this.address + (i << SHIFT)));
        }
        s.append("]");
        return s.toString();
    }

    private static void staticAssert(boolean condition) {
        if (!condition) {
            throw new Error("Failed initialization checks");
        }
    }

    static {
        TLongOffheapArray array = new TLongOffheapArray(10L);
        assert (array.capacity() == 10L);
        array.put(3L, -45L);
        array.put(5L, 121L);
        TLongOffheapArray.staticAssert(array.get(1L) == 0L);
        TLongOffheapArray.staticAssert(array.get(2L) == 0L);
        TLongOffheapArray.staticAssert(array.get(3L) == -45L);
        TLongOffheapArray.staticAssert(array.get(4L) == 0L);
        TLongOffheapArray.staticAssert(array.get(5L) == 121L);
        TLongOffheapArray.staticAssert(array.get(6L) == 0L);
        TLongOffheapArray.staticAssert(array.get(7L) == 0L);
        TLongOffheapArray.staticAssert(array.get(8L) == 0L);
        array.resize(5L);
        TLongOffheapArray.staticAssert(array.capacity() == 5L);
        TLongOffheapArray.staticAssert(array.get(1L) == 0L);
        TLongOffheapArray.staticAssert(array.get(2L) == 0L);
        TLongOffheapArray.staticAssert(array.get(3L) == -45L);
        TLongOffheapArray.staticAssert(array.get(4L) == 0L);
        array.resize(20L);
        TLongOffheapArray.staticAssert(array.capacity() == 20L);
        TLongOffheapArray.staticAssert(array.get(1L) == 0L);
        TLongOffheapArray.staticAssert(array.get(2L) == 0L);
        TLongOffheapArray.staticAssert(array.get(3L) == -45L);
        TLongOffheapArray.staticAssert(array.get(4L) == 0L);
        array.fromArray(new long[]{-3L, 0L, 4L, 5L}, 0, 7L, 4);
        TLongOffheapArray.staticAssert(array.get(6L) == 0L);
        TLongOffheapArray.staticAssert(array.get(7L) == -3L);
        TLongOffheapArray.staticAssert(array.get(8L) == 0L);
        TLongOffheapArray.staticAssert(array.get(9L) == 4L);
        TLongOffheapArray.staticAssert(array.get(10L) == 5L);
        TLongOffheapArray.staticAssert(array.get(11L) == 0L);
        long[] dst = new long[5];
        array.toArray(3L, dst, 0, 5);
        TLongOffheapArray.staticAssert(Arrays.equals(dst, new long[]{-45L, 0L, 0L, 0L, -3L}));
        array.clear();
        array.toArray(3L, dst, 0, 5);
        TLongOffheapArray.staticAssert(Arrays.equals(dst, new long[]{0L, 0L, 0L, 0L, 0L}));
        array.free();
    }
}

