/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TDoubleOffheapArray;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.procedure.TDoubleProcedure;

public abstract class TDoubleOffheapHash
extends TPrimitiveOffheapHash {
    static final long serialVersionUID = 1L;
    public transient TDoubleOffheapArray _set = new TDoubleOffheapArray(this.capacity());
    protected double no_entry_value;
    protected boolean consumeFreeSlot;

    public TDoubleOffheapHash() {
        this(10, 0.5f);
    }

    public TDoubleOffheapHash(int capacity) {
        this(capacity, 0.5f);
    }

    public TDoubleOffheapHash(int initialCapacity, float load_factor) {
        super(initialCapacity, load_factor);
    }

    public double getNoEntryValue() {
        return Constants.DEFAULT_DOUBLE_NO_ENTRY_VALUE;
    }

    public boolean contains(double val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray set = this._set;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(set.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index) {
        this._set.put(index, this.no_entry_value);
        super.removeAt(index);
    }

    protected int index(double val) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray set = this._set;
        int length = this.capacity();
        int hash = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index = hash % length;
        byte state = states.get(index);
        if (state == 0) {
            return -1;
        }
        if (state == 1 && set.get(index) == val) {
            return index;
        }
        return this.indexRehashed(val, index, hash, state);
    }

    int indexRehashed(double key, int index, int hash, byte state) {
        int length = this.capacity();
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states.get(index)) == 0) {
                return -1;
            }
            if (key != this._set.get(index) || state == 2) continue;
            return index;
        } while (index != loopIndex);
        return -1;
    }

    protected int insertKey(double val) {
        int hash = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index = hash % this.capacity();
        byte state = this._states.get(index);
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index, val);
            return index;
        }
        if (state == 1 && this._set.get(index) == val) {
            return -index - 1;
        }
        return this.insertKeyRehash(val, index, hash, state);
    }

    int insertKeyRehash(double val, int index, int hash, byte state) {
        int length = this.capacity();
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        int firstRemoved = -1;
        do {
            if (state == 2 && firstRemoved == -1) {
                firstRemoved = index;
            }
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states.get(index)) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index, val);
                return index;
            }
            if (state != 1 || this._set.get(index) != val) continue;
            return -index - 1;
        } while (index != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index, double val) {
        this._set.put(index, val);
        this._states.put(index, (byte)1);
    }
}

