/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TIntOffheapArray;
import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.procedure.TIntProcedure;

public abstract class TIntOffheapHash
extends TPrimitiveOffheapHash {
    static final long serialVersionUID = 1L;
    public transient TIntOffheapArray _set = new TIntOffheapArray(this.capacity());
    protected int no_entry_value;
    protected boolean consumeFreeSlot;

    public TIntOffheapHash() {
        this(10, 0.5f);
    }

    public TIntOffheapHash(int capacity) {
        this(capacity, 0.5f);
    }

    public TIntOffheapHash(int initialCapacity, float load_factor) {
        super(initialCapacity, load_factor);
    }

    public int getNoEntryValue() {
        return Constants.DEFAULT_INT_NO_ENTRY_VALUE;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        TByteOffheapArray states = this._states;
        TIntOffheapArray set = this._set;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(set.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index) {
        this._set.put(index, this.no_entry_value);
        super.removeAt(index);
    }

    protected int index(int val) {
        TByteOffheapArray states = this._states;
        TIntOffheapArray set = this._set;
        int length = this.capacity();
        int hash = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index = hash % length;
        byte state = states.get(index);
        if (state == 0) {
            return -1;
        }
        if (state == 1 && set.get(index) == val) {
            return index;
        }
        return this.indexRehashed(val, index, hash, state);
    }

    int indexRehashed(int key, int index, int hash, byte state) {
        int length = this.capacity();
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states.get(index)) == 0) {
                return -1;
            }
            if (key != this._set.get(index) || state == 2) continue;
            return index;
        } while (index != loopIndex);
        return -1;
    }

    protected int insertKey(int val) {
        int hash = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index = hash % this.capacity();
        byte state = this._states.get(index);
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index, val);
            return index;
        }
        if (state == 1 && this._set.get(index) == val) {
            return -index - 1;
        }
        return this.insertKeyRehash(val, index, hash, state);
    }

    int insertKeyRehash(int val, int index, int hash, byte state) {
        int length = this.capacity();
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        int firstRemoved = -1;
        do {
            if (state == 2 && firstRemoved == -1) {
                firstRemoved = index;
            }
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states.get(index)) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index, val);
                return index;
            }
            if (state != 1 || this._set.get(index) != val) continue;
            return -index - 1;
        } while (index != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index, int val) {
        this._set.put(index, val);
        this._states.put(index, (byte)1);
    }
}

