/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TLongOffheapArray;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.procedure.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class TLongDoubleOffheapHash
extends TPrimitiveOffheapHash {
    static final long serialVersionUID = 1L;
    public transient TLongOffheapArray _set = new TLongOffheapArray(this.capacity());
    protected long no_entry_key = 0L;
    protected double no_entry_value = 0.0;
    protected boolean consumeFreeSlot;

    public TLongDoubleOffheapHash() {
        this(10, 0.5f);
    }

    public TLongDoubleOffheapHash(int capacity) {
        this(capacity, 0.5f);
    }

    public TLongDoubleOffheapHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public long getNoEntryKey() {
        return this.no_entry_key;
    }

    public double getNoEntryValue() {
        return this.no_entry_value;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TLongProcedure procedure) {
        TByteOffheapArray states = this._states;
        TLongOffheapArray set = this._set;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(set.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index) {
        this._set.put(index, this.no_entry_key);
        super.removeAt(index);
    }

    protected int index(long key) {
        TByteOffheapArray states = this._states;
        TLongOffheapArray set = this._set;
        int length = this.capacity();
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int index = hash % length;
        byte state = states.get(index);
        if (state == 0) {
            return -1;
        }
        if (state == 1 && set.get(index) == key) {
            return index;
        }
        return this.indexRehashed(key, index, hash, state);
    }

    int indexRehashed(long key, int index, int hash, byte state) {
        int length = this.capacity();
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states.get(index)) == 0) {
                return -1;
            }
            if (key != this._set.get(index) || state == 2) continue;
            return index;
        } while (index != loopIndex);
        return -1;
    }

    protected int insertKey(long val) {
        int hash = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int index = hash % this.capacity();
        byte state = this._states.get(index);
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.insertKeyAt(index, val);
            return index;
        }
        if (state == 1 && this._set.get(index) == val) {
            return -index - 1;
        }
        return this.insertKeyRehash(val, index, hash, state);
    }

    int insertKeyRehash(long val, int index, int hash, byte state) {
        int length = this.capacity();
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        int firstRemoved = -1;
        do {
            if (state == 2 && firstRemoved == -1) {
                firstRemoved = index;
            }
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this._states.get(index)) == 0) {
                if (firstRemoved != -1) {
                    this.insertKeyAt(firstRemoved, val);
                    return firstRemoved;
                }
                this.consumeFreeSlot = true;
                this.insertKeyAt(index, val);
                return index;
            }
            if (state != 1 || this._set.get(index) != val) continue;
            return -index - 1;
        } while (index != loopIndex);
        if (firstRemoved != -1) {
            this.insertKeyAt(firstRemoved, val);
            return firstRemoved;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    void insertKeyAt(int index, long val) {
        this._set.put(index, val);
        this._states.put(index, (byte)1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeLong(this.no_entry_key);
        out.writeDouble(this.no_entry_value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.no_entry_key = in.readLong();
        this.no_entry_value = in.readDouble();
    }
}

