/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.array.TByteOffheapArray;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THash;

public abstract class TPrimitiveOffheapHash
extends THash {
    static final long serialVersionUID = 1L;
    public transient TByteOffheapArray _states;
    public static final byte FREE = 0;
    public static final byte FULL = 1;
    public static final byte REMOVED = 2;

    public TPrimitiveOffheapHash() {
        this(10, 0.5f);
    }

    public TPrimitiveOffheapHash(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public TPrimitiveOffheapHash(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(1, initialCapacity);
        this._loadFactor = loadFactor;
        this.setUp(HashFunctions.fastCeil((float)initialCapacity / loadFactor));
    }

    @Override
    public int capacity() {
        return (int)this._states.capacity();
    }

    @Override
    protected void removeAt(int index) {
        this._states.put(index, (byte)2);
        super.removeAt(index);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._states = new TByteOffheapArray(capacity);
        return capacity;
    }
}

