/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.array;

import gnu.trove.TByteCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.function.TByteFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.list.TByteList;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.procedure.TByteProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Random;

public class TByteOffheapArrayList
implements TByteList,
Externalizable {
    static final long serialVersionUID = 1L;
    protected TByteOffheapArray _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected byte no_entry_value;

    public TByteOffheapArrayList() {
        this(10, 0);
    }

    public TByteOffheapArrayList(int capacity) {
        this(capacity, 0);
    }

    public TByteOffheapArrayList(int capacity, byte no_entry_value) {
        this._data = new TByteOffheapArray(capacity);
        this._pos = 0;
        this.no_entry_value = no_entry_value;
    }

    @Override
    public byte getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int capacity) {
        int oldCapacity = this.capacity();
        if (capacity > oldCapacity) {
            int newCap = Math.max(oldCapacity << 1, capacity);
            this._data.resize(newCap);
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    protected int capacity() {
        return (int)this._data.capacity();
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this.capacity() > this.size()) {
            this._data.resize(this.size());
        }
    }

    @Override
    public boolean add(byte val) {
        this.ensureCapacity(this._pos + 1);
        this._data.put(this._pos++, val);
        return true;
    }

    @Override
    public void add(byte[] vals) {
        this.add(vals, 0, vals.length);
    }

    @Override
    public void add(byte[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        this._data.fromArray(vals, offset, this._pos, length);
        this._pos += length;
    }

    @Override
    public void insert(int offset, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, byte[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, byte[] values, int valOffset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data.get(offset);
    }

    public byte getQuick(int offset) {
        return this._data.get(offset);
    }

    @Override
    public byte set(int offset, byte val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        byte prev_val = this._data.get(offset);
        this._data.put(offset, val);
        return prev_val;
    }

    @Override
    public byte replace(int offset, byte val) {
        return this.set(offset, val);
    }

    @Override
    public void set(int offset, byte[] values) {
        this.set(offset, values, 0, values.length);
    }

    @Override
    public void set(int offset, byte[] values, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data.fromArray(values, valOffset, offset, length);
    }

    public void setQuick(int offset, byte val) {
        this._data.put(offset, val);
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data.resize(capacity);
        this._data.clear();
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
    }

    @Override
    public boolean remove(byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte removeAt(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteIterator iterator() {
        return new TByteOffheapArrayIterator(0);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(TByteCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(byte[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Byte> collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        for (Byte by : collection) {
            byte e = by;
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TByteCollection collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        TByteIterator iter = collection.iterator();
        while (iter.hasNext()) {
            byte element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(byte[] array) {
        boolean changed = false;
        this.ensureCapacity(this._pos + array.length);
        for (byte element : array) {
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(TByteCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(byte[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(TByteCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(byte[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transformValues(TByteFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data.put(i, function.execute(this._data.get(i)));
        }
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reverse(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shuffle(Random rand) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteList subList(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("end index " + end + " greater than begin index " + begin);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this.capacity()) {
            throw new IndexOutOfBoundsException("end index < " + this.capacity());
        }
        TByteArrayList list = new TByteArrayList(end - begin);
        this._data.toArray(begin, list._data, 0, end - begin);
        list._pos = end - begin;
        return list;
    }

    @Override
    public byte[] toArray() {
        return this.toArray(0, this._pos);
    }

    @Override
    public byte[] toArray(int offset, int len) {
        byte[] rv = new byte[len];
        this.toArray(rv, offset, len);
        return rv;
    }

    @Override
    public byte[] toArray(byte[] dest) {
        int len = dest.length;
        if (dest.length > this._pos) {
            len = this._pos;
            dest[len] = this.no_entry_value;
        }
        this.toArray(dest, 0, len);
        return dest;
    }

    @Override
    public byte[] toArray(byte[] dest, int offset, int len) {
        return this.toArray(dest, offset, 0, len);
    }

    @Override
    public byte[] toArray(byte[] dest, int source_pos, int dest_pos, int len) {
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        this._data.toArray(source_pos, dest, dest_pos, len);
        return dest;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TByteOffheapArrayList) {
            TByteOffheapArrayList that = (TByteOffheapArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data.get(i) == that._data.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data.get(i));
        }
        return h;
    }

    @Override
    public boolean forEach(TByteProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TByteProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(byte val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(int fromIndex, int toIndex, byte val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int binarySearch(byte value) {
        return this.binarySearch(value, 0, this._pos);
    }

    @Override
    public int binarySearch(byte value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = this._data.get(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(byte value) {
        return this.indexOf(0, value);
    }

    @Override
    public int indexOf(int offset, byte value) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte value) {
        return this.lastIndexOf(this._pos, value);
    }

    @Override
    public int lastIndexOf(int offset, byte value) {
        int i = offset;
        while (i-- > 0) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(byte value) {
        return this.lastIndexOf(value) >= 0;
    }

    @Override
    public TByteList grep(TByteProcedure condition) {
        TByteArrayList list = new TByteArrayList();
        for (int i = 0; i < this._pos; ++i) {
            byte val = this._data.get(i);
            if (!condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public TByteList inverseGrep(TByteProcedure condition) {
        TByteArrayList list = new TByteArrayList();
        for (int i = 0; i < this._pos; ++i) {
            byte val = this._data.get(i);
            if (condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public byte max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        byte max = -128;
        for (int i = 0; i < this._pos; ++i) {
            byte val = this._data.get(i);
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    @Override
    public byte min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        byte min = 127;
        for (int i = 0; i < this._pos; ++i) {
            byte val = this._data.get(i);
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    @Override
    public byte sum() {
        byte sum = 0;
        for (int i = 0; i < this._pos; ++i) {
            sum = (byte)(sum + this._data.get(i));
        }
        return sum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        int end = this._pos - 1;
        for (int i = 0; i < end; ++i) {
            buf.append(this._data.get(i));
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data.get(this._pos - 1));
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        out.writeByte(this.no_entry_value);
        int len = this.capacity();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeByte(this._data.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        this.no_entry_value = in.readByte();
        int len = in.readInt();
        this._data = new TByteOffheapArray(len);
        for (int i = 0; i < len; ++i) {
            this._data.put(i, in.readByte());
        }
    }

    class TByteOffheapArrayIterator
    implements TByteIterator {
        private int cursor = 0;
        int lastRet = -1;

        TByteOffheapArrayIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < TByteOffheapArrayList.this.size();
        }

        @Override
        public byte next() {
            try {
                byte next = TByteOffheapArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

