/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.array;

import gnu.trove.TCharCollection;
import gnu.trove.array.TCharOffheapArray;
import gnu.trove.function.TCharFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TCharIterator;
import gnu.trove.list.TCharList;
import gnu.trove.list.array.TCharArrayList;
import gnu.trove.procedure.TCharProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Random;

public class TCharOffheapArrayList
implements TCharList,
Externalizable {
    static final long serialVersionUID = 1L;
    protected TCharOffheapArray _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected char no_entry_value;

    public TCharOffheapArrayList() {
        this(10, '\u0000');
    }

    public TCharOffheapArrayList(int capacity) {
        this(capacity, '\u0000');
    }

    public TCharOffheapArrayList(int capacity, char no_entry_value) {
        this._data = new TCharOffheapArray(capacity);
        this._pos = 0;
        this.no_entry_value = no_entry_value;
    }

    @Override
    public char getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int capacity) {
        int oldCapacity = this.capacity();
        if (capacity > oldCapacity) {
            int newCap = Math.max(oldCapacity << 1, capacity);
            this._data.resize(newCap);
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    protected int capacity() {
        return (int)this._data.capacity();
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this.capacity() > this.size()) {
            this._data.resize(this.size());
        }
    }

    @Override
    public boolean add(char val) {
        this.ensureCapacity(this._pos + 1);
        this._data.put(this._pos++, val);
        return true;
    }

    @Override
    public void add(char[] vals) {
        this.add(vals, 0, vals.length);
    }

    @Override
    public void add(char[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        this._data.fromArray(vals, offset, this._pos, length);
        this._pos += length;
    }

    @Override
    public void insert(int offset, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, char[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, char[] values, int valOffset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data.get(offset);
    }

    public char getQuick(int offset) {
        return this._data.get(offset);
    }

    @Override
    public char set(int offset, char val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        char prev_val = this._data.get(offset);
        this._data.put(offset, val);
        return prev_val;
    }

    @Override
    public char replace(int offset, char val) {
        return this.set(offset, val);
    }

    @Override
    public void set(int offset, char[] values) {
        this.set(offset, values, 0, values.length);
    }

    @Override
    public void set(int offset, char[] values, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data.fromArray(values, valOffset, offset, length);
    }

    public void setQuick(int offset, char val) {
        this._data.put(offset, val);
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data.resize(capacity);
        this._data.clear();
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
    }

    @Override
    public boolean remove(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char removeAt(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TCharIterator iterator() {
        return new TCharOffheapArrayIterator(0);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(TCharCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(char[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Character> collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        for (Character c : collection) {
            char e = c.charValue();
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TCharCollection collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        TCharIterator iter = collection.iterator();
        while (iter.hasNext()) {
            char element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(char[] array) {
        boolean changed = false;
        this.ensureCapacity(this._pos + array.length);
        for (char element : array) {
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(TCharCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(char[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(TCharCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(char[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transformValues(TCharFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data.put(i, function.execute(this._data.get(i)));
        }
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reverse(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shuffle(Random rand) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TCharList subList(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("end index " + end + " greater than begin index " + begin);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this.capacity()) {
            throw new IndexOutOfBoundsException("end index < " + this.capacity());
        }
        TCharArrayList list = new TCharArrayList(end - begin);
        this._data.toArray(begin, list._data, 0, end - begin);
        list._pos = end - begin;
        return list;
    }

    @Override
    public char[] toArray() {
        return this.toArray(0, this._pos);
    }

    @Override
    public char[] toArray(int offset, int len) {
        char[] rv = new char[len];
        this.toArray(rv, offset, len);
        return rv;
    }

    @Override
    public char[] toArray(char[] dest) {
        int len = dest.length;
        if (dest.length > this._pos) {
            len = this._pos;
            dest[len] = this.no_entry_value;
        }
        this.toArray(dest, 0, len);
        return dest;
    }

    @Override
    public char[] toArray(char[] dest, int offset, int len) {
        return this.toArray(dest, offset, 0, len);
    }

    @Override
    public char[] toArray(char[] dest, int source_pos, int dest_pos, int len) {
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        this._data.toArray(source_pos, dest, dest_pos, len);
        return dest;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TCharOffheapArrayList) {
            TCharOffheapArrayList that = (TCharOffheapArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data.get(i) == that._data.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data.get(i));
        }
        return h;
    }

    @Override
    public boolean forEach(TCharProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TCharProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(char val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(int fromIndex, int toIndex, char val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int binarySearch(char value) {
        return this.binarySearch(value, 0, this._pos);
    }

    @Override
    public int binarySearch(char value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char midVal = this._data.get(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(char value) {
        return this.indexOf(0, value);
    }

    @Override
    public int indexOf(int offset, char value) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char value) {
        return this.lastIndexOf(this._pos, value);
    }

    @Override
    public int lastIndexOf(int offset, char value) {
        int i = offset;
        while (i-- > 0) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(char value) {
        return this.lastIndexOf(value) >= 0;
    }

    @Override
    public TCharList grep(TCharProcedure condition) {
        TCharArrayList list = new TCharArrayList();
        for (int i = 0; i < this._pos; ++i) {
            char val = this._data.get(i);
            if (!condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public TCharList inverseGrep(TCharProcedure condition) {
        TCharArrayList list = new TCharArrayList();
        for (int i = 0; i < this._pos; ++i) {
            char val = this._data.get(i);
            if (condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public char max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        char max = '\u0000';
        for (int i = 0; i < this._pos; ++i) {
            char val = this._data.get(i);
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    @Override
    public char min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        char min = '\uffff';
        for (int i = 0; i < this._pos; ++i) {
            char val = this._data.get(i);
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    @Override
    public char sum() {
        char sum = '\u0000';
        for (int i = 0; i < this._pos; ++i) {
            sum = (char)(sum + this._data.get(i));
        }
        return sum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        int end = this._pos - 1;
        for (int i = 0; i < end; ++i) {
            buf.append(this._data.get(i));
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data.get(this._pos - 1));
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        out.writeChar(this.no_entry_value);
        int len = this.capacity();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeChar(this._data.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        this.no_entry_value = in.readChar();
        int len = in.readInt();
        this._data = new TCharOffheapArray(len);
        for (int i = 0; i < len; ++i) {
            this._data.put(i, in.readChar());
        }
    }

    class TCharOffheapArrayIterator
    implements TCharIterator {
        private int cursor = 0;
        int lastRet = -1;

        TCharOffheapArrayIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < TCharOffheapArrayList.this.size();
        }

        @Override
        public char next() {
            try {
                char next = TCharOffheapArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

