/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.array;

import gnu.trove.TFloatCollection;
import gnu.trove.array.TFloatOffheapArray;
import gnu.trove.function.TFloatFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TFloatIterator;
import gnu.trove.list.TFloatList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.procedure.TFloatProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Random;

public class TFloatOffheapArrayList
implements TFloatList,
Externalizable {
    static final long serialVersionUID = 1L;
    protected TFloatOffheapArray _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected float no_entry_value;

    public TFloatOffheapArrayList() {
        this(10, 0.0f);
    }

    public TFloatOffheapArrayList(int capacity) {
        this(capacity, 0.0f);
    }

    public TFloatOffheapArrayList(int capacity, float no_entry_value) {
        this._data = new TFloatOffheapArray(capacity);
        this._pos = 0;
        this.no_entry_value = no_entry_value;
    }

    @Override
    public float getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int capacity) {
        int oldCapacity = this.capacity();
        if (capacity > oldCapacity) {
            int newCap = Math.max(oldCapacity << 1, capacity);
            this._data.resize(newCap);
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    protected int capacity() {
        return (int)this._data.capacity();
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this.capacity() > this.size()) {
            this._data.resize(this.size());
        }
    }

    @Override
    public boolean add(float val) {
        this.ensureCapacity(this._pos + 1);
        this._data.put(this._pos++, val);
        return true;
    }

    @Override
    public void add(float[] vals) {
        this.add(vals, 0, vals.length);
    }

    @Override
    public void add(float[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        this._data.fromArray(vals, offset, this._pos, length);
        this._pos += length;
    }

    @Override
    public void insert(int offset, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, float[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, float[] values, int valOffset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data.get(offset);
    }

    public float getQuick(int offset) {
        return this._data.get(offset);
    }

    @Override
    public float set(int offset, float val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        float prev_val = this._data.get(offset);
        this._data.put(offset, val);
        return prev_val;
    }

    @Override
    public float replace(int offset, float val) {
        return this.set(offset, val);
    }

    @Override
    public void set(int offset, float[] values) {
        this.set(offset, values, 0, values.length);
    }

    @Override
    public void set(int offset, float[] values, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data.fromArray(values, valOffset, offset, length);
    }

    public void setQuick(int offset, float val) {
        this._data.put(offset, val);
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data.resize(capacity);
        this._data.clear();
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
    }

    @Override
    public boolean remove(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float removeAt(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TFloatIterator iterator() {
        return new TFloatOffheapArrayIterator(0);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(TFloatCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(float[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        for (Float f : collection) {
            float e = f.floatValue();
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TFloatCollection collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        TFloatIterator iter = collection.iterator();
        while (iter.hasNext()) {
            float element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(float[] array) {
        boolean changed = false;
        this.ensureCapacity(this._pos + array.length);
        for (float element : array) {
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(TFloatCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(float[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(TFloatCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(float[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transformValues(TFloatFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data.put(i, function.execute(this._data.get(i)));
        }
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reverse(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shuffle(Random rand) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TFloatList subList(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("end index " + end + " greater than begin index " + begin);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this.capacity()) {
            throw new IndexOutOfBoundsException("end index < " + this.capacity());
        }
        TFloatArrayList list = new TFloatArrayList(end - begin);
        this._data.toArray(begin, list._data, 0, end - begin);
        list._pos = end - begin;
        return list;
    }

    @Override
    public float[] toArray() {
        return this.toArray(0, this._pos);
    }

    @Override
    public float[] toArray(int offset, int len) {
        float[] rv = new float[len];
        this.toArray(rv, offset, len);
        return rv;
    }

    @Override
    public float[] toArray(float[] dest) {
        int len = dest.length;
        if (dest.length > this._pos) {
            len = this._pos;
            dest[len] = this.no_entry_value;
        }
        this.toArray(dest, 0, len);
        return dest;
    }

    @Override
    public float[] toArray(float[] dest, int offset, int len) {
        return this.toArray(dest, offset, 0, len);
    }

    @Override
    public float[] toArray(float[] dest, int source_pos, int dest_pos, int len) {
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        this._data.toArray(source_pos, dest, dest_pos, len);
        return dest;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TFloatOffheapArrayList) {
            TFloatOffheapArrayList that = (TFloatOffheapArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data.get(i) == that._data.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data.get(i));
        }
        return h;
    }

    @Override
    public boolean forEach(TFloatProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TFloatProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(float val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(int fromIndex, int toIndex, float val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int binarySearch(float value) {
        return this.binarySearch(value, 0, this._pos);
    }

    @Override
    public int binarySearch(float value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            float midVal = this._data.get(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(float value) {
        return this.indexOf(0, value);
    }

    @Override
    public int indexOf(int offset, float value) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float value) {
        return this.lastIndexOf(this._pos, value);
    }

    @Override
    public int lastIndexOf(int offset, float value) {
        int i = offset;
        while (i-- > 0) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(float value) {
        return this.lastIndexOf(value) >= 0;
    }

    @Override
    public TFloatList grep(TFloatProcedure condition) {
        TFloatArrayList list = new TFloatArrayList();
        for (int i = 0; i < this._pos; ++i) {
            float val = this._data.get(i);
            if (!condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public TFloatList inverseGrep(TFloatProcedure condition) {
        TFloatArrayList list = new TFloatArrayList();
        for (int i = 0; i < this._pos; ++i) {
            float val = this._data.get(i);
            if (condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public float max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this._pos; ++i) {
            float val = this._data.get(i);
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    @Override
    public float min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this._pos; ++i) {
            float val = this._data.get(i);
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    @Override
    public float sum() {
        float sum = 0.0f;
        for (int i = 0; i < this._pos; ++i) {
            sum += this._data.get(i);
        }
        return sum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        int end = this._pos - 1;
        for (int i = 0; i < end; ++i) {
            buf.append(this._data.get(i));
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data.get(this._pos - 1));
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        out.writeFloat(this.no_entry_value);
        int len = this.capacity();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeFloat(this._data.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        this.no_entry_value = in.readFloat();
        int len = in.readInt();
        this._data = new TFloatOffheapArray(len);
        for (int i = 0; i < len; ++i) {
            this._data.put(i, in.readFloat());
        }
    }

    class TFloatOffheapArrayIterator
    implements TFloatIterator {
        private int cursor = 0;
        int lastRet = -1;

        TFloatOffheapArrayIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < TFloatOffheapArrayList.this.size();
        }

        @Override
        public float next() {
            try {
                float next = TFloatOffheapArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

