/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.array;

import gnu.trove.TLongCollection;
import gnu.trove.array.TLongOffheapArray;
import gnu.trove.function.TLongFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.procedure.TLongProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Random;

public class TLongOffheapArrayList
implements TLongList,
Externalizable {
    static final long serialVersionUID = 1L;
    protected TLongOffheapArray _data;
    protected int _pos;
    protected static final int DEFAULT_CAPACITY = 10;
    protected long no_entry_value;

    public TLongOffheapArrayList() {
        this(10, 0L);
    }

    public TLongOffheapArrayList(int capacity) {
        this(capacity, 0L);
    }

    public TLongOffheapArrayList(int capacity, long no_entry_value) {
        this._data = new TLongOffheapArray(capacity);
        this._pos = 0;
        this.no_entry_value = no_entry_value;
    }

    @Override
    public long getNoEntryValue() {
        return this.no_entry_value;
    }

    public void ensureCapacity(int capacity) {
        int oldCapacity = this.capacity();
        if (capacity > oldCapacity) {
            int newCap = Math.max(oldCapacity << 1, capacity);
            this._data.resize(newCap);
        }
    }

    @Override
    public int size() {
        return this._pos;
    }

    protected int capacity() {
        return (int)this._data.capacity();
    }

    @Override
    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this.capacity() > this.size()) {
            this._data.resize(this.size());
        }
    }

    @Override
    public boolean add(long val) {
        this.ensureCapacity(this._pos + 1);
        this._data.put(this._pos++, val);
        return true;
    }

    @Override
    public void add(long[] vals) {
        this.add(vals, 0, vals.length);
    }

    @Override
    public void add(long[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        this._data.fromArray(vals, offset, this._pos, length);
        this._pos += length;
    }

    @Override
    public void insert(int offset, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, long[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(int offset, long[] values, int valOffset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data.get(offset);
    }

    public long getQuick(int offset) {
        return this._data.get(offset);
    }

    @Override
    public long set(int offset, long val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        long prev_val = this._data.get(offset);
        this._data.put(offset, val);
        return prev_val;
    }

    @Override
    public long replace(int offset, long val) {
        return this.set(offset, val);
    }

    @Override
    public void set(int offset, long[] values) {
        this.set(offset, values, 0, values.length);
    }

    @Override
    public void set(int offset, long[] values, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data.fromArray(values, valOffset, offset, length);
    }

    public void setQuick(int offset, long val) {
        this._data.put(offset, val);
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data.resize(capacity);
        this._data.clear();
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
    }

    @Override
    public boolean remove(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long removeAt(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TLongIterator iterator() {
        return new TLongOffheapArrayIterator(0);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(TLongCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(long[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        for (Long l : collection) {
            long e = l;
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TLongCollection collection) {
        boolean changed = false;
        this.ensureCapacity(this._pos + collection.size());
        TLongIterator iter = collection.iterator();
        while (iter.hasNext()) {
            long element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(long[] array) {
        boolean changed = false;
        this.ensureCapacity(this._pos + array.length);
        for (long element : array) {
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(TLongCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(long[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(TLongCollection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(long[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transformValues(TLongFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data.put(i, function.execute(this._data.get(i)));
        }
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reverse(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shuffle(Random rand) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TLongList subList(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("end index " + end + " greater than begin index " + begin);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this.capacity()) {
            throw new IndexOutOfBoundsException("end index < " + this.capacity());
        }
        TLongArrayList list = new TLongArrayList(end - begin);
        this._data.toArray(begin, list._data, 0, end - begin);
        list._pos = end - begin;
        return list;
    }

    @Override
    public long[] toArray() {
        return this.toArray(0, this._pos);
    }

    @Override
    public long[] toArray(int offset, int len) {
        long[] rv = new long[len];
        this.toArray(rv, offset, len);
        return rv;
    }

    @Override
    public long[] toArray(long[] dest) {
        int len = dest.length;
        if (dest.length > this._pos) {
            len = this._pos;
            dest[len] = this.no_entry_value;
        }
        this.toArray(dest, 0, len);
        return dest;
    }

    @Override
    public long[] toArray(long[] dest, int offset, int len) {
        return this.toArray(dest, offset, 0, len);
    }

    @Override
    public long[] toArray(long[] dest, int source_pos, int dest_pos, int len) {
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        this._data.toArray(source_pos, dest, dest_pos, len);
        return dest;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TLongOffheapArrayList) {
            TLongOffheapArrayList that = (TLongOffheapArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data.get(i) == that._data.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data.get(i));
        }
        return h;
    }

    @Override
    public boolean forEach(TLongProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TLongProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(long val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int binarySearch(long value) {
        return this.binarySearch(value, 0, this._pos);
    }

    @Override
    public int binarySearch(long value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this._data.get(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(long value) {
        return this.indexOf(0, value);
    }

    @Override
    public int indexOf(int offset, long value) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long value) {
        return this.lastIndexOf(this._pos, value);
    }

    @Override
    public int lastIndexOf(int offset, long value) {
        int i = offset;
        while (i-- > 0) {
            if (this._data.get(i) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(long value) {
        return this.lastIndexOf(value) >= 0;
    }

    @Override
    public TLongList grep(TLongProcedure condition) {
        TLongArrayList list = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            long val = this._data.get(i);
            if (!condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public TLongList inverseGrep(TLongProcedure condition) {
        TLongArrayList list = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            long val = this._data.get(i);
            if (condition.execute(val)) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public long max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            long val = this._data.get(i);
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    @Override
    public long min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this._pos; ++i) {
            long val = this._data.get(i);
            if (val >= min) continue;
            min = val;
        }
        return min;
    }

    @Override
    public long sum() {
        long sum = 0L;
        for (int i = 0; i < this._pos; ++i) {
            sum += this._data.get(i);
        }
        return sum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        int end = this._pos - 1;
        for (int i = 0; i < end; ++i) {
            buf.append(this._data.get(i));
            buf.append(", ");
        }
        if (this.size() > 0) {
            buf.append(this._data.get(this._pos - 1));
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._pos);
        out.writeLong(this.no_entry_value);
        int len = this.capacity();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeLong(this._data.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._pos = in.readInt();
        this.no_entry_value = in.readLong();
        int len = in.readInt();
        this._data = new TLongOffheapArray(len);
        for (int i = 0; i < len; ++i) {
            this._data.put(i, in.readLong());
        }
    }

    class TLongOffheapArrayIterator
    implements TLongIterator {
        private int cursor = 0;
        int lastRet = -1;

        TLongOffheapArrayIterator(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < TLongOffheapArrayList.this.size();
        }

        @Override
        public long next() {
            try {
                long next = TLongOffheapArrayList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

