/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TByteCollection;
import gnu.trove.TIntCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TIntOffheapArray;
import gnu.trove.function.TByteFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveOffheapIterator;
import gnu.trove.impl.hash.TIntByteOffheapHash;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.iterator.TIntByteIterator;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntByteMap;
import gnu.trove.procedure.TByteProcedure;
import gnu.trove.procedure.TIntByteProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

public class TIntByteOffheapHashMap
extends TIntByteOffheapHash
implements TIntByteMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient TByteOffheapArray _values = new TByteOffheapArray(this.capacity());

    public TIntByteOffheapHashMap() {
        this(10, 0.5f);
    }

    public TIntByteOffheapHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public TIntByteOffheapHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        TIntOffheapArray oldKeys = this._set;
        TByteOffheapArray oldVals = this._values;
        TByteOffheapArray oldStates = this._states;
        this._set = new TIntOffheapArray(newCapacity);
        this._values = new TByteOffheapArray(newCapacity);
        this._states = new TByteOffheapArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates.get(i) != 1) continue;
            int o = oldKeys.get(i);
            int index = this.insertKey(o);
            this._values.put(index, oldVals.get(i));
        }
        oldKeys.free();
        oldVals.free();
        oldStates.free();
    }

    @Override
    public byte put(int key, byte value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    @Override
    public byte putIfAbsent(int key, byte value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values.get(-index - 1);
        }
        return this.doPut(key, value, index);
    }

    private byte doPut(int key, byte value, int index) {
        byte previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values.get(index);
            isNewMapping = false;
        }
        this._values.put(index, value);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Byte> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Integer, ? extends Byte> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TIntByteMap map) {
        this.ensureCapacity(map.size());
        TIntByteIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    @Override
    public byte get(int key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values.get(index);
    }

    @Override
    public void clear() {
        super.clear();
        this._set.clear();
        this._values.clear();
        this._states.clear();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public byte remove(int key) {
        byte prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values.get(index);
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this._values.put(index, this.no_entry_value);
        super.removeAt(index);
    }

    @Override
    public TIntSet keySet() {
        return new TKeyView();
    }

    @Override
    public int[] keys() {
        int[] keys = new int[this.size()];
        TIntOffheapArray k = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            keys[j++] = k.get(i);
        }
        return keys;
    }

    @Override
    public int[] keys(int[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new int[size];
        }
        TIntOffheapArray keys = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = keys.get(i);
        }
        return array;
    }

    @Override
    public TByteCollection valueCollection() {
        return new TValueView();
    }

    @Override
    public byte[] values() {
        byte[] vals = new byte[this.size()];
        TByteOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            vals[j++] = v.get(i);
        }
        return vals;
    }

    @Override
    public byte[] values(byte[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new byte[size];
        }
        TByteOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = v.get(i);
        }
        return array;
    }

    @Override
    public boolean containsValue(byte val) {
        TByteOffheapArray states = this._states;
        TByteOffheapArray vals = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || val != vals.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        return this.contains(key);
    }

    @Override
    public TIntByteIterator iterator() {
        return new TIntByteOffheapHashIterator(this);
    }

    @Override
    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TByteProcedure procedure) {
        TByteOffheapArray states = this._states;
        TByteOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TIntByteProcedure procedure) {
        TByteOffheapArray states = this._states;
        TIntOffheapArray keys = this._set;
        TByteOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TByteFunction function) {
        TByteOffheapArray states = this._states;
        TByteOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            values.put(i, function.execute(values.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TIntByteProcedure procedure) {
        boolean modified = false;
        TByteOffheapArray states = this._states;
        TIntOffheapArray keys = this._set;
        TByteOffheapArray values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public boolean increment(int key) {
        return this.adjustValue(key, (byte)1);
    }

    @Override
    public boolean adjustValue(int key, byte amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        byte val = this._values.get(index);
        this._values.put(index, (byte)(val + amount));
        return true;
    }

    @Override
    public byte adjustOrPutValue(int key, byte adjust_amount, byte put_amount) {
        boolean isNewMapping;
        byte newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            index = -index - 1;
            newValue = (byte)(this._values.get(index) + adjust_amount);
            isNewMapping = false;
        } else {
            newValue = put_amount;
            isNewMapping = true;
        }
        this._values.put(index, newValue);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntByteMap)) {
            return false;
        }
        TIntByteMap that = (TIntByteMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        TByteOffheapArray values = this._values;
        TByteOffheapArray states = this._states;
        byte this_no_entry_value = this.getNoEntryValue();
        byte that_no_entry_value = that.getNoEntryValue();
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            int key = this._set.get(i);
            byte that_value = that.get(key);
            byte this_value = values.get(i);
            if (this_value == that_value || this_value == this_no_entry_value || that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            hashcode += HashFunctions.hash(this._set.get(i)) ^ HashFunctions.hash(this._values.get(i));
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TIntByteProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(int key, byte value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            out.writeInt(this._set.get(i));
            out.writeByte(this._values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            int key = in.readInt();
            byte val = in.readByte();
            this.put(key, val);
        }
    }

    class TIntByteOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TIntByteIterator {
        TIntByteOffheapHashIterator(TIntByteOffheapHashMap map) {
            super(map);
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public int key() {
            return TIntByteOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public byte value() {
            return TIntByteOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public byte setValue(byte val) {
            byte old = this.value();
            TIntByteOffheapHashMap.this._values.put(this._index, val);
            return old;
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TIntByteOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TIntByteValueOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TByteIterator {
        TIntByteValueOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public byte next() {
            this.moveToNextIndex();
            return TIntByteOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TIntByteOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TIntByteKeyOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TIntIterator {
        TIntByteKeyOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public int next() {
            this.moveToNextIndex();
            return TIntByteOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TIntByteOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    protected class TValueView
    implements TByteCollection {
        protected TValueView() {
        }

        @Override
        public TByteIterator iterator() {
            return new TIntByteValueOffheapHashIterator(TIntByteOffheapHashMap.this);
        }

        @Override
        public byte getNoEntryValue() {
            return TIntByteOffheapHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TIntByteOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TIntByteOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(byte entry) {
            return TIntByteOffheapHashMap.this.containsValue(entry);
        }

        @Override
        public byte[] toArray() {
            return TIntByteOffheapHashMap.this.values();
        }

        @Override
        public byte[] toArray(byte[] dest) {
            return TIntByteOffheapHashMap.this.values(dest);
        }

        @Override
        public boolean add(byte entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(byte entry) {
            TByteOffheapArray values = TIntByteOffheapHashMap.this._values;
            TByteOffheapArray states = TIntByteOffheapHashMap.this._states;
            int i = TIntByteOffheapHashMap.this.capacity();
            while (i-- > 0) {
                byte state = states.get(i);
                if (state == 0 || state == 2 || entry != values.get(i)) continue;
                TIntByteOffheapHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Byte) {
                    byte ele = (Byte)element;
                    if (TIntByteOffheapHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TByteCollection collection) {
            TByteIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TIntByteOffheapHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(byte[] array) {
            for (byte element : array) {
                if (TIntByteOffheapHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Byte> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TByteCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(byte[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TByteIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TByteCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TByteIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(byte[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TByteOffheapArray values = TIntByteOffheapHashMap.this._values;
            TByteOffheapArray states = TIntByteOffheapHashMap.this._states;
            int i = TIntByteOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, values.get(i)) >= 0) continue;
                TIntByteOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                byte c;
                if (!(element instanceof Byte) || !this.remove(c = ((Byte)element).byteValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TByteCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TByteIterator iter = collection.iterator();
            while (iter.hasNext()) {
                byte element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(byte[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TIntByteOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TByteProcedure procedure) {
            return TIntByteOffheapHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TIntByteOffheapHashMap.this.forEachValue(new TByteProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(byte value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    protected class TKeyView
    implements TIntSet {
        protected TKeyView() {
        }

        @Override
        public TIntIterator iterator() {
            return new TIntByteKeyOffheapHashIterator(TIntByteOffheapHashMap.this);
        }

        @Override
        public int getNoEntryValue() {
            return TIntByteOffheapHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TIntByteOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TIntByteOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(int entry) {
            return TIntByteOffheapHashMap.this.contains(entry);
        }

        @Override
        public int[] toArray() {
            return TIntByteOffheapHashMap.this.keys();
        }

        @Override
        public int[] toArray(int[] dest) {
            return TIntByteOffheapHashMap.this.keys(dest);
        }

        @Override
        public boolean add(int entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(int entry) {
            return TIntByteOffheapHashMap.this.no_entry_value != TIntByteOffheapHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Integer) {
                    int ele = (Integer)element;
                    if (TIntByteOffheapHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection collection) {
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TIntByteOffheapHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] array) {
            for (int element : array) {
                if (TIntByteOffheapHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TIntCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(int[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TIntOffheapArray set = TIntByteOffheapHashMap.this._set;
            TByteOffheapArray states = TIntByteOffheapHashMap.this._states;
            int i = TIntByteOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, set.get(i)) >= 0) continue;
                TIntByteOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                int c;
                if (!(element instanceof Integer) || !this.remove(c = ((Integer)element).intValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TIntCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                int element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(int[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TIntByteOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TIntProcedure procedure) {
            return TIntByteOffheapHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TIntSet)) {
                return false;
            }
            TIntSet that = (TIntSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TIntByteOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TIntByteOffheapHashMap.this._states.get(i) != 1 || that.contains(TIntByteOffheapHashMap.this._set.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i = TIntByteOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TIntByteOffheapHashMap.this._states.get(i) != 1) continue;
                hashcode += HashFunctions.hash(TIntByteOffheapHashMap.this._set.get(i));
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TIntByteOffheapHashMap.this.forEachKey(new TIntProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(int key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

