/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TDoubleCollection;
import gnu.trove.TIntCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TDoubleOffheapArray;
import gnu.trove.array.TIntOffheapArray;
import gnu.trove.function.TDoubleFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveOffheapIterator;
import gnu.trove.impl.hash.TIntDoubleOffheapHash;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntDoubleMap;
import gnu.trove.procedure.TDoubleProcedure;
import gnu.trove.procedure.TIntDoubleProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

public class TIntDoubleOffheapHashMap
extends TIntDoubleOffheapHash
implements TIntDoubleMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient TDoubleOffheapArray _values = new TDoubleOffheapArray(this.capacity());

    public TIntDoubleOffheapHashMap() {
        this(10, 0.5f);
    }

    public TIntDoubleOffheapHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public TIntDoubleOffheapHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        TIntOffheapArray oldKeys = this._set;
        TDoubleOffheapArray oldVals = this._values;
        TByteOffheapArray oldStates = this._states;
        this._set = new TIntOffheapArray(newCapacity);
        this._values = new TDoubleOffheapArray(newCapacity);
        this._states = new TByteOffheapArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates.get(i) != 1) continue;
            int o = oldKeys.get(i);
            int index = this.insertKey(o);
            this._values.put(index, oldVals.get(i));
        }
        oldKeys.free();
        oldVals.free();
        oldStates.free();
    }

    @Override
    public double put(int key, double value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    @Override
    public double putIfAbsent(int key, double value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values.get(-index - 1);
        }
        return this.doPut(key, value, index);
    }

    private double doPut(int key, double value, int index) {
        double previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values.get(index);
            isNewMapping = false;
        }
        this._values.put(index, value);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Double> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Integer, ? extends Double> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TIntDoubleMap map) {
        this.ensureCapacity(map.size());
        TIntDoubleIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    @Override
    public double get(int key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values.get(index);
    }

    @Override
    public void clear() {
        super.clear();
        this._set.clear();
        this._values.clear();
        this._states.clear();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public double remove(int key) {
        double prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values.get(index);
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this._values.put(index, this.no_entry_value);
        super.removeAt(index);
    }

    @Override
    public TIntSet keySet() {
        return new TKeyView();
    }

    @Override
    public int[] keys() {
        int[] keys = new int[this.size()];
        TIntOffheapArray k = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            keys[j++] = k.get(i);
        }
        return keys;
    }

    @Override
    public int[] keys(int[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new int[size];
        }
        TIntOffheapArray keys = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = keys.get(i);
        }
        return array;
    }

    @Override
    public TDoubleCollection valueCollection() {
        return new TValueView();
    }

    @Override
    public double[] values() {
        double[] vals = new double[this.size()];
        TDoubleOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            vals[j++] = v.get(i);
        }
        return vals;
    }

    @Override
    public double[] values(double[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new double[size];
        }
        TDoubleOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = v.get(i);
        }
        return array;
    }

    @Override
    public boolean containsValue(double val) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray vals = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || val != vals.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(int key) {
        return this.contains(key);
    }

    @Override
    public TIntDoubleIterator iterator() {
        return new TIntDoubleOffheapHashIterator(this);
    }

    @Override
    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TDoubleProcedure procedure) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TIntDoubleProcedure procedure) {
        TByteOffheapArray states = this._states;
        TIntOffheapArray keys = this._set;
        TDoubleOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TDoubleFunction function) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            values.put(i, function.execute(values.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TIntDoubleProcedure procedure) {
        boolean modified = false;
        TByteOffheapArray states = this._states;
        TIntOffheapArray keys = this._set;
        TDoubleOffheapArray values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public boolean increment(int key) {
        return this.adjustValue(key, 1.0);
    }

    @Override
    public boolean adjustValue(int key, double amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        double val = this._values.get(index);
        this._values.put(index, val + amount);
        return true;
    }

    @Override
    public double adjustOrPutValue(int key, double adjust_amount, double put_amount) {
        boolean isNewMapping;
        double newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            index = -index - 1;
            newValue = this._values.get(index) + adjust_amount;
            isNewMapping = false;
        } else {
            newValue = put_amount;
            isNewMapping = true;
        }
        this._values.put(index, newValue);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntDoubleMap)) {
            return false;
        }
        TIntDoubleMap that = (TIntDoubleMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        TDoubleOffheapArray values = this._values;
        TByteOffheapArray states = this._states;
        double this_no_entry_value = this.getNoEntryValue();
        double that_no_entry_value = that.getNoEntryValue();
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            int key = this._set.get(i);
            double that_value = that.get(key);
            double this_value = values.get(i);
            if (this_value == that_value || this_value == this_no_entry_value || that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            hashcode += HashFunctions.hash(this._set.get(i)) ^ HashFunctions.hash(this._values.get(i));
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TIntDoubleProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(int key, double value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            out.writeInt(this._set.get(i));
            out.writeDouble(this._values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            int key = in.readInt();
            double val = in.readDouble();
            this.put(key, val);
        }
    }

    class TIntDoubleOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TIntDoubleIterator {
        TIntDoubleOffheapHashIterator(TIntDoubleOffheapHashMap map) {
            super(map);
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public int key() {
            return TIntDoubleOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public double value() {
            return TIntDoubleOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public double setValue(double val) {
            double old = this.value();
            TIntDoubleOffheapHashMap.this._values.put(this._index, val);
            return old;
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TIntDoubleOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TIntDoubleValueOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TDoubleIterator {
        TIntDoubleValueOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public double next() {
            this.moveToNextIndex();
            return TIntDoubleOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TIntDoubleOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TIntDoubleKeyOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TIntIterator {
        TIntDoubleKeyOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public int next() {
            this.moveToNextIndex();
            return TIntDoubleOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TIntDoubleOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    protected class TValueView
    implements TDoubleCollection {
        protected TValueView() {
        }

        @Override
        public TDoubleIterator iterator() {
            return new TIntDoubleValueOffheapHashIterator(TIntDoubleOffheapHashMap.this);
        }

        @Override
        public double getNoEntryValue() {
            return TIntDoubleOffheapHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TIntDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TIntDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(double entry) {
            return TIntDoubleOffheapHashMap.this.containsValue(entry);
        }

        @Override
        public double[] toArray() {
            return TIntDoubleOffheapHashMap.this.values();
        }

        @Override
        public double[] toArray(double[] dest) {
            return TIntDoubleOffheapHashMap.this.values(dest);
        }

        @Override
        public boolean add(double entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(double entry) {
            TDoubleOffheapArray values = TIntDoubleOffheapHashMap.this._values;
            TByteOffheapArray states = TIntDoubleOffheapHashMap.this._states;
            int i = TIntDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                byte state = states.get(i);
                if (state == 0 || state == 2 || entry != values.get(i)) continue;
                TIntDoubleOffheapHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Double) {
                    double ele = (Double)element;
                    if (TIntDoubleOffheapHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TDoubleCollection collection) {
            TDoubleIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TIntDoubleOffheapHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(double[] array) {
            for (double element : array) {
                if (TIntDoubleOffheapHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Double> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TDoubleCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(double[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TDoubleIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TDoubleCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TDoubleIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(double[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TDoubleOffheapArray values = TIntDoubleOffheapHashMap.this._values;
            TByteOffheapArray states = TIntDoubleOffheapHashMap.this._states;
            int i = TIntDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, values.get(i)) >= 0) continue;
                TIntDoubleOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                double c;
                if (!(element instanceof Double) || !this.remove(c = ((Double)element).doubleValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TDoubleCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TDoubleIterator iter = collection.iterator();
            while (iter.hasNext()) {
                double element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(double[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TIntDoubleOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TDoubleProcedure procedure) {
            return TIntDoubleOffheapHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TIntDoubleOffheapHashMap.this.forEachValue(new TDoubleProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(double value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    protected class TKeyView
    implements TIntSet {
        protected TKeyView() {
        }

        @Override
        public TIntIterator iterator() {
            return new TIntDoubleKeyOffheapHashIterator(TIntDoubleOffheapHashMap.this);
        }

        @Override
        public int getNoEntryValue() {
            return TIntDoubleOffheapHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TIntDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TIntDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(int entry) {
            return TIntDoubleOffheapHashMap.this.contains(entry);
        }

        @Override
        public int[] toArray() {
            return TIntDoubleOffheapHashMap.this.keys();
        }

        @Override
        public int[] toArray(int[] dest) {
            return TIntDoubleOffheapHashMap.this.keys(dest);
        }

        @Override
        public boolean add(int entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(int entry) {
            return TIntDoubleOffheapHashMap.this.no_entry_value != TIntDoubleOffheapHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Integer) {
                    int ele = (Integer)element;
                    if (TIntDoubleOffheapHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TIntCollection collection) {
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TIntDoubleOffheapHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(int[] array) {
            for (int element : array) {
                if (TIntDoubleOffheapHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TIntCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TIntCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TIntIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(int[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TIntOffheapArray set = TIntDoubleOffheapHashMap.this._set;
            TByteOffheapArray states = TIntDoubleOffheapHashMap.this._states;
            int i = TIntDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, set.get(i)) >= 0) continue;
                TIntDoubleOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                int c;
                if (!(element instanceof Integer) || !this.remove(c = ((Integer)element).intValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TIntCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TIntIterator iter = collection.iterator();
            while (iter.hasNext()) {
                int element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(int[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TIntDoubleOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TIntProcedure procedure) {
            return TIntDoubleOffheapHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TIntSet)) {
                return false;
            }
            TIntSet that = (TIntSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TIntDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TIntDoubleOffheapHashMap.this._states.get(i) != 1 || that.contains(TIntDoubleOffheapHashMap.this._set.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i = TIntDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TIntDoubleOffheapHashMap.this._states.get(i) != 1) continue;
                hashcode += HashFunctions.hash(TIntDoubleOffheapHashMap.this._set.get(i));
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TIntDoubleOffheapHashMap.this.forEachKey(new TIntProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(int key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

