/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TDoubleCollection;
import gnu.trove.TLongCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TDoubleOffheapArray;
import gnu.trove.array.TLongOffheapArray;
import gnu.trove.function.TDoubleFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveOffheapIterator;
import gnu.trove.impl.hash.TLongDoubleOffheapHash;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.iterator.TLongDoubleIterator;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongDoubleMap;
import gnu.trove.procedure.TDoubleProcedure;
import gnu.trove.procedure.TLongDoubleProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.TLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

public class TLongDoubleOffheapHashMap
extends TLongDoubleOffheapHash
implements TLongDoubleMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient TDoubleOffheapArray _values = new TDoubleOffheapArray(this.capacity());

    public TLongDoubleOffheapHashMap() {
        this(10, 0.5f);
    }

    public TLongDoubleOffheapHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public TLongDoubleOffheapHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        TLongOffheapArray oldKeys = this._set;
        TDoubleOffheapArray oldVals = this._values;
        TByteOffheapArray oldStates = this._states;
        this._set = new TLongOffheapArray(newCapacity);
        this._values = new TDoubleOffheapArray(newCapacity);
        this._states = new TByteOffheapArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates.get(i) != 1) continue;
            long o = oldKeys.get(i);
            int index = this.insertKey(o);
            this._values.put(index, oldVals.get(i));
        }
        oldKeys.free();
        oldVals.free();
        oldStates.free();
    }

    @Override
    public double put(long key, double value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    @Override
    public double putIfAbsent(long key, double value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values.get(-index - 1);
        }
        return this.doPut(key, value, index);
    }

    private double doPut(long key, double value, int index) {
        double previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values.get(index);
            isNewMapping = false;
        }
        this._values.put(index, value);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Double> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Long, ? extends Double> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TLongDoubleMap map) {
        this.ensureCapacity(map.size());
        TLongDoubleIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    @Override
    public double get(long key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values.get(index);
    }

    @Override
    public void clear() {
        super.clear();
        this._set.clear();
        this._values.clear();
        this._states.clear();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public double remove(long key) {
        double prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values.get(index);
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this._values.put(index, this.no_entry_value);
        super.removeAt(index);
    }

    @Override
    public TLongSet keySet() {
        return new TKeyView();
    }

    @Override
    public long[] keys() {
        long[] keys = new long[this.size()];
        TLongOffheapArray k = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            keys[j++] = k.get(i);
        }
        return keys;
    }

    @Override
    public long[] keys(long[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new long[size];
        }
        TLongOffheapArray keys = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = keys.get(i);
        }
        return array;
    }

    @Override
    public TDoubleCollection valueCollection() {
        return new TValueView();
    }

    @Override
    public double[] values() {
        double[] vals = new double[this.size()];
        TDoubleOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            vals[j++] = v.get(i);
        }
        return vals;
    }

    @Override
    public double[] values(double[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new double[size];
        }
        TDoubleOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = v.get(i);
        }
        return array;
    }

    @Override
    public boolean containsValue(double val) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray vals = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || val != vals.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(long key) {
        return this.contains(key);
    }

    @Override
    public TLongDoubleIterator iterator() {
        return new TLongDoubleOffheapHashIterator(this);
    }

    @Override
    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TDoubleProcedure procedure) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TLongDoubleProcedure procedure) {
        TByteOffheapArray states = this._states;
        TLongOffheapArray keys = this._set;
        TDoubleOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TDoubleFunction function) {
        TByteOffheapArray states = this._states;
        TDoubleOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            values.put(i, function.execute(values.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TLongDoubleProcedure procedure) {
        boolean modified = false;
        TByteOffheapArray states = this._states;
        TLongOffheapArray keys = this._set;
        TDoubleOffheapArray values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public boolean increment(long key) {
        return this.adjustValue(key, 1.0);
    }

    @Override
    public boolean adjustValue(long key, double amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        double val = this._values.get(index);
        this._values.put(index, val + amount);
        return true;
    }

    @Override
    public double adjustOrPutValue(long key, double adjust_amount, double put_amount) {
        boolean isNewMapping;
        double newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            index = -index - 1;
            newValue = this._values.get(index) + adjust_amount;
            isNewMapping = false;
        } else {
            newValue = put_amount;
            isNewMapping = true;
        }
        this._values.put(index, newValue);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongDoubleMap)) {
            return false;
        }
        TLongDoubleMap that = (TLongDoubleMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        TDoubleOffheapArray values = this._values;
        TByteOffheapArray states = this._states;
        double this_no_entry_value = this.getNoEntryValue();
        double that_no_entry_value = that.getNoEntryValue();
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            long key = this._set.get(i);
            double that_value = that.get(key);
            double this_value = values.get(i);
            if (this_value == that_value || this_value == this_no_entry_value || that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            hashcode += HashFunctions.hash(this._set.get(i)) ^ HashFunctions.hash(this._values.get(i));
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TLongDoubleProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(long key, double value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            out.writeLong(this._set.get(i));
            out.writeDouble(this._values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = in.readLong();
            double val = in.readDouble();
            this.put(key, val);
        }
    }

    class TLongDoubleOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TLongDoubleIterator {
        TLongDoubleOffheapHashIterator(TLongDoubleOffheapHashMap map) {
            super(map);
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public long key() {
            return TLongDoubleOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public double value() {
            return TLongDoubleOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public double setValue(double val) {
            double old = this.value();
            TLongDoubleOffheapHashMap.this._values.put(this._index, val);
            return old;
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TLongDoubleOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TLongDoubleValueOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TDoubleIterator {
        TLongDoubleValueOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public double next() {
            this.moveToNextIndex();
            return TLongDoubleOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TLongDoubleOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TLongDoubleKeyOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TLongIterator {
        TLongDoubleKeyOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public long next() {
            this.moveToNextIndex();
            return TLongDoubleOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TLongDoubleOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    protected class TValueView
    implements TDoubleCollection {
        protected TValueView() {
        }

        @Override
        public TDoubleIterator iterator() {
            return new TLongDoubleValueOffheapHashIterator(TLongDoubleOffheapHashMap.this);
        }

        @Override
        public double getNoEntryValue() {
            return TLongDoubleOffheapHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TLongDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TLongDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(double entry) {
            return TLongDoubleOffheapHashMap.this.containsValue(entry);
        }

        @Override
        public double[] toArray() {
            return TLongDoubleOffheapHashMap.this.values();
        }

        @Override
        public double[] toArray(double[] dest) {
            return TLongDoubleOffheapHashMap.this.values(dest);
        }

        @Override
        public boolean add(double entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(double entry) {
            TDoubleOffheapArray values = TLongDoubleOffheapHashMap.this._values;
            TByteOffheapArray states = TLongDoubleOffheapHashMap.this._states;
            int i = TLongDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                byte state = states.get(i);
                if (state == 0 || state == 2 || entry != values.get(i)) continue;
                TLongDoubleOffheapHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Double) {
                    double ele = (Double)element;
                    if (TLongDoubleOffheapHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TDoubleCollection collection) {
            TDoubleIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TLongDoubleOffheapHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(double[] array) {
            for (double element : array) {
                if (TLongDoubleOffheapHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Double> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TDoubleCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(double[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TDoubleIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TDoubleCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TDoubleIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(double[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TDoubleOffheapArray values = TLongDoubleOffheapHashMap.this._values;
            TByteOffheapArray states = TLongDoubleOffheapHashMap.this._states;
            int i = TLongDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, values.get(i)) >= 0) continue;
                TLongDoubleOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                double c;
                if (!(element instanceof Double) || !this.remove(c = ((Double)element).doubleValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TDoubleCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TDoubleIterator iter = collection.iterator();
            while (iter.hasNext()) {
                double element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(double[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TLongDoubleOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TDoubleProcedure procedure) {
            return TLongDoubleOffheapHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TLongDoubleOffheapHashMap.this.forEachValue(new TDoubleProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(double value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    protected class TKeyView
    implements TLongSet {
        protected TKeyView() {
        }

        @Override
        public TLongIterator iterator() {
            return new TLongDoubleKeyOffheapHashIterator(TLongDoubleOffheapHashMap.this);
        }

        @Override
        public long getNoEntryValue() {
            return TLongDoubleOffheapHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TLongDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TLongDoubleOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(long entry) {
            return TLongDoubleOffheapHashMap.this.contains(entry);
        }

        @Override
        public long[] toArray() {
            return TLongDoubleOffheapHashMap.this.keys();
        }

        @Override
        public long[] toArray(long[] dest) {
            return TLongDoubleOffheapHashMap.this.keys(dest);
        }

        @Override
        public boolean add(long entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(long entry) {
            return TLongDoubleOffheapHashMap.this.no_entry_value != TLongDoubleOffheapHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Long) {
                    long ele = (Long)element;
                    if (TLongDoubleOffheapHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TLongCollection collection) {
            TLongIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TLongDoubleOffheapHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(long[] array) {
            for (long element : array) {
                if (TLongDoubleOffheapHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Long> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TLongCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TLongIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TLongCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TLongIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(long[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TLongOffheapArray set = TLongDoubleOffheapHashMap.this._set;
            TByteOffheapArray states = TLongDoubleOffheapHashMap.this._states;
            int i = TLongDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, set.get(i)) >= 0) continue;
                TLongDoubleOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                long c;
                if (!(element instanceof Long) || !this.remove(c = ((Long)element).longValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TLongCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TLongIterator iter = collection.iterator();
            while (iter.hasNext()) {
                long element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(long[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TLongDoubleOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TLongProcedure procedure) {
            return TLongDoubleOffheapHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TLongSet)) {
                return false;
            }
            TLongSet that = (TLongSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TLongDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TLongDoubleOffheapHashMap.this._states.get(i) != 1 || that.contains(TLongDoubleOffheapHashMap.this._set.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i = TLongDoubleOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TLongDoubleOffheapHashMap.this._states.get(i) != 1) continue;
                hashcode += HashFunctions.hash(TLongDoubleOffheapHashMap.this._set.get(i));
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TLongDoubleOffheapHashMap.this.forEachKey(new TLongProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(long key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

