/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TLongCollection;
import gnu.trove.TShortCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TLongOffheapArray;
import gnu.trove.array.TShortOffheapArray;
import gnu.trove.function.TShortFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveOffheapIterator;
import gnu.trove.impl.hash.TLongShortOffheapHash;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.iterator.TLongShortIterator;
import gnu.trove.iterator.TShortIterator;
import gnu.trove.map.TLongShortMap;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.procedure.TLongShortProcedure;
import gnu.trove.procedure.TShortProcedure;
import gnu.trove.set.TLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

public class TLongShortOffheapHashMap
extends TLongShortOffheapHash
implements TLongShortMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient TShortOffheapArray _values = new TShortOffheapArray(this.capacity());

    public TLongShortOffheapHashMap() {
        this(10, 0.5f);
    }

    public TLongShortOffheapHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public TLongShortOffheapHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        TLongOffheapArray oldKeys = this._set;
        TShortOffheapArray oldVals = this._values;
        TByteOffheapArray oldStates = this._states;
        this._set = new TLongOffheapArray(newCapacity);
        this._values = new TShortOffheapArray(newCapacity);
        this._states = new TByteOffheapArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates.get(i) != 1) continue;
            long o = oldKeys.get(i);
            int index = this.insertKey(o);
            this._values.put(index, oldVals.get(i));
        }
        oldKeys.free();
        oldVals.free();
        oldStates.free();
    }

    @Override
    public short put(long key, short value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    @Override
    public short putIfAbsent(long key, short value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values.get(-index - 1);
        }
        return this.doPut(key, value, index);
    }

    private short doPut(long key, short value, int index) {
        short previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values.get(index);
            isNewMapping = false;
        }
        this._values.put(index, value);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Short> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Long, ? extends Short> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TLongShortMap map) {
        this.ensureCapacity(map.size());
        TLongShortIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    @Override
    public short get(long key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values.get(index);
    }

    @Override
    public void clear() {
        super.clear();
        this._set.clear();
        this._values.clear();
        this._states.clear();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public short remove(long key) {
        short prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values.get(index);
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this._values.put(index, this.no_entry_value);
        super.removeAt(index);
    }

    @Override
    public TLongSet keySet() {
        return new TKeyView();
    }

    @Override
    public long[] keys() {
        long[] keys = new long[this.size()];
        TLongOffheapArray k = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            keys[j++] = k.get(i);
        }
        return keys;
    }

    @Override
    public long[] keys(long[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new long[size];
        }
        TLongOffheapArray keys = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = keys.get(i);
        }
        return array;
    }

    @Override
    public TShortCollection valueCollection() {
        return new TValueView();
    }

    @Override
    public short[] values() {
        short[] vals = new short[this.size()];
        TShortOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            vals[j++] = v.get(i);
        }
        return vals;
    }

    @Override
    public short[] values(short[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new short[size];
        }
        TShortOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = v.get(i);
        }
        return array;
    }

    @Override
    public boolean containsValue(short val) {
        TByteOffheapArray states = this._states;
        TShortOffheapArray vals = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || val != vals.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(long key) {
        return this.contains(key);
    }

    @Override
    public TLongShortIterator iterator() {
        return new TLongShortOffheapHashIterator(this);
    }

    @Override
    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TShortProcedure procedure) {
        TByteOffheapArray states = this._states;
        TShortOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TLongShortProcedure procedure) {
        TByteOffheapArray states = this._states;
        TLongOffheapArray keys = this._set;
        TShortOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TShortFunction function) {
        TByteOffheapArray states = this._states;
        TShortOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            values.put(i, function.execute(values.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TLongShortProcedure procedure) {
        boolean modified = false;
        TByteOffheapArray states = this._states;
        TLongOffheapArray keys = this._set;
        TShortOffheapArray values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public boolean increment(long key) {
        return this.adjustValue(key, (short)1);
    }

    @Override
    public boolean adjustValue(long key, short amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        short val = this._values.get(index);
        this._values.put(index, (short)(val + amount));
        return true;
    }

    @Override
    public short adjustOrPutValue(long key, short adjust_amount, short put_amount) {
        boolean isNewMapping;
        short newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            index = -index - 1;
            newValue = (short)(this._values.get(index) + adjust_amount);
            isNewMapping = false;
        } else {
            newValue = put_amount;
            isNewMapping = true;
        }
        this._values.put(index, newValue);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongShortMap)) {
            return false;
        }
        TLongShortMap that = (TLongShortMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        TShortOffheapArray values = this._values;
        TByteOffheapArray states = this._states;
        short this_no_entry_value = this.getNoEntryValue();
        short that_no_entry_value = that.getNoEntryValue();
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            long key = this._set.get(i);
            short that_value = that.get(key);
            short this_value = values.get(i);
            if (this_value == that_value || this_value == this_no_entry_value || that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            hashcode += HashFunctions.hash(this._set.get(i)) ^ HashFunctions.hash(this._values.get(i));
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TLongShortProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(long key, short value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            out.writeLong(this._set.get(i));
            out.writeShort(this._values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = in.readLong();
            short val = in.readShort();
            this.put(key, val);
        }
    }

    class TLongShortOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TLongShortIterator {
        TLongShortOffheapHashIterator(TLongShortOffheapHashMap map) {
            super(map);
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public long key() {
            return TLongShortOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public short value() {
            return TLongShortOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public short setValue(short val) {
            short old = this.value();
            TLongShortOffheapHashMap.this._values.put(this._index, val);
            return old;
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TLongShortOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TLongShortValueOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TShortIterator {
        TLongShortValueOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public short next() {
            this.moveToNextIndex();
            return TLongShortOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TLongShortOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TLongShortKeyOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TLongIterator {
        TLongShortKeyOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public long next() {
            this.moveToNextIndex();
            return TLongShortOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TLongShortOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    protected class TValueView
    implements TShortCollection {
        protected TValueView() {
        }

        @Override
        public TShortIterator iterator() {
            return new TLongShortValueOffheapHashIterator(TLongShortOffheapHashMap.this);
        }

        @Override
        public short getNoEntryValue() {
            return TLongShortOffheapHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TLongShortOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TLongShortOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(short entry) {
            return TLongShortOffheapHashMap.this.containsValue(entry);
        }

        @Override
        public short[] toArray() {
            return TLongShortOffheapHashMap.this.values();
        }

        @Override
        public short[] toArray(short[] dest) {
            return TLongShortOffheapHashMap.this.values(dest);
        }

        @Override
        public boolean add(short entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(short entry) {
            TShortOffheapArray values = TLongShortOffheapHashMap.this._values;
            TByteOffheapArray states = TLongShortOffheapHashMap.this._states;
            int i = TLongShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                byte state = states.get(i);
                if (state == 0 || state == 2 || entry != values.get(i)) continue;
                TLongShortOffheapHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Short) {
                    short ele = (Short)element;
                    if (TLongShortOffheapHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TShortCollection collection) {
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TLongShortOffheapHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(short[] array) {
            for (short element : array) {
                if (TLongShortOffheapHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Short> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TShortCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(short[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TShortCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(short[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TShortOffheapArray values = TLongShortOffheapHashMap.this._values;
            TByteOffheapArray states = TLongShortOffheapHashMap.this._states;
            int i = TLongShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, values.get(i)) >= 0) continue;
                TLongShortOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                short c;
                if (!(element instanceof Short) || !this.remove(c = ((Short)element).shortValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TShortCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                short element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(short[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TLongShortOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TShortProcedure procedure) {
            return TLongShortOffheapHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TLongShortOffheapHashMap.this.forEachValue(new TShortProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(short value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    protected class TKeyView
    implements TLongSet {
        protected TKeyView() {
        }

        @Override
        public TLongIterator iterator() {
            return new TLongShortKeyOffheapHashIterator(TLongShortOffheapHashMap.this);
        }

        @Override
        public long getNoEntryValue() {
            return TLongShortOffheapHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TLongShortOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TLongShortOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(long entry) {
            return TLongShortOffheapHashMap.this.contains(entry);
        }

        @Override
        public long[] toArray() {
            return TLongShortOffheapHashMap.this.keys();
        }

        @Override
        public long[] toArray(long[] dest) {
            return TLongShortOffheapHashMap.this.keys(dest);
        }

        @Override
        public boolean add(long entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(long entry) {
            return TLongShortOffheapHashMap.this.no_entry_value != TLongShortOffheapHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Long) {
                    long ele = (Long)element;
                    if (TLongShortOffheapHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TLongCollection collection) {
            TLongIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TLongShortOffheapHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(long[] array) {
            for (long element : array) {
                if (TLongShortOffheapHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Long> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TLongCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TLongIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TLongCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TLongIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(long[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TLongOffheapArray set = TLongShortOffheapHashMap.this._set;
            TByteOffheapArray states = TLongShortOffheapHashMap.this._states;
            int i = TLongShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, set.get(i)) >= 0) continue;
                TLongShortOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                long c;
                if (!(element instanceof Long) || !this.remove(c = ((Long)element).longValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TLongCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TLongIterator iter = collection.iterator();
            while (iter.hasNext()) {
                long element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(long[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TLongShortOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TLongProcedure procedure) {
            return TLongShortOffheapHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TLongSet)) {
                return false;
            }
            TLongSet that = (TLongSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TLongShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TLongShortOffheapHashMap.this._states.get(i) != 1 || that.contains(TLongShortOffheapHashMap.this._set.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i = TLongShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TLongShortOffheapHashMap.this._states.get(i) != 1) continue;
                hashcode += HashFunctions.hash(TLongShortOffheapHashMap.this._set.get(i));
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TLongShortOffheapHashMap.this.forEachKey(new TLongProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(long key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

