/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.map.hash;

import gnu.trove.TShortCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TShortOffheapArray;
import gnu.trove.function.TShortFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveOffheapIterator;
import gnu.trove.impl.hash.TPrimitiveOffheapHash;
import gnu.trove.impl.hash.TShortShortOffheapHash;
import gnu.trove.iterator.TShortIterator;
import gnu.trove.iterator.TShortShortIterator;
import gnu.trove.map.TShortShortMap;
import gnu.trove.procedure.TShortProcedure;
import gnu.trove.procedure.TShortShortProcedure;
import gnu.trove.set.TShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

public class TShortShortOffheapHashMap
extends TShortShortOffheapHash
implements TShortShortMap,
Externalizable {
    static final long serialVersionUID = 1L;
    protected transient TShortOffheapArray _values = new TShortOffheapArray(this.capacity());

    public TShortShortOffheapHashMap() {
        this(10, 0.5f);
    }

    public TShortShortOffheapHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public TShortShortOffheapHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        TShortOffheapArray oldKeys = this._set;
        TShortOffheapArray oldVals = this._values;
        TByteOffheapArray oldStates = this._states;
        this._set = new TShortOffheapArray(newCapacity);
        this._values = new TShortOffheapArray(newCapacity);
        this._states = new TByteOffheapArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates.get(i) != 1) continue;
            short o = oldKeys.get(i);
            int index = this.insertKey(o);
            this._values.put(index, oldVals.get(i));
        }
        oldKeys.free();
        oldVals.free();
        oldStates.free();
    }

    @Override
    public short put(short key, short value) {
        int index = this.insertKey(key);
        return this.doPut(key, value, index);
    }

    @Override
    public short putIfAbsent(short key, short value) {
        int index = this.insertKey(key);
        if (index < 0) {
            return this._values.get(-index - 1);
        }
        return this.doPut(key, value, index);
    }

    private short doPut(short key, short value, int index) {
        short previous = this.no_entry_value;
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values.get(index);
            isNewMapping = false;
        }
        this._values.put(index, value);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Short> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<? extends Short, ? extends Short> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void putAll(TShortShortMap map) {
        this.ensureCapacity(map.size());
        TShortShortIterator iter = map.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.put(iter.key(), iter.value());
        }
    }

    @Override
    public short get(short key) {
        int index = this.index(key);
        return index < 0 ? this.no_entry_value : this._values.get(index);
    }

    @Override
    public void clear() {
        super.clear();
        this._set.clear();
        this._values.clear();
        this._states.clear();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public short remove(short key) {
        short prev = this.no_entry_value;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values.get(index);
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index) {
        this._values.put(index, this.no_entry_value);
        super.removeAt(index);
    }

    @Override
    public TShortSet keySet() {
        return new TKeyView();
    }

    @Override
    public short[] keys() {
        short[] keys = new short[this.size()];
        TShortOffheapArray k = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            keys[j++] = k.get(i);
        }
        return keys;
    }

    @Override
    public short[] keys(short[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new short[size];
        }
        TShortOffheapArray keys = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = keys.get(i);
        }
        return array;
    }

    @Override
    public TShortCollection valueCollection() {
        return new TValueView();
    }

    @Override
    public short[] values() {
        short[] vals = new short[this.size()];
        TShortOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            vals[j++] = v.get(i);
        }
        return vals;
    }

    @Override
    public short[] values(short[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new short[size];
        }
        TShortOffheapArray v = this._values;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            array[j++] = v.get(i);
        }
        return array;
    }

    @Override
    public boolean containsValue(short val) {
        TByteOffheapArray states = this._states;
        TShortOffheapArray vals = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || val != vals.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(short key) {
        return this.contains(key);
    }

    @Override
    public TShortShortIterator iterator() {
        return new TShortShortOffheapHashIterator(this);
    }

    @Override
    public boolean forEachKey(TShortProcedure procedure) {
        return this.forEach(procedure);
    }

    @Override
    public boolean forEachValue(TShortProcedure procedure) {
        TByteOffheapArray states = this._states;
        TShortOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachEntry(TShortShortProcedure procedure) {
        TByteOffheapArray states = this._states;
        TShortOffheapArray keys = this._set;
        TShortOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transformValues(TShortFunction function) {
        TByteOffheapArray states = this._states;
        TShortOffheapArray values = this._values;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            values.put(i, function.execute(values.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainEntries(TShortShortProcedure procedure) {
        boolean modified = false;
        TByteOffheapArray states = this._states;
        TShortOffheapArray keys = this._set;
        TShortOffheapArray values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || procedure.execute(keys.get(i), values.get(i))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    @Override
    public boolean increment(short key) {
        return this.adjustValue(key, (short)1);
    }

    @Override
    public boolean adjustValue(short key, short amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        short val = this._values.get(index);
        this._values.put(index, (short)(val + amount));
        return true;
    }

    @Override
    public short adjustOrPutValue(short key, short adjust_amount, short put_amount) {
        boolean isNewMapping;
        short newValue;
        int index = this.insertKey(key);
        if (index < 0) {
            index = -index - 1;
            newValue = (short)(this._values.get(index) + adjust_amount);
            isNewMapping = false;
        } else {
            newValue = put_amount;
            isNewMapping = true;
        }
        this._values.put(index, newValue);
        if (isNewMapping) {
            this.postInsertHook(this.consumeFreeSlot);
        }
        return newValue;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TShortShortMap)) {
            return false;
        }
        TShortShortMap that = (TShortShortMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        TShortOffheapArray values = this._values;
        TByteOffheapArray states = this._states;
        short this_no_entry_value = this.getNoEntryValue();
        short that_no_entry_value = that.getNoEntryValue();
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            short key = this._set.get(i);
            short that_value = that.get(key);
            short this_value = values.get(i);
            if (this_value == that_value || this_value == this_no_entry_value || that_value == that_no_entry_value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            hashcode += HashFunctions.hash(this._set.get(i)) ^ HashFunctions.hash(this._values.get(i));
        }
        return hashcode;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TShortShortProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(short key, short value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeInt(this._size);
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            out.writeShort(this._set.get(i));
            out.writeShort(this._values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            short key = in.readShort();
            short val = in.readShort();
            this.put(key, val);
        }
    }

    class TShortShortOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TShortShortIterator {
        TShortShortOffheapHashIterator(TShortShortOffheapHashMap map) {
            super(map);
        }

        @Override
        public void advance() {
            this.moveToNextIndex();
        }

        @Override
        public short key() {
            return TShortShortOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public short value() {
            return TShortShortOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public short setValue(short val) {
            short old = this.value();
            TShortShortOffheapHashMap.this._values.put(this._index, val);
            return old;
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortShortOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TShortShortValueOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TShortIterator {
        TShortShortValueOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public short next() {
            this.moveToNextIndex();
            return TShortShortOffheapHashMap.this._values.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortShortOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    class TShortShortKeyOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TShortIterator {
        TShortShortKeyOffheapHashIterator(TPrimitiveOffheapHash hash) {
            super(hash);
        }

        @Override
        public short next() {
            this.moveToNextIndex();
            return TShortShortOffheapHashMap.this._set.get(this._index);
        }

        @Override
        public void remove() {
            if (this._expectedSize != this._hash.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this._hash.tempDisableAutoCompaction();
                TShortShortOffheapHashMap.this.removeAt(this._index);
            }
            finally {
                this._hash.reenableAutoCompaction(false);
            }
            --this._expectedSize;
        }
    }

    protected class TValueView
    implements TShortCollection {
        protected TValueView() {
        }

        @Override
        public TShortIterator iterator() {
            return new TShortShortValueOffheapHashIterator(TShortShortOffheapHashMap.this);
        }

        @Override
        public short getNoEntryValue() {
            return TShortShortOffheapHashMap.this.no_entry_value;
        }

        @Override
        public int size() {
            return TShortShortOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TShortShortOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(short entry) {
            return TShortShortOffheapHashMap.this.containsValue(entry);
        }

        @Override
        public short[] toArray() {
            return TShortShortOffheapHashMap.this.values();
        }

        @Override
        public short[] toArray(short[] dest) {
            return TShortShortOffheapHashMap.this.values(dest);
        }

        @Override
        public boolean add(short entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(short entry) {
            TShortOffheapArray values = TShortShortOffheapHashMap.this._values;
            TByteOffheapArray states = TShortShortOffheapHashMap.this._states;
            int i = TShortShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                byte state = states.get(i);
                if (state == 0 || state == 2 || entry != values.get(i)) continue;
                TShortShortOffheapHashMap.this.removeAt(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Short) {
                    short ele = (Short)element;
                    if (TShortShortOffheapHashMap.this.containsValue(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TShortCollection collection) {
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TShortShortOffheapHashMap.this.containsValue(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(short[] array) {
            for (short element : array) {
                if (TShortShortOffheapHashMap.this.containsValue(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Short> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TShortCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(short[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TShortCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(short[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TShortOffheapArray values = TShortShortOffheapHashMap.this._values;
            TByteOffheapArray states = TShortShortOffheapHashMap.this._states;
            int i = TShortShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, values.get(i)) >= 0) continue;
                TShortShortOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                short c;
                if (!(element instanceof Short) || !this.remove(c = ((Short)element).shortValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TShortCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                short element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(short[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TShortShortOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TShortProcedure procedure) {
            return TShortShortOffheapHashMap.this.forEachValue(procedure);
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TShortShortOffheapHashMap.this.forEachValue(new TShortProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(short value) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(value);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }

    protected class TKeyView
    implements TShortSet {
        protected TKeyView() {
        }

        @Override
        public TShortIterator iterator() {
            return new TShortShortKeyOffheapHashIterator(TShortShortOffheapHashMap.this);
        }

        @Override
        public short getNoEntryValue() {
            return TShortShortOffheapHashMap.this.no_entry_key;
        }

        @Override
        public int size() {
            return TShortShortOffheapHashMap.this._size;
        }

        @Override
        public boolean isEmpty() {
            return 0 == TShortShortOffheapHashMap.this._size;
        }

        @Override
        public boolean contains(short entry) {
            return TShortShortOffheapHashMap.this.contains(entry);
        }

        @Override
        public short[] toArray() {
            return TShortShortOffheapHashMap.this.keys();
        }

        @Override
        public short[] toArray(short[] dest) {
            return TShortShortOffheapHashMap.this.keys(dest);
        }

        @Override
        public boolean add(short entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(short entry) {
            return TShortShortOffheapHashMap.this.no_entry_value != TShortShortOffheapHashMap.this.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (element instanceof Short) {
                    short ele = (Short)element;
                    if (TShortShortOffheapHashMap.this.containsKey(ele)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(TShortCollection collection) {
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                if (TShortShortOffheapHashMap.this.containsKey(iter.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(short[] array) {
            for (short element : array) {
                if (TShortShortOffheapHashMap.this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Short> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(TShortCollection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(short[] array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(TShortCollection collection) {
            if (this == collection) {
                return false;
            }
            boolean modified = false;
            TShortIterator iter = this.iterator();
            while (iter.hasNext()) {
                if (collection.contains(iter.next())) continue;
                iter.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(short[] array) {
            boolean changed = false;
            Arrays.sort(array);
            TShortOffheapArray set = TShortShortOffheapHashMap.this._set;
            TByteOffheapArray states = TShortShortOffheapHashMap.this._states;
            int i = TShortShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (states.get(i) != 1 || Arrays.binarySearch(array, set.get(i)) >= 0) continue;
                TShortShortOffheapHashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                short c;
                if (!(element instanceof Short) || !this.remove(c = ((Short)element).shortValue())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(TShortCollection collection) {
            if (this == collection) {
                this.clear();
                return true;
            }
            boolean changed = false;
            TShortIterator iter = collection.iterator();
            while (iter.hasNext()) {
                short element = iter.next();
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean removeAll(short[] array) {
            boolean changed = false;
            int i = array.length;
            while (i-- > 0) {
                if (!this.remove(array[i])) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            TShortShortOffheapHashMap.this.clear();
        }

        @Override
        public boolean forEach(TShortProcedure procedure) {
            return TShortShortOffheapHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TShortSet)) {
                return false;
            }
            TShortSet that = (TShortSet)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = TShortShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TShortShortOffheapHashMap.this._states.get(i) != 1 || that.contains(TShortShortOffheapHashMap.this._set.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashcode = 0;
            int i = TShortShortOffheapHashMap.this.capacity();
            while (i-- > 0) {
                if (TShortShortOffheapHashMap.this._states.get(i) != 1) continue;
                hashcode += HashFunctions.hash(TShortShortOffheapHashMap.this._set.get(i));
            }
            return hashcode;
        }

        public String toString() {
            final StringBuilder buf = new StringBuilder("{");
            TShortShortOffheapHashMap.this.forEachKey(new TShortProcedure(){
                private boolean first = true;

                @Override
                public boolean execute(short key) {
                    if (this.first) {
                        this.first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(key);
                    return true;
                }
            });
            buf.append("}");
            return buf.toString();
        }
    }
}

