/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.set.hash;

import gnu.trove.TLongCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TLongOffheapArray;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveOffheapIterator;
import gnu.trove.impl.hash.TLongOffheapHash;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.set.TLongSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;

public class TLongOffheapHashSet
extends TLongOffheapHash
implements TLongSet,
Externalizable {
    static final long serialVersionUID = 1L;

    public TLongOffheapHashSet() {
    }

    public TLongOffheapHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TLongOffheapHashSet(int initialCapacity, float load_factor) {
        super(initialCapacity, load_factor);
    }

    @Override
    public TLongIterator iterator() {
        return new TLongOffheapHashIterator(this);
    }

    @Override
    public long[] toArray() {
        long[] result = new long[this.size()];
        TLongOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            result[j++] = set.get(i);
        }
        return result;
    }

    @Override
    public long[] toArray(long[] dest) {
        TLongOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            dest[j++] = set.get(i);
        }
        if (dest.length > this._size) {
            dest[this._size] = this.no_entry_value;
        }
        return dest;
    }

    @Override
    public boolean add(long val) {
        int index = this.insertKey(val);
        if (index < 0) {
            return false;
        }
        this.postInsertHook(this.consumeFreeSlot);
        return true;
    }

    @Override
    public boolean remove(long val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (element instanceof Long) {
                long c = (Long)element;
                if (this.contains(c)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TLongCollection collection) {
        TLongIterator iter = collection.iterator();
        while (iter.hasNext()) {
            long element = iter.next();
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(long[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        boolean changed = false;
        for (Long l : collection) {
            long e = l;
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TLongCollection collection) {
        boolean changed = false;
        TLongIterator iter = collection.iterator();
        while (iter.hasNext()) {
            long element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(long[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        TLongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(TLongCollection collection) {
        if (this == collection) {
            return false;
        }
        boolean modified = false;
        TLongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(long[] array) {
        boolean changed = false;
        Arrays.sort(array);
        TLongOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        this._autoCompactTemporaryDisable = true;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || Arrays.binarySearch(array, set.get(i)) >= 0) continue;
            this.removeAt(i);
            changed = true;
        }
        this._autoCompactTemporaryDisable = false;
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            long c;
            if (!(element instanceof Long) || !this.remove(c = ((Long)element).longValue())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(TLongCollection collection) {
        boolean changed = false;
        TLongIterator iter = collection.iterator();
        while (iter.hasNext()) {
            long element = iter.next();
            if (!this.remove(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(long[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        super.clear();
        TLongOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        while (i-- > 0) {
            set.put(i, this.no_entry_value);
            states.put(i, (byte)0);
        }
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        TLongOffheapArray oldSet = this._set;
        TByteOffheapArray oldStates = this._states;
        this._set = new TLongOffheapArray(newCapacity);
        this._states = new TByteOffheapArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates.get(i) != 1) continue;
            long o = oldSet.get(i);
            this.insertKey(o);
        }
        oldSet.free();
        oldStates.free();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TLongSet)) {
            return false;
        }
        TLongSet that = (TLongSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1 || that.contains(this._set.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashcode = 0;
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            hashcode += HashFunctions.hash(this._set.get(i));
        }
        return hashcode;
    }

    public String toString() {
        StringBuilder buffy = new StringBuilder(this._size * 2 + 2);
        buffy.append("{");
        int i = this.capacity();
        int j = 1;
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            buffy.append(this._set.get(i));
            if (j++ >= this._size) continue;
            buffy.append(",");
        }
        buffy.append("}");
        return buffy.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        super.writeExternal(out);
        out.writeInt(this._size);
        out.writeFloat(this._loadFactor);
        out.writeLong(this.no_entry_value);
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            out.writeLong(this._set.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        if (version >= 1) {
            this._loadFactor = in.readFloat();
            this.no_entry_value = in.readLong();
        }
        this.setUp(size);
        while (size-- > 0) {
            long val = in.readLong();
            this.add(val);
        }
    }

    class TLongOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TLongIterator {
        private final TLongOffheapHash _hash;

        public TLongOffheapHashIterator(TLongOffheapHash hash) {
            super(hash);
            this._hash = hash;
        }

        @Override
        public long next() {
            this.moveToNextIndex();
            return this._hash._set.get(this._index);
        }
    }
}

