/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.set.hash;

import gnu.trove.TShortCollection;
import gnu.trove.array.TByteOffheapArray;
import gnu.trove.array.TShortOffheapArray;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THashPrimitiveOffheapIterator;
import gnu.trove.impl.hash.TShortOffheapHash;
import gnu.trove.iterator.TShortIterator;
import gnu.trove.set.TShortSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;

public class TShortOffheapHashSet
extends TShortOffheapHash
implements TShortSet,
Externalizable {
    static final long serialVersionUID = 1L;

    public TShortOffheapHashSet() {
    }

    public TShortOffheapHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TShortOffheapHashSet(int initialCapacity, float load_factor) {
        super(initialCapacity, load_factor);
    }

    @Override
    public TShortIterator iterator() {
        return new TShortOffheapHashIterator(this);
    }

    @Override
    public short[] toArray() {
        short[] result = new short[this.size()];
        TShortOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            result[j++] = set.get(i);
        }
        return result;
    }

    @Override
    public short[] toArray(short[] dest) {
        TShortOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        int j = 0;
        while (i-- > 0) {
            if (states.get(i) != 1) continue;
            dest[j++] = set.get(i);
        }
        if (dest.length > this._size) {
            dest[this._size] = this.no_entry_value;
        }
        return dest;
    }

    @Override
    public boolean add(short val) {
        int index = this.insertKey(val);
        if (index < 0) {
            return false;
        }
        this.postInsertHook(this.consumeFreeSlot);
        return true;
    }

    @Override
    public boolean remove(short val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (element instanceof Short) {
                short c = (Short)element;
                if (this.contains(c)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TShortCollection collection) {
        TShortIterator iter = collection.iterator();
        while (iter.hasNext()) {
            short element = iter.next();
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(short[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Short> collection) {
        boolean changed = false;
        for (Short s : collection) {
            short e = s;
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(TShortCollection collection) {
        boolean changed = false;
        TShortIterator iter = collection.iterator();
        while (iter.hasNext()) {
            short element = iter.next();
            if (!this.add(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(short[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        TShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(TShortCollection collection) {
        if (this == collection) {
            return false;
        }
        boolean modified = false;
        TShortIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (collection.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(short[] array) {
        boolean changed = false;
        Arrays.sort(array);
        TShortOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        this._autoCompactTemporaryDisable = true;
        int i = this.capacity();
        while (i-- > 0) {
            if (states.get(i) != 1 || Arrays.binarySearch(array, set.get(i)) >= 0) continue;
            this.removeAt(i);
            changed = true;
        }
        this._autoCompactTemporaryDisable = false;
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            short c;
            if (!(element instanceof Short) || !this.remove(c = ((Short)element).shortValue())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(TShortCollection collection) {
        boolean changed = false;
        TShortIterator iter = collection.iterator();
        while (iter.hasNext()) {
            short element = iter.next();
            if (!this.remove(element)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(short[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        super.clear();
        TShortOffheapArray set = this._set;
        TByteOffheapArray states = this._states;
        int i = this.capacity();
        while (i-- > 0) {
            set.put(i, this.no_entry_value);
            states.put(i, (byte)0);
        }
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        TShortOffheapArray oldSet = this._set;
        TByteOffheapArray oldStates = this._states;
        this._set = new TShortOffheapArray(newCapacity);
        this._states = new TByteOffheapArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates.get(i) != 1) continue;
            short o = oldSet.get(i);
            this.insertKey(o);
        }
        oldSet.free();
        oldStates.free();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TShortSet)) {
            return false;
        }
        TShortSet that = (TShortSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1 || that.contains(this._set.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashcode = 0;
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            hashcode += HashFunctions.hash(this._set.get(i));
        }
        return hashcode;
    }

    public String toString() {
        StringBuilder buffy = new StringBuilder(this._size * 2 + 2);
        buffy.append("{");
        int i = this.capacity();
        int j = 1;
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            buffy.append(this._set.get(i));
            if (j++ >= this._size) continue;
            buffy.append(",");
        }
        buffy.append("}");
        return buffy.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        super.writeExternal(out);
        out.writeInt(this._size);
        out.writeFloat(this._loadFactor);
        out.writeShort(this.no_entry_value);
        int i = this.capacity();
        while (i-- > 0) {
            if (this._states.get(i) != 1) continue;
            out.writeShort(this._set.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        super.readExternal(in);
        int size = in.readInt();
        if (version >= 1) {
            this._loadFactor = in.readFloat();
            this.no_entry_value = in.readShort();
        }
        this.setUp(size);
        while (size-- > 0) {
            short val = in.readShort();
            this.add(val);
        }
    }

    class TShortOffheapHashIterator
    extends THashPrimitiveOffheapIterator
    implements TShortIterator {
        private final TShortOffheapHash _hash;

        public TShortOffheapHashIterator(TShortOffheapHash hash) {
            super(hash);
            this._hash = hash;
        }

        @Override
        public short next() {
            this.moveToNextIndex();
            return this._hash._set.get(this._index);
        }
    }
}

