/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.ri;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceIdentifier {
    private static final String RID_CLASS = "ri";
    private static final String SEPARATOR = ".";
    private static final String SERVICE_REGEX = "([a-z][a-z0-9\\-]*)";
    private static final String INSTANCE_REGEX = "([a-z0-9][a-z0-9\\-]*)?";
    private static final String TYPE_REGEX = "([a-z][a-z0-9\\-]*)";
    private static final String LOCATOR_REGEX = "([a-zA-Z0-9_\\-\\.]+)";
    private static final Pattern SERVICE_PATTERN = Pattern.compile("([a-z][a-z0-9\\-]*)");
    private static final Pattern INSTANCE_PATTERN = Pattern.compile("([a-z0-9][a-z0-9\\-]*)?");
    private static final Pattern TYPE_PATTERN = Pattern.compile("([a-z][a-z0-9\\-]*)");
    private static final Pattern LOCATOR_PATTERN = Pattern.compile("([a-zA-Z0-9_\\-\\.]+)");
    private static final Pattern SPEC_PATTERN = Pattern.compile("ri\\.([a-z][a-z0-9\\-]*)\\.([a-z0-9][a-z0-9\\-]*)?\\.([a-z][a-z0-9\\-]*)\\.([a-zA-Z0-9_\\-\\.]+)");
    private final String resourceIdentifier;
    private final int serviceIndex;
    private final int instanceIndex;
    private final int typeIndex;
    private final int locatorIndex;

    private ResourceIdentifier(String service, String instance, String type, String locator) {
        String safeInstance = instance == null ? "" : instance;
        this.resourceIdentifier = "ri." + service + SEPARATOR + safeInstance + SEPARATOR + type + SEPARATOR + locator;
        this.serviceIndex = RID_CLASS.length() + SEPARATOR.length() + service.length();
        this.instanceIndex = this.serviceIndex + SEPARATOR.length() + safeInstance.length();
        this.typeIndex = this.instanceIndex + SEPARATOR.length() + type.length();
        this.locatorIndex = this.typeIndex + SEPARATOR.length() + locator.length();
    }

    public String getService() {
        return this.resourceIdentifier.substring(RID_CLASS.length() + SEPARATOR.length(), this.serviceIndex);
    }

    public String getInstance() {
        return this.resourceIdentifier.substring(this.serviceIndex + 1, this.instanceIndex);
    }

    public String getType() {
        return this.resourceIdentifier.substring(this.instanceIndex + 1, this.typeIndex);
    }

    public String getLocator() {
        CharBuffer.wrap(this.resourceIdentifier);
        return this.resourceIdentifier.substring(this.typeIndex + 1, this.locatorIndex);
    }

    @JsonValue
    public String toString() {
        return this.resourceIdentifier;
    }

    public int hashCode() {
        return this.resourceIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return this.resourceIdentifier.equals(other.resourceIdentifier);
    }

    public static boolean isValid(String rid) {
        return rid != null && SPEC_PATTERN.matcher(rid).matches();
    }

    public static boolean isValidService(String service) {
        return service != null && SERVICE_PATTERN.matcher(service).matches();
    }

    public static boolean isValidInstance(String instance) {
        return instance != null && INSTANCE_PATTERN.matcher(instance).matches();
    }

    public static boolean isValidType(String type) {
        return type != null && TYPE_PATTERN.matcher(type).matches();
    }

    public static boolean isValidLocator(String locator) {
        return locator != null && LOCATOR_PATTERN.matcher(locator).matches();
    }

    @JsonCreator
    public static ResourceIdentifier valueOf(String rid) {
        return ResourceIdentifier.of(rid);
    }

    public static ResourceIdentifier of(String rid) {
        Matcher matcher;
        if (rid != null && (matcher = SPEC_PATTERN.matcher(rid)).matches()) {
            return new ResourceIdentifier(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
        }
        throw new IllegalArgumentException("Illegal resource identifier format: " + rid);
    }

    public static ResourceIdentifier of(String service, String instance, String type, String locator) {
        ResourceIdentifier.checkServiceIsValid(service);
        ResourceIdentifier.checkInstanceIsValid(instance);
        ResourceIdentifier.checkTypeIsValid(type);
        ResourceIdentifier.checkLocatorIsValid(locator);
        return new ResourceIdentifier(service, instance, type, locator);
    }

    public static ResourceIdentifier of(String service, String instance, String type, String firstLocatorComponent, String ... locatorComponents) {
        StringBuilder builder = new StringBuilder(firstLocatorComponent);
        for (String component : locatorComponents) {
            builder.append(SEPARATOR).append(component);
        }
        return ResourceIdentifier.of(service, instance, type, builder.toString());
    }

    private static void checkServiceIsValid(String service) {
        if (!ResourceIdentifier.isValidService(service)) {
            throw new IllegalArgumentException("Illegal service format: " + service);
        }
    }

    private static void checkInstanceIsValid(String instance) {
        if (!ResourceIdentifier.isValidInstance(instance)) {
            throw new IllegalArgumentException("Illegal instance format: " + instance);
        }
    }

    private static void checkTypeIsValid(String type) {
        if (!ResourceIdentifier.isValidType(type)) {
            throw new IllegalArgumentException("Illegal type format: " + type);
        }
    }

    private static void checkLocatorIsValid(String value) {
        if (!ResourceIdentifier.isValidLocator(value)) {
            throw new IllegalArgumentException("Illegal locator format: " + value);
        }
    }
}

