/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.ri;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class ResourceIdentifier {
    private static final String RID_PREFIX = "ri.";
    private static final int RID_PREFIX_LENGTH = 3;
    private static final char SEPARATOR = '.';
    private static final int INDEX_INVALID = -1;
    private static final int INDEX_END = -2;
    private final String resourceIdentifier;
    private final int serviceIndex;
    private final int instanceIndex;
    private final int typeIndex;

    private ResourceIdentifier(String validatedString, int serviceIndex, int instanceIndex, int typeIndex) {
        this.resourceIdentifier = validatedString;
        this.serviceIndex = serviceIndex;
        this.instanceIndex = instanceIndex;
        this.typeIndex = typeIndex;
    }

    public String getService() {
        return this.resourceIdentifier.substring(3, this.serviceIndex);
    }

    public String getInstance() {
        return this.resourceIdentifier.substring(this.serviceIndex + 1, this.instanceIndex);
    }

    public String getType() {
        return this.resourceIdentifier.substring(this.instanceIndex + 1, this.typeIndex);
    }

    public String getLocator() {
        return this.resourceIdentifier.substring(this.typeIndex + 1);
    }

    @JsonValue
    public String toString() {
        return this.resourceIdentifier;
    }

    public int hashCode() {
        return this.resourceIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return this.resourceIdentifier.equals(other.resourceIdentifier);
    }

    public static boolean isValid(String rid) {
        if (rid == null) {
            return false;
        }
        if (!rid.startsWith(RID_PREFIX)) {
            return false;
        }
        int serviceIndex = ResourceIdentifier.getServiceIndex(rid, 3);
        if (serviceIndex < 0) {
            return false;
        }
        int instanceIndex = ResourceIdentifier.getInstanceIndex(rid, serviceIndex + 1);
        if (instanceIndex < 0) {
            return false;
        }
        int typeIndex = ResourceIdentifier.getTypeIndex(rid, instanceIndex + 1);
        if (typeIndex < 0) {
            return false;
        }
        int locatorIndex = ResourceIdentifier.getLocatorIndex(rid, typeIndex + 1);
        return locatorIndex == -2;
    }

    public static boolean isValidService(String service) {
        return ResourceIdentifier.isValidService((CharSequence)service);
    }

    private static boolean isValidService(CharSequence service) {
        return ResourceIdentifier.getServiceIndex(service, 0) == -2;
    }

    public static boolean isValidInstance(String instance) {
        return ResourceIdentifier.isValidInstance((CharSequence)instance);
    }

    private static boolean isValidInstance(CharSequence instance) {
        return ResourceIdentifier.getInstanceIndex(instance, 0) == -2;
    }

    public static boolean isValidType(String type) {
        return ResourceIdentifier.isValidType((CharSequence)type);
    }

    private static boolean isValidType(CharSequence type) {
        return ResourceIdentifier.getTypeIndex(type, 0) == -2;
    }

    public static boolean isValidLocator(String locator) {
        return ResourceIdentifier.isValidLocator((CharSequence)locator);
    }

    private static boolean isValidLocator(CharSequence locator) {
        return ResourceIdentifier.getLocatorIndex(locator, 0) == -2;
    }

    @JsonCreator
    public static ResourceIdentifier valueOf(String rid) {
        return ResourceIdentifier.of(rid);
    }

    public static ResourceIdentifier of(String rid) {
        ResourceIdentifier resultRid = ResourceIdentifier.tryOf(rid);
        if (resultRid == null) {
            throw new IllegalArgumentException("Illegal resource identifier format: " + rid);
        }
        return resultRid;
    }

    public static ResourceIdentifier of(String service, String instance, String type, String locator) {
        return ResourceIdentifier.of((CharSequence)service, (CharSequence)instance, (CharSequence)type, (CharSequence)locator);
    }

    public static ResourceIdentifier of(String service, String instance, String type, String firstLocatorComponent, String ... locatorComponents) {
        int locatorLength = firstLocatorComponent.length() + locatorComponents.length;
        for (String component : locatorComponents) {
            locatorLength += component.length();
        }
        StringBuilder locator = new StringBuilder(locatorLength);
        locator.append(firstLocatorComponent);
        for (String component : locatorComponents) {
            locator.append('.').append(component);
        }
        return ResourceIdentifier.of((CharSequence)service, (CharSequence)instance, (CharSequence)type, locator);
    }

    private static ResourceIdentifier of(CharSequence service, CharSequence instance, CharSequence type, CharSequence locator) {
        ResourceIdentifier.checkServiceIsValid(service);
        ResourceIdentifier.checkInstanceIsValid(instance);
        ResourceIdentifier.checkTypeIsValid(type);
        ResourceIdentifier.checkLocatorIsValid(locator);
        String resourceIdentifier = RID_PREFIX + service + "." + instance + "." + type + "." + locator;
        int serviceIndex = 3 + service.length();
        int instanceIndex = serviceIndex + 1 + instance.length();
        int typeIndex = instanceIndex + 1 + type.length();
        return new ResourceIdentifier(resourceIdentifier, serviceIndex, instanceIndex, typeIndex);
    }

    private static ResourceIdentifier tryOf(String rid) {
        if (rid == null) {
            return null;
        }
        if (!rid.startsWith(RID_PREFIX)) {
            return null;
        }
        int serviceIndex = ResourceIdentifier.getServiceIndex(rid, 3);
        if (serviceIndex < 0) {
            return null;
        }
        int instanceIndex = ResourceIdentifier.getInstanceIndex(rid, serviceIndex + 1);
        if (instanceIndex < 0) {
            return null;
        }
        int typeIndex = ResourceIdentifier.getTypeIndex(rid, instanceIndex + 1);
        if (typeIndex < 0) {
            return null;
        }
        int locatorIndex = ResourceIdentifier.getLocatorIndex(rid, typeIndex + 1);
        if (locatorIndex != -2) {
            return null;
        }
        return new ResourceIdentifier(rid, serviceIndex, instanceIndex, typeIndex);
    }

    private static void checkServiceIsValid(CharSequence service) {
        if (!ResourceIdentifier.isValidService(service)) {
            throw new IllegalArgumentException("Illegal service format: " + service);
        }
    }

    private static void checkInstanceIsValid(CharSequence instance) {
        if (!ResourceIdentifier.isValidInstance(instance)) {
            throw new IllegalArgumentException("Illegal instance format: " + instance);
        }
    }

    private static void checkTypeIsValid(CharSequence type) {
        if (!ResourceIdentifier.isValidType(type)) {
            throw new IllegalArgumentException("Illegal type format: " + type);
        }
    }

    private static void checkLocatorIsValid(CharSequence locator) {
        if (!ResourceIdentifier.isValidLocator(locator)) {
            throw new IllegalArgumentException("Illegal locator format: " + locator);
        }
    }

    private static int getServiceIndex(CharSequence value, int start) {
        if (value == null) {
            return -1;
        }
        int length = value.length();
        if (start >= length) {
            return -1;
        }
        for (int i = start; i < length; ++i) {
            char ch = value.charAt(i);
            if (i == start) {
                if (ResourceIdentifier.isLowerAlpha(ch)) continue;
                return -1;
            }
            if (ch == '.') {
                return i;
            }
            if (ResourceIdentifier.isLowerAlpha(ch) || ResourceIdentifier.isDigit(ch) || ResourceIdentifier.isDash(ch)) continue;
            return -1;
        }
        return -2;
    }

    private static int getInstanceIndex(CharSequence value, int start) {
        if (value == null) {
            return -1;
        }
        int length = value.length();
        if (start > length) {
            return -1;
        }
        for (int i = start; i < length; ++i) {
            char ch = value.charAt(i);
            if (ch == '.') {
                return i;
            }
            if (!(i == start ? !ResourceIdentifier.isLowerAlpha(ch) && !ResourceIdentifier.isDigit(ch) : !ResourceIdentifier.isLowerAlpha(ch) && !ResourceIdentifier.isDigit(ch) && !ResourceIdentifier.isDash(ch))) continue;
            return -1;
        }
        return -2;
    }

    private static int getTypeIndex(CharSequence value, int start) {
        return ResourceIdentifier.getServiceIndex(value, start);
    }

    private static int getLocatorIndex(CharSequence value, int start) {
        if (value == null) {
            return -1;
        }
        int length = value.length();
        if (start >= length) {
            return -1;
        }
        for (int i = start; i < length; ++i) {
            char ch = value.charAt(i);
            if (ResourceIdentifier.isLowerAlpha(ch) || ResourceIdentifier.isUpperAlpha(ch) || ResourceIdentifier.isDigit(ch) || ResourceIdentifier.isDot(ch) || ResourceIdentifier.isDash(ch) || ResourceIdentifier.isUnderscore(ch)) continue;
            return -1;
        }
        return -2;
    }

    private static boolean isLowerAlpha(char ch) {
        return 'a' <= ch && ch <= 'z';
    }

    private static boolean isUpperAlpha(char ch) {
        return 'A' <= ch && ch <= 'Z';
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static boolean isDot(char ch) {
        return ch == '.';
    }

    private static boolean isDash(char ch) {
        return ch == '-';
    }

    private static boolean isUnderscore(char ch) {
        return ch == '_';
    }
}

