/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.exceptions.SafeNullPointerException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new SafeIllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @CompileTimeConstant String message) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, new Arg[0]);
        }
    }

    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> arg) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg);
        }
    }

    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg1, arg2);
        }
    }

    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg1, arg2, arg3);
        }
    }

    public static void checkArgument(boolean expression, @CompileTimeConstant String message, Arg<?> ... args) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, args);
        }
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new SafeIllegalArgumentException();
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, new Arg[0]);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, arg);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, arg1, arg2);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, arg1, arg2, arg3);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> ... args) {
        if (reference == null) {
            throw new SafeIllegalArgumentException(message, args);
        }
        return reference;
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new SafeIllegalStateException();
        }
    }

    public static void checkState(boolean expression, @CompileTimeConstant String message) {
        if (!expression) {
            throw new SafeIllegalStateException(message, new Arg[0]);
        }
    }

    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> arg) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg);
        }
    }

    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg1, arg2);
        }
    }

    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg1, arg2, arg3);
        }
    }

    public static void checkState(boolean expression, @CompileTimeConstant String message, Arg<?> ... args) {
        if (!expression) {
            throw new SafeIllegalStateException(message, args);
        }
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new SafeNullPointerException();
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message) {
        if (reference == null) {
            throw new SafeNullPointerException(message, new Arg[0]);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg1, arg2);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg1, arg2, arg3);
        }
        return reference;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, @CompileTimeConstant String message, Arg<?> ... args) {
        if (reference == null) {
            throw new SafeNullPointerException(message, args);
        }
        return reference;
    }
}

