/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.exceptions.SafeNullPointerException;
import javax.annotation.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new SafeIllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, new Arg[0]);
        }
    }

    public static void checkArgument(boolean expression, String message, Arg<?> arg) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg);
        }
    }

    public static void checkArgument(boolean expression, String message, Arg<?> arg1, Arg<?> arg2) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg1, arg2);
        }
    }

    public static void checkArgument(boolean expression, String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, arg1, arg2, arg3);
        }
    }

    public static void checkArgument(boolean expression, String message, Arg<?> ... args) {
        if (!expression) {
            throw new SafeIllegalArgumentException(message, args);
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new SafeIllegalStateException();
        }
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new SafeIllegalStateException(message, new Arg[0]);
        }
    }

    public static void checkState(boolean expression, String message, Arg<?> arg) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg);
        }
    }

    public static void checkState(boolean expression, String message, Arg<?> arg1, Arg<?> arg2) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg1, arg2);
        }
    }

    public static void checkState(boolean expression, String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (!expression) {
            throw new SafeIllegalStateException(message, arg1, arg2, arg3);
        }
    }

    public static void checkState(boolean expression, String message, Arg<?> ... args) {
        if (!expression) {
            throw new SafeIllegalStateException(message, args);
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new SafeNullPointerException();
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, String message) {
        if (reference == null) {
            throw new SafeNullPointerException(message, new Arg[0]);
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, String message, Arg<?> arg) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg);
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, String message, Arg<?> arg1, Arg<?> arg2) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg1, arg2);
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, String message, Arg<?> arg1, Arg<?> arg2, Arg<?> arg3) {
        if (reference == null) {
            throw new SafeNullPointerException(message, arg1, arg2, arg3);
        }
        return reference;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(@Nullable T reference, String message, Arg<?> ... args) {
        if (reference == null) {
            throw new SafeNullPointerException(message, args);
        }
        return reference;
    }
}

