/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe.exceptions;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.exceptions.SafeExceptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SafeNullPointerException
extends NullPointerException
implements SafeLoggable {
    private final String logMessage;
    private final List<Arg<?>> arguments;

    public SafeNullPointerException() {
        super("");
        this.logMessage = "";
        this.arguments = Collections.emptyList();
    }

    public SafeNullPointerException(String message, Arg<?> ... arguments) {
        super(SafeExceptions.renderMessage(message, arguments));
        this.logMessage = message;
        this.arguments = Collections.unmodifiableList(Arrays.asList(arguments));
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public List<Arg<?>> getArgs() {
        return this.arguments;
    }
}

