/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tokens.auth.AuthHeader;
import com.palantir.tokens.auth.BearerToken;
import com.palantir.tokens.auth.ImmutableUnverifiedJsonWebToken;
import com.palantir.tokens.auth.UuidStringConverter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;

@Safe
@Value.Immutable
public abstract class UnverifiedJsonWebToken {
    private static final ObjectReader READER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(JwtPayload.class);
    private static final SafeLogger log = SafeLoggerFactory.get(UnverifiedJsonWebToken.class);

    @Safe
    @Value.Parameter
    public abstract String getUnverifiedUserId();

    @Safe
    @Value.Parameter
    public abstract Optional<String> getUnverifiedSessionId();

    @Safe
    @Value.Parameter
    public abstract Optional<String> getUnverifiedTokenId();

    public static Optional<UnverifiedJsonWebToken> tryParse(String rawAuthHeader) {
        if (UnverifiedJsonWebToken.countCharacter(rawAuthHeader, '.') == 2) {
            try {
                return Optional.of(UnverifiedJsonWebToken.of(AuthHeader.valueOf(rawAuthHeader).getBearerToken()));
            }
            catch (Throwable t) {
                log.debug("Unable to process auth header.", t);
            }
        }
        return Optional.empty();
    }

    private static int countCharacter(String input, char toCount) {
        int count = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != toCount) continue;
            ++count;
        }
        return count;
    }

    public static UnverifiedJsonWebToken of(BearerToken token) {
        String[] segments = token.getToken().split("\\.", -1);
        if (segments.length != 3) {
            throw new SafeIllegalArgumentException("Invalid JWT: expected 3 segments", new Arg[]{SafeArg.of((String)"segmentsCount", (Object)segments.length)});
        }
        JwtPayload payload = UnverifiedJsonWebToken.extractPayload(segments[1]);
        return ImmutableUnverifiedJsonWebToken.of(UnverifiedJsonWebToken.decodeUuidBytes(payload.sub), Optional.ofNullable(payload.sid).map(UnverifiedJsonWebToken::decodeUuidBytes), Optional.ofNullable(payload.jti).map(UnverifiedJsonWebToken::decodeUuidBytes));
    }

    private static JwtPayload extractPayload(String payload) {
        try {
            return (JwtPayload)READER.readValue(Base64.getUrlDecoder().decode(payload));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new SafeIllegalArgumentException("Invalid JWT: cannot parse payload", (Throwable)e, new Arg[0]);
        }
    }

    private static String decodeUuidBytes(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 16 ? 1 : 0) != 0, (String)"Invalid JWT: cannot decode UUID, require 16 bytes", (Arg)SafeArg.of((String)"bytesLength", (Object)bytes.length));
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return UuidStringConverter.toString(new UUID(high, low));
    }

    private static final class JwtPayload {
        @JsonProperty(value="sub")
        private byte[] sub;
        @JsonProperty(value="sid")
        private byte[] sid;
        @JsonProperty(value="jti")
        private byte[] jti;

        private JwtPayload() {
        }
    }
}

