/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

public final class AuthTokensPreconditions {
    private AuthTokensPreconditions() {
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(AuthTokensPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    private static String format(String rawTemplate, Object ... args) {
        int placeholderStart;
        String template = String.valueOf(rawTemplate);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int idx = 0;
        while (idx < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[idx++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (idx < args.length) {
            builder.append(" [");
            builder.append(args[idx++]);
            while (idx < args.length) {
                builder.append(", ");
                builder.append(args[idx++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

