/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.tokens.auth.AuthTokensPreconditions;
import com.palantir.tokens.auth.ImmutableBearerToken;
import com.palantir.tokens.auth.ImmutablesStyle;
import java.security.MessageDigest;
import java.util.BitSet;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
@ImmutablesStyle
public abstract class BearerToken {
    private static final Logger log = LoggerFactory.getLogger(BearerToken.class);
    private static final String VALIDATION_PATTERN_STRING = "^[A-Za-z0-9\\-\\._~\\+/]+=*$";
    private static final BitSet allowedCharacters = new BitSet();

    @JsonValue
    @Value.Parameter
    public abstract String getToken();

    @Value.Derived
    byte[] getTokenAsBytes() {
        String token = this.getToken();
        byte[] result = new byte[token.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)token.charAt(i);
        }
        return result;
    }

    @JsonCreator
    public static BearerToken valueOf(String token) {
        AuthTokensPreconditions.checkArgument(token != null, "BearerToken cannot be null", new Object[0]);
        AuthTokensPreconditions.checkArgument(!token.isEmpty(), "BearerToken cannot be empty", new Object[0]);
        if (!BearerToken.isValidBearerToken(token)) {
            log.trace("Error parsing BearerToken, must match pattern {}: {}", (Object)VALIDATION_PATTERN_STRING, (Object)token);
            throw new IllegalArgumentException("BearerToken must match pattern ^[A-Za-z0-9\\-\\._~\\+/]+=*$");
        }
        return ImmutableBearerToken.of(token);
    }

    private static boolean isValidBearerToken(String token) {
        int cursor;
        int length = token.length();
        for (cursor = 0; cursor < length && allowedCharacters.get(token.charAt(cursor)); ++cursor) {
        }
        if (cursor == 0) {
            return false;
        }
        while (cursor < length) {
            if (token.charAt(cursor) != '=') {
                return false;
            }
            ++cursor;
        }
        return true;
    }

    public final String toString() {
        return this.getToken();
    }

    public final boolean equals(Object other) {
        return other != null && other instanceof BearerToken && MessageDigest.isEqual(((BearerToken)other).getTokenAsBytes(), this.getTokenAsBytes());
    }

    public final int hashCode() {
        return this.getToken().hashCode();
    }

    static {
        allowedCharacters.set(65, 91);
        allowedCharacters.set(97, 123);
        allowedCharacters.set(48, 58);
        allowedCharacters.set(45);
        allowedCharacters.set(46);
        allowedCharacters.set(95);
        allowedCharacters.set(126);
        allowedCharacters.set(43);
        allowedCharacters.set(47);
    }
}

