/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

import com.palantir.tokens.auth.UnverifiedJsonWebToken;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

final class ImmutableUnverifiedJsonWebToken
extends UnverifiedJsonWebToken {
    private final String unverifiedUserId;
    private final String unverifiedSessionId;
    private final String unverifiedTokenId;

    private ImmutableUnverifiedJsonWebToken(String unverifiedUserId, Optional<String> unverifiedSessionId, Optional<String> unverifiedTokenId) {
        this.unverifiedUserId = Objects.requireNonNull(unverifiedUserId, "unverifiedUserId");
        this.unverifiedSessionId = unverifiedSessionId.orElse(null);
        this.unverifiedTokenId = unverifiedTokenId.orElse(null);
    }

    private ImmutableUnverifiedJsonWebToken(ImmutableUnverifiedJsonWebToken original, String unverifiedUserId, String unverifiedSessionId, String unverifiedTokenId) {
        this.unverifiedUserId = unverifiedUserId;
        this.unverifiedSessionId = unverifiedSessionId;
        this.unverifiedTokenId = unverifiedTokenId;
    }

    @Override
    public String getUnverifiedUserId() {
        return this.unverifiedUserId;
    }

    @Override
    public Optional<String> getUnverifiedSessionId() {
        return Optional.ofNullable(this.unverifiedSessionId);
    }

    @Override
    public Optional<String> getUnverifiedTokenId() {
        return Optional.ofNullable(this.unverifiedTokenId);
    }

    public final ImmutableUnverifiedJsonWebToken withUnverifiedUserId(String value) {
        if (this.unverifiedUserId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "unverifiedUserId");
        return new ImmutableUnverifiedJsonWebToken(this, newValue, this.unverifiedSessionId, this.unverifiedTokenId);
    }

    public final ImmutableUnverifiedJsonWebToken withUnverifiedSessionId(String value) {
        String newValue = Objects.requireNonNull(value, "unverifiedSessionId");
        if (Objects.equals(this.unverifiedSessionId, newValue)) {
            return this;
        }
        return new ImmutableUnverifiedJsonWebToken(this, this.unverifiedUserId, newValue, this.unverifiedTokenId);
    }

    public final ImmutableUnverifiedJsonWebToken withUnverifiedSessionId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.unverifiedSessionId, value)) {
            return this;
        }
        return new ImmutableUnverifiedJsonWebToken(this, this.unverifiedUserId, value, this.unverifiedTokenId);
    }

    public final ImmutableUnverifiedJsonWebToken withUnverifiedTokenId(String value) {
        String newValue = Objects.requireNonNull(value, "unverifiedTokenId");
        if (Objects.equals(this.unverifiedTokenId, newValue)) {
            return this;
        }
        return new ImmutableUnverifiedJsonWebToken(this, this.unverifiedUserId, this.unverifiedSessionId, newValue);
    }

    public final ImmutableUnverifiedJsonWebToken withUnverifiedTokenId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.unverifiedTokenId, value)) {
            return this;
        }
        return new ImmutableUnverifiedJsonWebToken(this, this.unverifiedUserId, this.unverifiedSessionId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUnverifiedJsonWebToken && this.equalTo((ImmutableUnverifiedJsonWebToken)another);
    }

    private boolean equalTo(ImmutableUnverifiedJsonWebToken another) {
        return this.unverifiedUserId.equals(another.unverifiedUserId) && Objects.equals(this.unverifiedSessionId, another.unverifiedSessionId) && Objects.equals(this.unverifiedTokenId, another.unverifiedTokenId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.unverifiedUserId.hashCode();
        h += (h << 5) + Objects.hashCode(this.unverifiedSessionId);
        h += (h << 5) + Objects.hashCode(this.unverifiedTokenId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UnverifiedJsonWebToken{");
        builder.append("unverifiedUserId=").append(this.unverifiedUserId);
        if (this.unverifiedSessionId != null) {
            builder.append(", ");
            builder.append("unverifiedSessionId=").append(this.unverifiedSessionId);
        }
        if (this.unverifiedTokenId != null) {
            builder.append(", ");
            builder.append("unverifiedTokenId=").append(this.unverifiedTokenId);
        }
        return builder.append("}").toString();
    }

    public static ImmutableUnverifiedJsonWebToken of(String unverifiedUserId, Optional<String> unverifiedSessionId, Optional<String> unverifiedTokenId) {
        return new ImmutableUnverifiedJsonWebToken(unverifiedUserId, unverifiedSessionId, unverifiedTokenId);
    }

    public static ImmutableUnverifiedJsonWebToken copyOf(UnverifiedJsonWebToken instance) {
        if (instance instanceof ImmutableUnverifiedJsonWebToken) {
            return (ImmutableUnverifiedJsonWebToken)instance;
        }
        return ImmutableUnverifiedJsonWebToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_UNVERIFIED_USER_ID = 1L;
        private long initBits = 1L;
        private String unverifiedUserId;
        private String unverifiedSessionId;
        private String unverifiedTokenId;

        private Builder() {
        }

        public final Builder from(UnverifiedJsonWebToken instance) {
            Optional<String> unverifiedTokenIdOptional;
            Objects.requireNonNull(instance, "instance");
            this.unverifiedUserId(instance.getUnverifiedUserId());
            Optional<String> unverifiedSessionIdOptional = instance.getUnverifiedSessionId();
            if (unverifiedSessionIdOptional.isPresent()) {
                this.unverifiedSessionId(unverifiedSessionIdOptional);
            }
            if ((unverifiedTokenIdOptional = instance.getUnverifiedTokenId()).isPresent()) {
                this.unverifiedTokenId(unverifiedTokenIdOptional);
            }
            return this;
        }

        public final Builder unverifiedUserId(String unverifiedUserId) {
            this.unverifiedUserId = Objects.requireNonNull(unverifiedUserId, "unverifiedUserId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unverifiedSessionId(String unverifiedSessionId) {
            this.unverifiedSessionId = Objects.requireNonNull(unverifiedSessionId, "unverifiedSessionId");
            return this;
        }

        public final Builder unverifiedSessionId(Optional<String> unverifiedSessionId) {
            this.unverifiedSessionId = unverifiedSessionId.orElse(null);
            return this;
        }

        public final Builder unverifiedTokenId(String unverifiedTokenId) {
            this.unverifiedTokenId = Objects.requireNonNull(unverifiedTokenId, "unverifiedTokenId");
            return this;
        }

        public final Builder unverifiedTokenId(Optional<String> unverifiedTokenId) {
            this.unverifiedTokenId = unverifiedTokenId.orElse(null);
            return this;
        }

        public ImmutableUnverifiedJsonWebToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUnverifiedJsonWebToken(null, this.unverifiedUserId, this.unverifiedSessionId, this.unverifiedTokenId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("unverifiedUserId");
            }
            return "Cannot build UnverifiedJsonWebToken, some of required attributes are not set " + attributes;
        }
    }
}

