/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.palantir.tokens.auth.AuthHeader;
import com.palantir.tokens.auth.AuthTokensPreconditions;
import com.palantir.tokens.auth.BearerToken;
import com.palantir.tokens.auth.ImmutableUnverifiedJsonWebToken;
import com.palantir.tokens.auth.ImmutablesStyle;
import com.palantir.tokens.auth.UuidStringConverter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
@ImmutablesStyle
public abstract class UnverifiedJsonWebToken {
    private static final ObjectReader READER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(JwtPayload.class);
    private static final Logger log = LoggerFactory.getLogger(UnverifiedJsonWebToken.class);

    @Value.Parameter
    public abstract String getUnverifiedUserId();

    @Value.Parameter
    public abstract Optional<String> getUnverifiedSessionId();

    @Value.Parameter
    public abstract Optional<String> getUnverifiedTokenId();

    public static Optional<UnverifiedJsonWebToken> tryParse(String rawAuthHeader) {
        if (UnverifiedJsonWebToken.countCharacter(rawAuthHeader, '.') == 2) {
            try {
                return Optional.of(UnverifiedJsonWebToken.of(AuthHeader.valueOf(rawAuthHeader).getBearerToken()));
            }
            catch (Throwable t) {
                log.debug("Unable to process auth header.", t);
            }
        }
        return Optional.empty();
    }

    private static int countCharacter(String input, char toCount) {
        int count = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != toCount) continue;
            ++count;
        }
        return count;
    }

    public static UnverifiedJsonWebToken of(BearerToken token) {
        String[] segments = token.getToken().split("\\.");
        AuthTokensPreconditions.checkArgument(segments.length == 3, "Invalid JWT: expected 3 segments, found %s", segments.length);
        JwtPayload payload = UnverifiedJsonWebToken.extractPayload(segments[1]);
        return ImmutableUnverifiedJsonWebToken.of(UnverifiedJsonWebToken.decodeUuidBytes(payload.sub), Optional.ofNullable(payload.sid).map(UnverifiedJsonWebToken::decodeUuidBytes), Optional.ofNullable(payload.jti).map(UnverifiedJsonWebToken::decodeUuidBytes));
    }

    private static JwtPayload extractPayload(String payload) {
        try {
            return (JwtPayload)READER.readValue(Base64.getDecoder().decode(payload));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JWT: cannot parse payload", e);
        }
    }

    private static String decodeUuidBytes(byte[] bytes) {
        AuthTokensPreconditions.checkArgument(bytes.length == 16, "Invalid JWT: cannot decode UUID, require 16 bytes, found %s", bytes.length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return UuidStringConverter.toString(new UUID(high, low));
    }

    private static class JwtPayload {
        @JsonProperty(value="sub")
        private byte[] sub;
        @JsonProperty(value="sid")
        private byte[] sid;
        @JsonProperty(value="exp")
        private Long exp;
        @JsonProperty(value="jti")
        private byte[] jti;

        private JwtPayload() {
        }
    }
}

