/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.api;

import com.palantir.tracing.api.OpenSpan;
import com.palantir.tracing.api.SpanType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OpenSpan", generator="Immutables")
@Immutable
final class ImmutableOpenSpan
extends OpenSpan {
    private final String operation;
    private final long startTimeMicroSeconds;
    private final long startClockNanoSeconds;
    @Nullable
    private final String parentSpanId;
    private final String spanId;
    private final SpanType type;

    private ImmutableOpenSpan(String operation, long startTimeMicroSeconds, long startClockNanoSeconds, Optional<String> parentSpanId, String spanId, SpanType type) {
        this.operation = Objects.requireNonNull(operation, "operation");
        this.startTimeMicroSeconds = startTimeMicroSeconds;
        this.startClockNanoSeconds = startClockNanoSeconds;
        this.parentSpanId = parentSpanId.orElse(null);
        this.spanId = Objects.requireNonNull(spanId, "spanId");
        this.type = Objects.requireNonNull(type, "type");
    }

    private ImmutableOpenSpan(ImmutableOpenSpan original, String operation, long startTimeMicroSeconds, long startClockNanoSeconds, @Nullable String parentSpanId, String spanId, SpanType type) {
        this.operation = operation;
        this.startTimeMicroSeconds = startTimeMicroSeconds;
        this.startClockNanoSeconds = startClockNanoSeconds;
        this.parentSpanId = parentSpanId;
        this.spanId = spanId;
        this.type = type;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public long getStartTimeMicroSeconds() {
        return this.startTimeMicroSeconds;
    }

    @Override
    public long getStartClockNanoSeconds() {
        return this.startClockNanoSeconds;
    }

    @Override
    public Optional<String> getParentSpanId() {
        return Optional.ofNullable(this.parentSpanId);
    }

    @Override
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public SpanType type() {
        return this.type;
    }

    public final ImmutableOpenSpan withOperation(String value) {
        String newValue = Objects.requireNonNull(value, "operation");
        if (this.operation.equals(newValue)) {
            return this;
        }
        return new ImmutableOpenSpan(this, newValue, this.startTimeMicroSeconds, this.startClockNanoSeconds, this.parentSpanId, this.spanId, this.type);
    }

    public final ImmutableOpenSpan withStartTimeMicroSeconds(long value) {
        if (this.startTimeMicroSeconds == value) {
            return this;
        }
        return new ImmutableOpenSpan(this, this.operation, value, this.startClockNanoSeconds, this.parentSpanId, this.spanId, this.type);
    }

    public final ImmutableOpenSpan withStartClockNanoSeconds(long value) {
        if (this.startClockNanoSeconds == value) {
            return this;
        }
        return new ImmutableOpenSpan(this, this.operation, this.startTimeMicroSeconds, value, this.parentSpanId, this.spanId, this.type);
    }

    public final ImmutableOpenSpan withParentSpanId(String value) {
        String newValue = Objects.requireNonNull(value, "parentSpanId");
        if (Objects.equals(this.parentSpanId, newValue)) {
            return this;
        }
        return new ImmutableOpenSpan(this, this.operation, this.startTimeMicroSeconds, this.startClockNanoSeconds, newValue, this.spanId, this.type);
    }

    public final ImmutableOpenSpan withParentSpanId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.parentSpanId, value)) {
            return this;
        }
        return new ImmutableOpenSpan(this, this.operation, this.startTimeMicroSeconds, this.startClockNanoSeconds, value, this.spanId, this.type);
    }

    public final ImmutableOpenSpan withSpanId(String value) {
        String newValue = Objects.requireNonNull(value, "spanId");
        if (this.spanId.equals(newValue)) {
            return this;
        }
        return new ImmutableOpenSpan(this, this.operation, this.startTimeMicroSeconds, this.startClockNanoSeconds, this.parentSpanId, newValue, this.type);
    }

    public final ImmutableOpenSpan withType(SpanType value) {
        if (this.type == value) {
            return this;
        }
        SpanType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOpenSpan(this, this.operation, this.startTimeMicroSeconds, this.startClockNanoSeconds, this.parentSpanId, this.spanId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOpenSpan && this.equalTo((ImmutableOpenSpan)another);
    }

    private boolean equalTo(ImmutableOpenSpan another) {
        return this.operation.equals(another.operation) && this.startTimeMicroSeconds == another.startTimeMicroSeconds && this.startClockNanoSeconds == another.startClockNanoSeconds && Objects.equals(this.parentSpanId, another.parentSpanId) && this.spanId.equals(another.spanId) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + Long.hashCode(this.startTimeMicroSeconds);
        h += (h << 5) + Long.hashCode(this.startClockNanoSeconds);
        h += (h << 5) + Objects.hashCode(this.parentSpanId);
        h += (h << 5) + this.spanId.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OpenSpan{");
        builder.append("operation=").append(this.operation);
        builder.append(", ");
        builder.append("startTimeMicroSeconds=").append(this.startTimeMicroSeconds);
        builder.append(", ");
        builder.append("startClockNanoSeconds=").append(this.startClockNanoSeconds);
        if (this.parentSpanId != null) {
            builder.append(", ");
            builder.append("parentSpanId=").append(this.parentSpanId);
        }
        builder.append(", ");
        builder.append("spanId=").append(this.spanId);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    public static ImmutableOpenSpan of(String operation, long startTimeMicroSeconds, long startClockNanoSeconds, Optional<String> parentSpanId, String spanId, SpanType type) {
        return new ImmutableOpenSpan(operation, startTimeMicroSeconds, startClockNanoSeconds, parentSpanId, spanId, type);
    }

    public static ImmutableOpenSpan copyOf(OpenSpan instance) {
        if (instance instanceof ImmutableOpenSpan) {
            return (ImmutableOpenSpan)instance;
        }
        return new OpenSpan.Builder().from(instance).build();
    }

    @Generated(from="OpenSpan", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_OPERATION = 1L;
        private static final long INIT_BIT_START_TIME_MICRO_SECONDS = 2L;
        private static final long INIT_BIT_START_CLOCK_NANO_SECONDS = 4L;
        private static final long INIT_BIT_SPAN_ID = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private long initBits = 31L;
        @Nullable
        private String operation;
        private long startTimeMicroSeconds;
        private long startClockNanoSeconds;
        @Nullable
        private String parentSpanId;
        @Nullable
        private String spanId;
        @Nullable
        private SpanType type;

        public Builder() {
            if (!(this instanceof OpenSpan.Builder)) {
                throw new UnsupportedOperationException("Use: new OpenSpan.Builder()");
            }
        }

        public final OpenSpan.Builder from(OpenSpan instance) {
            Objects.requireNonNull(instance, "instance");
            this.operation(instance.getOperation());
            this.startTimeMicroSeconds(instance.getStartTimeMicroSeconds());
            this.startClockNanoSeconds(instance.getStartClockNanoSeconds());
            Optional<String> parentSpanIdOptional = instance.getParentSpanId();
            if (parentSpanIdOptional.isPresent()) {
                this.parentSpanId(parentSpanIdOptional);
            }
            this.spanId(instance.getSpanId());
            this.type(instance.type());
            return (OpenSpan.Builder)this;
        }

        public final OpenSpan.Builder operation(String operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (OpenSpan.Builder)this;
        }

        public final OpenSpan.Builder startTimeMicroSeconds(long startTimeMicroSeconds) {
            this.startTimeMicroSeconds = startTimeMicroSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (OpenSpan.Builder)this;
        }

        public final OpenSpan.Builder startClockNanoSeconds(long startClockNanoSeconds) {
            this.startClockNanoSeconds = startClockNanoSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (OpenSpan.Builder)this;
        }

        public final OpenSpan.Builder parentSpanId(String parentSpanId) {
            this.parentSpanId = Objects.requireNonNull(parentSpanId, "parentSpanId");
            return (OpenSpan.Builder)this;
        }

        public final OpenSpan.Builder parentSpanId(Optional<String> parentSpanId) {
            this.parentSpanId = parentSpanId.orElse(null);
            return (OpenSpan.Builder)this;
        }

        public final OpenSpan.Builder spanId(String spanId) {
            this.spanId = Objects.requireNonNull(spanId, "spanId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (OpenSpan.Builder)this;
        }

        public final OpenSpan.Builder type(SpanType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (OpenSpan.Builder)this;
        }

        public ImmutableOpenSpan build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOpenSpan(null, this.operation, this.startTimeMicroSeconds, this.startClockNanoSeconds, this.parentSpanId, this.spanId, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("startTimeMicroSeconds");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("startClockNanoSeconds");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("spanId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build OpenSpan, some of required attributes are not set " + attributes;
        }
    }
}

