/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.event.AbstractInvocationEventHandler;
import com.palantir.tritium.event.DefaultInvocationContext;
import com.palantir.tritium.event.InstrumentationProperties;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.event.metrics.annotations.AnnotationHelper;
import com.palantir.tritium.event.metrics.annotations.MetricGroup;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MetricsInvocationEventHandler
extends AbstractInvocationEventHandler<InvocationContext> {
    private static final String FAILURES = "failures";
    private final MetricRegistry metricRegistry;
    private final String serviceName;
    private final ImmutableMap<AnnotationHelper.MethodSignature, String> metricGroups;
    @Nullable
    private final String globalGroupPrefix;

    public MetricsInvocationEventHandler(MetricRegistry metricRegistry, String serviceName) {
        super(MetricsInvocationEventHandler.getEnabledSupplier(serviceName));
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry, (String)"metricRegistry");
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"serviceName");
        this.metricGroups = ImmutableMap.of();
        this.globalGroupPrefix = null;
    }

    public MetricsInvocationEventHandler(MetricRegistry metricRegistry, Class<?> serviceClass, String serviceName, @Nullable String globalGroupPrefix) {
        super(MetricsInvocationEventHandler.getEnabledSupplier(serviceName));
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry, (String)"metricRegistry");
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"serviceName");
        this.metricGroups = MetricsInvocationEventHandler.createMethodGroupMapping((Class)Preconditions.checkNotNull(serviceClass));
        this.globalGroupPrefix = Strings.emptyToNull((String)globalGroupPrefix);
    }

    public MetricsInvocationEventHandler(MetricRegistry metricRegistry, Class<?> serviceClass, @Nullable String globalGroupPrefix) {
        this(metricRegistry, serviceClass, (String)Preconditions.checkNotNull((Object)serviceClass.getName()), globalGroupPrefix);
    }

    private static ImmutableMap<AnnotationHelper.MethodSignature, String> createMethodGroupMapping(Class<?> serviceClass) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        MetricGroup classGroup = AnnotationHelper.getSuperTypeAnnotation(serviceClass, MetricGroup.class);
        for (Method method : serviceClass.getMethods()) {
            AnnotationHelper.MethodSignature sig = AnnotationHelper.MethodSignature.of(method);
            MetricGroup methodGroup = AnnotationHelper.getMethodAnnotation(MetricGroup.class, serviceClass, sig);
            if (methodGroup != null) {
                builder.put((Object)sig, (Object)methodGroup.value());
                continue;
            }
            if (classGroup == null) continue;
            builder.put((Object)sig, (Object)classGroup.value());
        }
        return builder.build();
    }

    static BooleanSupplier getEnabledSupplier(String serviceName) {
        return InstrumentationProperties.getSystemPropertySupplier((String)serviceName);
    }

    public InvocationContext preInvocation(@Nonnull Object instance, @Nonnull Method method, @Nonnull Object[] args) {
        return DefaultInvocationContext.of((Object)instance, (Method)method, (Object[])args);
    }

    public void onSuccess(@Nullable InvocationContext context, @Nullable Object _result) {
        this.debugIfNullContext(context);
        if (context != null) {
            long nanos = this.updateTimer(context);
            this.handleSuccessAnnotations(context, nanos);
        }
    }

    public void onFailure(@Nullable InvocationContext context, @Nonnull Throwable cause) {
        this.markGlobalFailure();
        this.debugIfNullContext(context);
        if (context != null) {
            String failuresMetricName = this.getBaseMetricName(context) + ".failures";
            this.metricRegistry.meter(failuresMetricName).mark();
            this.metricRegistry.meter(failuresMetricName + "." + cause.getClass().getName()).mark();
            long nanos = this.updateTimer(context);
            this.handleFailureAnnotations(context, nanos);
        }
    }

    private long updateTimer(InvocationContext context) {
        long nanos = System.nanoTime() - context.getStartTimeNanos();
        this.metricRegistry.timer(this.getBaseMetricName(context)).update(nanos, TimeUnit.NANOSECONDS);
        return nanos;
    }

    private String getBaseMetricName(InvocationContext context) {
        return this.serviceName + "." + context.getMethod().getName();
    }

    private void markGlobalFailure() {
        this.metricRegistry.meter(FAILURES).mark();
    }

    private void handleSuccessAnnotations(InvocationContext context, long nanos) {
        String metricName = this.getAnnotatedMetricName(context);
        if (metricName != null) {
            this.metricRegistry.timer(this.serviceName + "." + metricName).update(nanos, TimeUnit.NANOSECONDS);
            if (this.globalGroupPrefix != null) {
                this.metricRegistry.timer(this.globalGroupPrefix + "." + metricName).update(nanos, TimeUnit.NANOSECONDS);
            }
        }
    }

    private void handleFailureAnnotations(InvocationContext context, long nanos) {
        String metricName = this.getAnnotatedMetricName(context);
        if (metricName != null) {
            this.metricRegistry.timer(this.serviceName + "." + metricName + ".failures").update(nanos, TimeUnit.NANOSECONDS);
            if (this.globalGroupPrefix != null) {
                this.metricRegistry.timer(this.globalGroupPrefix + "." + metricName + ".failures").update(nanos, TimeUnit.NANOSECONDS);
            }
        }
    }

    @Nullable
    private String getAnnotatedMetricName(InvocationContext context) {
        return (String)this.metricGroups.get((Object)AnnotationHelper.MethodSignature.of(context.getMethod()));
    }
}

