/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.event.AbstractInvocationEventHandler;
import com.palantir.tritium.event.DefaultInvocationContext;
import com.palantir.tritium.event.InstrumentationProperties;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TaggedMetricsServiceInvocationEventHandler
extends AbstractInvocationEventHandler<InvocationContext> {
    private static final String FAILURES_METRIC_NAME = "failures";
    private static final MetricName FAILURES_METRIC = MetricName.builder().safeName("failures").build();
    private final TaggedMetricRegistry taggedMetricRegistry;
    private final String serviceName;
    private final Meter globalFailureMeter;
    private final ConcurrentMap<Method, Timer> timerCache = new ConcurrentHashMap<Method, Timer>();
    private final Function<Method, Timer> onSuccessTimerMappingFunction;

    public TaggedMetricsServiceInvocationEventHandler(TaggedMetricRegistry taggedMetricRegistry, String serviceName) {
        super(TaggedMetricsServiceInvocationEventHandler.getEnabledSupplier(serviceName));
        this.taggedMetricRegistry = (TaggedMetricRegistry)Preconditions.checkNotNull((Object)taggedMetricRegistry, (String)"metricRegistry");
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"serviceName");
        this.globalFailureMeter = taggedMetricRegistry.meter(FAILURES_METRIC);
        this.onSuccessTimerMappingFunction = method -> taggedMetricRegistry.timer(MetricName.builder().safeName(serviceName).putSafeTags("service-name", method.getDeclaringClass().getSimpleName()).putSafeTags("endpoint", method.getName()).build());
    }

    private static BooleanSupplier getEnabledSupplier(String serviceName) {
        return InstrumentationProperties.getSystemPropertySupplier((String)serviceName);
    }

    public final InvocationContext preInvocation(@Nonnull Object instance, @Nonnull Method method, @Nonnull Object[] args) {
        return DefaultInvocationContext.of((Object)instance, (Method)method, (Object[])args);
    }

    public final void onSuccess(@Nullable InvocationContext context, @Nullable Object _result) {
        this.debugIfNullContext(context);
        if (context != null) {
            long nanos = System.nanoTime() - context.getStartTimeNanos();
            this.getSuccessTimer(context.getMethod()).update(nanos, TimeUnit.NANOSECONDS);
        }
    }

    private Timer getSuccessTimer(Method method) {
        return this.timerCache.computeIfAbsent(method, this.onSuccessTimerMappingFunction);
    }

    public final void onFailure(@Nullable InvocationContext context, @Nonnull Throwable cause) {
        this.globalFailureMeter.mark();
        this.debugIfNullContext(context);
        if (context != null) {
            MetricName failuresMetricName = MetricName.builder().safeName(this.serviceName + "-failures").putSafeTags("service-name", context.getMethod().getDeclaringClass().getSimpleName()).putSafeTags("endpoint", context.getMethod().getName()).putSafeTags("cause", cause.getClass().getName()).build();
            this.taggedMetricRegistry.meter(failuresMetricName).mark();
        }
    }
}

